<div class="tab-pane fade" id="account-details" role="tabpanel" aria-labelledby="account-details-tab">
    <div class="mb-4">
        <h2 class="mb-3"><?php echo e(translate('Get Account Details')); ?></h2>
        <p>
            <?php echo e(translate('Retrieves details of the account associated with the provided API key')); ?>

        </p>
    </div>
    <h4 class="mb-3"><?php echo e(translate('Endpoint')); ?></h4>
    <div class="code mb-3">
        <div class="copy">
            <i class="far fa-clone"></i>
        </div>
        <code>
            <pre class="mb-0"><div class="method get"><?php echo e(translate('GET')); ?></div><div class="endpoint copy-data"><?php echo e(route('api.account.details')); ?></div></pre>
        </code>
    </div>
    <h4 class="mb-3"><?php echo e(translate('Parameters')); ?></h4>
    <ul>
        <li><strong>api_key</strong>: <?php echo e(translate('Your API key')); ?>

            <code>(<?php echo e(translate('required')); ?>)</code>
        </li>
    </ul>
    <h4 class="mb-3"><?php echo e(translate('Responses')); ?></h4>
    <p><strong><?php echo e(translate('Success Response')); ?>:</strong></p>
    <div class="code mb-3">
        <code>
            <pre class="mb-0 text-success">
{
    "status": "<?php echo e(translate('success')); ?>",
    "data": {
        "name": {
            "firstname": "John",
            "lastname": "Doe",
            "full_name": "John Doe"
        },
        "username": "johndoe",
        "email": "john.doe@example.com",
        "balance": 100.00,
        "currency": "<?php echo e(defaultCurrency()->code); ?>",
        "profile": {
            "heading": "Profile Heading",
            "description": "Profile Description",
            "contact": {
                "email": "contact@example.com"
            },
            "social_links": [
                "facebook": "/",
                "x": "/",
                // etc...
            ],
            "media": {
                "avatar": "https://example.com/avatar.jpg",
                "cover": "https://example.com/cover.jpg"
            }
        },
        "registered_at": "2024-04-27T12:00:00Z"
    }
}</pre>
        </code>
    </div>
    <p><strong><?php echo e(translate('Error Response')); ?>:</strong></p>
    <div class="code mb-3">
        <code>
            <pre class="mb-0 text-danger">
{
    "status": "<?php echo e(translate('error')); ?>",
    "msg": "<?php echo e(translate('Invalid request')); ?>"
}</pre>
        </code>
    </div>
</div>
<?php /**PATH /home/taqwahub/public_html/resources/views/api-docs/sections/account-details.blade.php ENDPATH**/ ?>