<div class="item <?php echo e($item_classes ?? ''); ?>">
    <div class="item-header">
        <?php if($item->isPreviewFileTypeImage()): ?>
            <a href="<?php echo e($item->getLink()); ?>">
                <img class="item-img" src="<?php echo e($item->getPreviewImageLink()); ?>" alt="<?php echo e($item->name); ?>" />
            </a>
        <?php elseif($item->isPreviewFileTypeVideo()): ?>
            <a href="<?php echo e($item->getLink()); ?>" class="opacity-100">
                <div class="item-video">
                    <video class="plyr" poster="<?php echo e($item->getPreviewImageLink()); ?>" muted>
                        <source src="<?php echo e($item->getPreviewLink()); ?>">
                    </video>
                    <div class="item-video-actions d-flex align-items-center justify-content-between gap-1">
                        <div class="item-video-volume item-video-action">
                            <i class="fa-solid fa-volume-high" class="unmuted"></i>
                            <i class="fa-solid fa-volume-xmark" class="muted"></i>
                        </div>
                        <div class="d-flex align-items-center gap-1">
                            <div class="item-video-full item-video-action">
                                <i class="fa fa-expand"></i>
                            </div>
                        </div>
                    </div>
                    <div class="item-video-progress">
                        <span></span>
                    </div>
                </div>
            </a>
        <?php elseif($item->isPreviewFileTypeAudio()): ?>
            <div class="item-audio">
                <a href="<?php echo e($item->getLink()); ?>" class="item-audio-link opacity-100"></a>
                <div class="item-audio-wave">
                    <div class="item-audio-actions">
                        <button class="play-button btn btn-primary btn-sm px-2">
                            <div class="play-button-icon">
                                <i class="fas fa-play"></i>
                            </div>
                        </button>
                        <button class="pause-button btn btn-primary btn-sm px-2 d-none">
                            <div class="play-button-icon">
                                <i class="fas fa-pause"></i>
                            </div>
                        </button>
                    </div>
                    <div class="waveform" data-url="<?php echo e($item->getPreviewLink()); ?>" data-waveheight="50"></div>
                    <div class="total-duration">00:00</div>
                </div>
            </div>
        <?php endif; ?>
        <?php if(licenseType(2) && @$settings->premium->status && $item->isPremium()): ?>
            <div class="item-badge item-badge-premium">
                <i class="fa-solid fa-crown me-1"></i>
                <?php echo e(translate('Premium')); ?>

            </div>
        <?php elseif($item->isFree()): ?>
            <div class="item-badge item-badge-free">
                <i class="fa-regular fa-heart me-1"></i>
                <?php echo e(translate('Free')); ?>

            </div>
        <?php elseif($item->isOnDiscount()): ?>
            <div class="item-badge item-badge-sale">
                <i class="fa-solid fa-tag me-1"></i>
                <?php echo e(translate('On Sale')); ?>

            </div>
        <?php elseif($item->isTrending()): ?>
            <div class="item-badge item-badge-trending">
                <i class="fa-solid fa-bolt me-1"></i>
                <?php echo e(translate('Trending')); ?>

            </div>
        <?php endif; ?>
    </div>
    <div class="item-body">
        <a class="item-title" href="<?php echo e($item->getLink()); ?>"><?php echo e($item->name); ?></a>
        <p class="item-text">
            <?php echo translate('By :username in :category', [
                'username' => "<a href={$item->author->getProfileLink()}>{$item->author->username}</a>",
                'category' => "<a href={$item->category->getLink()}>{$item->category->name}</a>",
            ]); ?>

        </p>
        <?php if($settings->item->reviews_status && $item->hasReviews()): ?>
            <div class="item-ratings">
                <div class="row row-cols-auto align-items-center g-2">
                    <?php echo $__env->make('themes.basic.partials.rating-stars', [
                        'stars' => $item->avg_reviews,
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <div class="col">
                        <span class="text-muted small">
                            (<?php echo e(numberFormat($item->total_reviews)); ?>)
                        </span>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <div class="item-purchase">
            <div class="row row-cols-auto align-items-center justify-content-between g-3">
                <div class="col">
                    <?php if($item->isFree()): ?>
                        <div class="item-price">
                            <span class="item-price-number"><?php echo e(translate('Free')); ?></span>
                        </div>
                    <?php else: ?>
                        <div class="item-price">
                            <?php if($item->isOnDiscount()): ?>
                                <span class="item-price-through">
                                    <?php echo e(getAmount($item->getRegularPrice(), 2, '.', '', true)); ?>

                                </span>
                                <span class="item-price-number">
                                    <?php echo e(getAmount($item->price->regular, 2, '.', '', true)); ?>

                                </span>
                            <?php else: ?>
                                <span class="item-price-number">
                                    <?php echo e(getAmount($item->getRegularPrice(), 2, '.', '', true)); ?>

                                </span>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    <?php if($item->isPurchasingEnabled() && $item->hasSales()): ?>
                        <div class="item-sales">
                            <i class="fa fa-cart-shopping me-1"></i>
                            <?php echo e(translate($item->total_sales > 1 ? ':count Sales' : ':count Sale', ['count' => numberFormat($item->total_sales)])); ?>

                        </div>
                    <?php elseif(@$settings->item->free_item_total_downloads && $item->free_downloads > 1): ?>
                        <div class="item-sales">
                            <i class="fa fa-download me-1"></i>
                            <?php echo e(translate($item->free_downloads > 1 ? ':count Downloads' : ':count Download', ['count' => numberFormat($item->free_downloads)])); ?>

                        </div>
                    <?php endif; ?>
                </div>
                <div class="col">
                    <div class="row row-cols-auto g-2">
                        <?php if($item->isFree()): ?>
                            <div class="col">
                                <?php if($item->isMainFileExternal()): ?>
                                    <a href="<?php echo e(route('items.free.download.external', hash_encode($item->id))); ?>"
                                        target="_blank" class="btn btn-outline-primary btn-md btn-padding">
                                        <i class="fa fa-download"></i>
                                    </a>
                                <?php else: ?>
                                    <form action="<?php echo e(route('items.free.download', hash_encode($item->id))); ?>"
                                        method="POST">
                                        <?php echo csrf_field(); ?>
                                        <button class="btn btn-outline-primary btn-md btn-padding"><i
                                                class="fa-solid fa-download"></i></button>
                                    </form>
                                <?php endif; ?>
                            </div>
                        <?php else: ?>
                            <div class="col">
                                <form data-action="<?php echo e(route('cart.add-item')); ?>" class="add-to-cart-form"
                                    method="POST">
                                    <input type="hidden" name="item_id" value="<?php echo e($item->id); ?>">
                                    <input type="hidden" name="license_type" value="1">
                                    <?php if(@$settings->item->support_status && $item->isSupported() && defaultSupportPeriod()): ?>
                                        <input type="hidden" name="support" value="<?php echo e(defaultSupportPeriod()->id); ?>">
                                    <?php endif; ?>
                                    <button class="btn btn-outline-primary btn-md btn-padding"
                                        <?php if(authUser() && authUser()->id == $item->author_id): echo 'disabled'; endif; ?>>
                                        <i class="fa-solid fa-shopping-cart"></i>
                                    </button>
                                </form>
                            </div>
                        <?php endif; ?>
                        <div class="col">
                            <a href="<?php echo e($item->getLink()); ?>" class="btn btn-outline-secondary btn-md btn-padding">
                                <i class="far fa-eye"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/taqwahub/public_html/resources/views/themes/basic/partials/item.blade.php ENDPATH**/ ?>