<?php if($faqsSection && $faqs->count() > 0): ?>
    <div class="section">
        <div class="container container-custom">
            <div class="section-header">
                <div class="col-lg-7 mx-auto">
                    <div class="section-title mb-0">
                        <h2 class="section-title-text"><?php echo e($faqsSection->name); ?></h2>
                        <div class="section-title-divider"></div>
                    </div>
                    <?php if($faqsSection->description): ?>
                        <p class="section-text mt-3"><?php echo e($faqsSection->description); ?></p>
                    <?php endif; ?>
                </div>
            </div>
            <div class="section-body">
                <div class="accordion-custom">
                    <div class="accordion" id="accordion">
                        <div class="row row-cols-1 row-cols-xl-2 g-3">
                            <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col" data-aos="fade-right"
                                    data-aos-duration="<?php echo e(($loop->index + 1) * 100); ?>">
                                    <div class="accordion-item">
                                        <h2 class="accordion-header" id="heading<?php echo e($faq->id); ?>">
                                            <button class="accordion-button collapsed" type="button"
                                                data-bs-toggle="collapse" data-bs-target="#collapse<?php echo e($faq->id); ?>"
                                                aria-expanded="false" aria-controls="collapse<?php echo e($faq->id); ?>">
                                                <div class="accordion-button-icon">
                                                    <i class="fa fa-plus"></i>
                                                    <i class="fa fa-minus"></i>
                                                </div>
                                                <?php echo e($faq->title); ?>

                                            </button>
                                        </h2>
                                        <div id="collapse<?php echo e($faq->id); ?>" class="accordion-collapse collapse"
                                            aria-labelledby="heading<?php echo e($faq->id); ?>" data-bs-parent="#accordion">
                                            <div class="accordion-body">
                                                <?php echo $faq->body; ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /home/taqwahub/public_html/resources/views/themes/basic/sections/faqs.blade.php ENDPATH**/ ?>