<?php $__env->startSection('title', translate('Advertisements')); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <table class="table datatable2 w-100">
            <thead>
                <tr>
                    <th class="tb-w-2x">#</th>
                    <th class="tb-w-7x"><?php echo e(translate('Position')); ?></th>
                    <th class="tb-w-5x"><?php echo e(translate('Size')); ?></th>
                    <th class="tb-w-5x"><?php echo e(translate('Status')); ?></th>
                    <th class="tb-w-3x"><?php echo e(translate('Last update')); ?></th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $ads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($ad->id); ?></td>
                        <td>
                            <a href="<?php echo e(route('admin.ads.edit', $ad->id)); ?>" class="text-dark">
                                <i class="fas fa-ad me-2"></i><?php echo e(translate($ad->position)); ?>

                            </a>
                        </td>
                        <td><?php echo e($ad->size ?? '--'); ?></td>
                        <td>
                            <?php if($ad->isActive()): ?>
                                <span class="badge bg-success"><?php echo e(translate('Active')); ?></span>
                            <?php else: ?>
                                <span class="badge bg-danger"><?php echo e(translate('Disabled')); ?></span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e(dateFormat($ad->updated_at)); ?></td>
                        <td>
                            <div class="text-end">
                                <button type="button" class="btn btn-sm rounded-3" data-bs-toggle="dropdown"
                                    aria-expanded="true">
                                    <i class="fa fa-ellipsis-v fa-sm text-muted"></i>
                                </button>
                                <ul class="dropdown-menu dropdown-menu-sm-end" data-popper-placement="bottom-end">
                                    <li>
                                        <a class="dropdown-item" href="<?php echo e(route('admin.ads.edit', $ad->id)); ?>"><i
                                                class="fa fa-edit me-2"></i><?php echo e(translate('Edit')); ?></a>
                                    </li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.grid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/taqwahub/public_html/resources/views/admin/ads/index.blade.php ENDPATH**/ ?>