<?php if(authUser()): ?>
    <?php if($user->id != authUser()->id): ?>
        <button wire:click="followAction"
            class="btn <?php echo e(authUser()->isFollowingUser($user->id) ? 'btn-custom' : 'btn-outline-custom'); ?> <?php echo e($iconButton ? 'btn-padding' : ''); ?>">
            <?php if(authUser()->isFollowingUser($user->id)): ?>
                <i class="fa-solid fa-user-check"></i>
                <?php if(!$iconButton): ?>
                    <span class="ms-1"><?php echo e(translate('Following')); ?></span>
                <?php endif; ?>
            <?php else: ?>
                <i class="fa-solid fa-user-plus"></i>
                <?php if(!$iconButton): ?>
                    <span class="ms-1"><?php echo e(translate('Follow')); ?></span>
                <?php endif; ?>
            <?php endif; ?>
        </button>
    <?php else: ?>
        <button class="btn btn-outline-custom <?php echo e($iconButton ? 'btn-padding' : ''); ?> disabled">
            <i class="fa-solid fa-user-plus"></i>
            <?php if(!$iconButton): ?>
                <span class="ms-1"><?php echo e(translate('Follow')); ?></span>
            <?php endif; ?>
        </button>
    <?php endif; ?>
<?php else: ?>
    <a href="<?php echo e(route('login')); ?>" class="btn btn-outline-custom <?php echo e($iconButton ? 'btn-padding' : ''); ?>">
        <i class="fa-solid fa-user-plus"></i>
        <?php if(!$iconButton): ?>
            <span class="ms-1"><?php echo e(translate('Follow')); ?></span>
        <?php endif; ?>
    </a>
<?php endif; ?>
<?php /**PATH /home/taqwahub/public_html/resources/views/themes/basic/livewire/follow-button.blade.php ENDPATH**/ ?>