<?php $__env->startSection('section', translate('Records')); ?>
<?php $__env->startSection('title', translate('Refunds')); ?>
<?php $__env->startSection('container', 'container-max-xxl'); ?>
<?php $__env->startSection('content'); ?>
    <div class="row g-3 mb-4">
        <div class="col-12 col-lg-6 col-xxl-4">
            <div class="vironeer-counter-card bg-orange">
                <div class="vironeer-counter-card-bg"></div>
                <div class="vironeer-counter-card-icon">
                    <i class="fa-solid fa-hourglass-half"></i>
                </div>
                <div class="vironeer-counter-card-meta">
                    <p class="vironeer-counter-card-title"><?php echo e(translate('Pending')); ?></p>
                    <p class="vironeer-counter-card-number"><?php echo e(numberFormat($counters['pending'])); ?></p>
                </div>
            </div>
        </div>
        <div class="col-12 col-lg-6 col-xxl-4">
            <div class="vironeer-counter-card bg-green">
                <div class="vironeer-counter-card-bg"></div>
                <div class="vironeer-counter-card-icon">
                    <i class="fa-solid fa-circle-check"></i>
                </div>
                <div class="vironeer-counter-card-meta">
                    <p class="vironeer-counter-card-title"><?php echo e(translate('Accepted')); ?></p>
                    <p class="vironeer-counter-card-number"><?php echo e(numberFormat($counters['accepted'])); ?></p>
                </div>
            </div>
        </div>
        <div class="col-12 col-lg-12 col-xxl-4">
            <div class="vironeer-counter-card bg-red">
                <div class="vironeer-counter-card-bg"></div>
                <div class="vironeer-counter-card-icon">
                    <i class="fa-solid fa-circle-xmark"></i>
                </div>
                <div class="vironeer-counter-card-meta">
                    <p class="vironeer-counter-card-title"><?php echo e(translate('Declined')); ?></p>
                    <p class="vironeer-counter-card-number"><?php echo e(numberFormat($counters['declined'])); ?></p>
                </div>
            </div>
        </div>
    </div>
    <div class="card">
        <div class="card-header p-3 border-bottom-small">
            <form action="<?php echo e(url()->current()); ?>" method="GET">
                <div class="row g-3">
                    <div class="col-12 col-lg-6">
                        <input type="text" name="search" class="form-control" placeholder="<?php echo e(translate('Search...')); ?>"
                            value="<?php echo e(request('search') ?? ''); ?>">
                    </div>
                    <div class="col-12 col-lg-2">
                        <input type="text" name="date_from" class="form-control text-secondary"
                            placeholder="<?php echo e(translate('From Date')); ?>" onfocus="(this.type='date')"
                            onblur="(this.type='text')" value="<?php echo e(request('date_from')); ?>">
                    </div>
                    <div class="col-12 col-lg-2">
                        <input type="text" name="date_to" class="form-control text-secondary"
                            placeholder="<?php echo e(translate('To Date')); ?>" onfocus="(this.type='date')"
                            onblur="(this.type='text')" value="<?php echo e(request('date_to')); ?>">
                    </div>
                    <div class="col">
                        <button class="btn btn-primary w-100"><i class="fa fa-search"></i></button>
                    </div>
                    <div class="col">
                        <a href="<?php echo e(url()->current()); ?>" class="btn btn-secondary w-100"><?php echo e(translate('Reset')); ?></a>
                    </div>
                </div>
            </form>
        </div>
        <div>
            <?php if($refunds->count() > 0): ?>
                <div class="overflow-hidden">
                    <div class="table-custom-container">
                        <table class="table-custom table">
                            <thead>
                                <tr class="bg-light">
                                    <th><?php echo e(translate('ID')); ?></th>
                                    <th><?php echo e(translate('Purchase')); ?></th>
                                    <th><?php echo e(translate('Author')); ?></th>
                                    <th><?php echo e(translate('Buyer')); ?></th>
                                    <th class="text-center"><?php echo e(translate('Status')); ?></th>
                                    <th class="text-center"><?php echo e(translate('Date')); ?></th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $refunds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $refund): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <a href="<?php echo e(route('admin.records.refunds.show', $refund->id)); ?>"><i
                                                    class="fa-solid fa-hashtag me-1"></i><?php echo e($refund->id); ?></a>
                                        </td>
                                        <td>
                                            <a href="<?php echo e(route('admin.records.purchases.show', $refund->purchase->id)); ?>"
                                                class="text-dark">
                                                <i class="fa-solid fa-up-right-from-square me-1"></i>
                                                <?php echo e(shorterText($refund->purchase->item->name, 40)); ?>

                                            </a>
                                        </td>
                                        <td>
                                            <a href="<?php echo e(route('admin.members.users.edit', $refund->author->id)); ?>"
                                                class="text-dark">
                                                <i class="fa fa-user me-1"></i>
                                                <?php echo e($refund->author->username); ?>

                                            </a>
                                        </td>
                                        <td>
                                            <a href="<?php echo e(route('admin.members.users.edit', $refund->user->id)); ?>"
                                                class="text-dark">
                                                <i class="fa-regular fa-user me-1"></i>
                                                <?php echo e($refund->user->username); ?>

                                            </a>
                                        </td>
                                        <td class="text-center">
                                            <?php if($refund->isPending()): ?>
                                                <div class="badge bg-orange rounded-2 fw-light px-3 py-2">
                                                    <?php echo e($refund->getStatusName()); ?>

                                                </div>
                                            <?php elseif($refund->isAccepted()): ?>
                                                <div class="badge bg-green rounded-2 fw-light px-3 py-2">
                                                    <?php echo e($refund->getStatusName()); ?>

                                                </div>
                                            <?php else: ?>
                                                <div class="badge bg-red rounded-2 fw-light px-3 py-2">
                                                    <?php echo e($refund->getStatusName()); ?>

                                                </div>
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-center"><?php echo e(dateFormat($refund->created_at)); ?></td>
                                        <td>
                                            <div class="text-end">
                                                <button type="button" class="btn btn-sm rounded-3"
                                                    data-bs-toggle="dropdown" aria-expanded="true">
                                                    <i class="fa fa-ellipsis-v fa-sm text-muted"></i>
                                                </button>
                                                <ul class="dropdown-menu dropdown-menu-sm-end"
                                                    data-popper-placement="bottom-end">
                                                    <li>
                                                        <a class="dropdown-item"
                                                            href="<?php echo e(route('admin.records.refunds.show', $refund->id)); ?>">
                                                            <i class="fa-solid fa-desktop me-1"></i>
                                                            <?php echo e(translate('Details')); ?>

                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item"
                                                            href="<?php echo e(route('admin.records.purchases.show', $refund->purchase->id)); ?>"
                                                            target="_blank">
                                                            <i class="fa-solid fa-up-right-from-square me-1"></i>
                                                            <?php echo e(translate('View Purchase')); ?>

                                                        </a>
                                                    </li>
                                                    <li>
                                                        <hr class="dropdown-divider" />
                                                    </li>
                                                    <li>
                                                        <form
                                                            action="<?php echo e(route('admin.records.refunds.destroy', $refund->id)); ?>"
                                                            method="POST">
                                                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                                            <button class="action-confirm dropdown-item text-danger">
                                                                <i class="far fa-trash-alt me-1"></i>
                                                                <?php echo e(translate('Delete')); ?>

                                                            </button>
                                                        </form>
                                                    </li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            <?php else: ?>
                <?php echo $__env->make('admin.partials.empty', ['empty_classes' => 'empty-lg'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.grid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/taqwahub/public_html/resources/views/admin/records/refunds/index.blade.php ENDPATH**/ ?>