<!DOCTYPE html>
<html lang="<?php echo e(getLocale()); ?>" dir="<?php echo e(getDirection()); ?>">

<head>
    <?php $__env->startPush('styles_libs'); ?>
        <link rel="stylesheet" href="<?php echo e(asset('vendor/libs/swiper/swiper-bundle.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('vendor/libs/jquery/fancybox/jquery.fancybox.min.css')); ?>">
    <?php $__env->stopPush(); ?>
    <?php echo $__env->make('themes.basic.includes.head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>

<body>
    <?php echo $__env->make('themes.basic.includes.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php if (isset($component)) { $__componentOriginalfd18b85732e6a336f727c097d7e6751f = $component; } ?>
<?php $component = App\View\Components\Ad::resolve(['alias' => 'item_page_top'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('ad'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Ad::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(\Illuminate\Support\Arr::toCssClasses('container mt-5'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfd18b85732e6a336f727c097d7e6751f)): ?>
<?php $component = $__componentOriginalfd18b85732e6a336f727c097d7e6751f; ?>
<?php unset($__componentOriginalfd18b85732e6a336f727c097d7e6751f); ?>
<?php endif; ?>
    <section class="section forced-start pt-5 pb-3">
        <div class="container">
            <div class="section-header mb-4">
                <?php echo $__env->yieldContent('breadcrumbs'); ?>
                <div class="row g-3 align-items-center">
                    <div class="col-12 col-lg">
                        <h1
                            class="item-single-title h2 <?php echo e(($settings->item->reviews_status && $item->hasReviews()) || $item->hasSales() ? 'mb-2' : 'mb-0'); ?>">
                            <?php echo e($item->name); ?>

                        </h1>
                        <?php if(($settings->item->reviews_status && $item->hasReviews()) || $item->hasSales() || $item->isRecentlyUpdated()): ?>
                            <div class="row row-cols-auto g-2">
                                <?php if($settings->item->reviews_status && $item->hasReviews()): ?>
                                    <div class="col">
                                        <a href="<?php echo e($item->getReviewsLink()); ?>">
                                            <div class="row row-cols-auto align-items-center g-2">
                                                <div class="col">
                                                    <?php echo $__env->make('themes.basic.partials.rating-stars', [
                                                        'stars' => $item->avg_reviews,
                                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                </div>
                                                <div class="col">
                                                    <span class="text-muted">
                                                        <?php echo e(translate($item->total_reviews > 1 ? '(:count Reviews)' : '(:count Review)', [
                                                            'count' => number_format($item->total_reviews),
                                                        ])); ?>

                                                    </span>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                    <?php if($item->hasSales() || $item->isRecentlyUpdated()): ?>
                                        <div class="col">
                                            <span>-</span>
                                        </div>
                                    <?php endif; ?>
                                <?php endif; ?>
                                <?php if($item->isPurchasingEnabled() && $item->hasSales()): ?>
                                    <div class="col">
                                        <i class="fa fa-cart-shopping me-1"></i>
                                        <span><?php echo e(translate($item->total_sales > 1 ? ':count Sales' : ':count Sale', [
                                            'count' => number_format($item->total_sales),
                                        ])); ?></span>
                                    </div>
                                    <?php if($item->isRecentlyUpdated()): ?>
                                        <div class="col">
                                            <span>-</span>
                                        </div>
                                    <?php endif; ?>
                                <?php endif; ?>
                                <?php if($item->isRecentlyUpdated()): ?>
                                    <div class="col text-primary">
                                        <i class="fa-solid fa-circle-check me-1"></i>
                                        <span class="fw-bold"><?php echo e(translate('Recently Updated')); ?></span>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-12 col-lg-auto">
                        <div class="row g-3">
                            <div class="col">
                                <div class="row g-3">
                                    <?php if($item->demo_link): ?>
                                        <div class="col-auto">
                                            <a href="<?php echo e($item->getDemoLink()); ?>" target="_blank"
                                                class="btn btn-outline-secondary btn-md px-3">
                                                <i class="fa-solid fa-up-right-from-square"></i>
                                                <span class="ms-1"><?php echo e(translate('Live Preview')); ?></span>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                    <div class="col-auto">
                                        <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('item.favorite-button', ['item' => $item])->html();
} elseif ($_instance->childHasBeenRendered('rOJC7p6')) {
    $componentId = $_instance->getRenderedChildComponentId('rOJC7p6');
    $componentTag = $_instance->getRenderedChildComponentTagName('rOJC7p6');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('rOJC7p6');
} else {
    $response = \Livewire\Livewire::mount('item.favorite-button', ['item' => $item]);
    $html = $response->html();
    $_instance->logRenderedChild('rOJC7p6', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                                    </div>
                                </div>
                            </div>
                            <?php if($item->isFree()): ?>
                                <div class="col-auto d-inline d-lg-none">
                                    <?php if($item->isMainFileExternal()): ?>
                                        <a href="<?php echo e(route('items.free.download.external', hash_encode($item->id))); ?>"
                                            target="_blank" class="btn btn-primary btn-md px-3">
                                            <i class="fa fa-download"></i>
                                        </a>
                                    <?php else: ?>
                                        <form action="<?php echo e(route('items.free.download', hash_encode($item->id))); ?>"
                                            method="POST">
                                            <?php echo csrf_field(); ?>
                                            <button class="btn btn-primary btn-md px-3">
                                                <i class="fa-solid fa-download"></i>
                                            </button>
                                        </form>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                            <?php if($item->isPurchasingEnabled()): ?>
                                <div class="col-auto d-inline d-lg-none">
                                    <form data-action="<?php echo e(route('cart.add-item')); ?>" class="add-to-cart-form"
                                        method="POST">
                                        <input type="hidden" name="item_id" value="<?php echo e($item->id); ?>">
                                        <input type="hidden" name="license_type" value="1">
                                        <?php if(@$settings->item->support_status && defaultSupportPeriod() && $item->isSupported()): ?>
                                            <input type="hidden" name="support"
                                                value="<?php echo e(defaultSupportPeriod()->id); ?>">
                                        <?php endif; ?>
                                        <button class="btn btn-primary btn-md px-3" <?php if(authUser() && authUser()->id == $item->author_id): echo 'disabled'; endif; ?>>
                                            <i class="fa fa-cart-shopping me-2"></i>
                                            <span><?php echo e(getAmount($item->price->regular, 2, '.', '', true)); ?></span>
                                        </button>
                                    </form>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="section-body">
                <div class="row g-4">
                    <div class="col-12 col-lg-7 col-xl-7 col-xxl-8">
                        <div class="card-v border p-4 mb-4">
                            <div class="item-single-preview">
                                <?php if($item->isPreviewFileTypeImage()): ?>
                                    <div class="item-single-img">
                                        <img src="<?php echo e($item->getPreviewImageLink()); ?>" alt="<?php echo e($item->name); ?>" />
                                    </div>
                                    <?php if($item->screenshots): ?>
                                        <div class="item-swiper mt-3">
                                            <div class="swiper-actions">
                                                <div id="itemSwiperPrev" class="swiper-button-prev">
                                                    <i class="fa fa-chevron-left fa-rtl"></i>
                                                </div>
                                            </div>
                                            <div class="swiper itemSwiper">
                                                <div class="swiper-wrapper">
                                                    <?php $__currentLoopData = $item->getScreenshotLinks(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $screenshot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="swiper-slide">
                                                            <a href="<?php echo e($screenshot); ?>" class="item-slide-img"
                                                                data-fancybox="itemSlide">
                                                                <img src="<?php echo e($screenshot); ?>"
                                                                    alt="<?php echo e($item->name); ?>" />
                                                            </a>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </div>
                                            <div class="swiper-actions">
                                                <div id="itemSwiperNext" class="swiper-button-next">
                                                    <i class="fa fa-chevron-right fa-rtl"></i>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                <?php elseif($item->isPreviewFileTypeVideo()): ?>
                                    <div class="item-single-video">
                                        <video class="video-plyr" poster="<?php echo e($item->getPreviewImageLink()); ?>" controls>
                                            <source src="<?php echo e($item->getPreviewLink()); ?>">
                                        </video>
                                    </div>
                                <?php elseif($item->isPreviewFileTypeAudio()): ?>
                                    <div class="item-single-audio">
                                        <div class="item-audio-wave">
                                            <div class="item-audio-actions md">
                                                <button class="play-button btn btn-primary btn-md px-2">
                                                    <div class="play-button-icon">
                                                        <i class="fas fa-play"></i>
                                                    </div>
                                                </button>
                                                <button class="pause-button btn btn-primary btn-md px-2 d-none">
                                                    <div class="play-button-icon">
                                                        <i class="fas fa-pause"></i>
                                                    </div>
                                                </button>
                                            </div>
                                            <div class="current-time fs-5">00:00</div>
                                            <div class="waveform" data-url="<?php echo e($item->getPreviewLink()); ?>"
                                                data-waveheight="100"></div>
                                            <div class="total-duration fs-5">00:00</div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php if(licenseType(2) && $item->isPremium()): ?>
                                    <div class="item-badge item-badge-premium">
                                        <i class="fa-solid fa-crown me-1"></i>
                                        <?php echo e(translate('Premium')); ?>

                                    </div>
                                <?php elseif($item->isFree()): ?>
                                    <div class="item-badge item-badge-free">
                                        <i class="fa-regular fa-heart me-1"></i>
                                        <?php echo e(translate('Free')); ?>

                                    </div>
                                <?php elseif($item->isOnDiscount()): ?>
                                    <div class="item-badge item-badge-sale">
                                        <i class="fa-solid fa-tag me-1"></i>
                                        <?php echo e(translate('On Sale')); ?>

                                    </div>
                                <?php elseif($item->isTrending()): ?>
                                    <div class="item-badge item-badge-trending">
                                        <i class="fa-solid fa-bolt me-1"></i>
                                        <?php echo e(translate('Trending')); ?>

                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="tabs-custom">
                            <div class="card-v border p-4">
                                <?php
                                    $itemSettings = $settings->item;
                                ?>
                                <?php if(
                                    @$itemSettings->reviews_status ||
                                        @$itemSettings->comments_status ||
                                        @$itemSettings->changelogs_status ||
                                        @$itemSettings->support_status): ?>
                                    <div class="row row-cols-1 row-cols-lg-2 row-cols-xxl-3 g-3  mb-4">
                                        <div class="col">
                                            <a href="<?php echo e($item->getLink()); ?>"
                                                class="btn <?php echo e(request()->routeIs('items.view') ? 'btn-primary' : 'btn-outline-secondary'); ?> btn-md w-100">
                                                <i class="fa-regular fa-circle-question me-1"></i>
                                                <span><?php echo e(translate('Description')); ?></span>
                                            </a>
                                        </div>
                                        <?php if($settings->item->changelogs_status && $item->hasChangelogs()): ?>
                                            <div class="col">
                                                <a href="<?php echo e($item->getChangeLogsLink()); ?>"
                                                    class="btn <?php echo e(request()->routeIs('items.changelogs') ? 'btn-primary' : 'btn-outline-secondary'); ?> btn-md w-100">
                                                    <i class="fa-solid fa-rotate me-1"></i>
                                                    <span><?php echo e(translate('Changelogs')); ?></span>
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                        <?php if(
                                            ($settings->item->reviews_status && $item->hasReviews()) ||
                                                ($settings->item->reviews_status && authUser() && authUser()->hasPurchasedItem($item->id))): ?>
                                            <div class="col">
                                                <a href="<?php echo e($item->getReviewsLink()); ?>"
                                                    class="btn <?php echo e(request()->routeIs('items.reviews') ? 'btn-primary' : 'btn-outline-secondary'); ?> btn-md w-100">
                                                    <i class="fa-regular fa-star me-1"></i>
                                                    <span><?php echo e(translate('Reviews (:count)', ['count' => numberFormat($item->total_reviews)])); ?></span>
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                        <?php if(@$itemSettings->comments_status): ?>
                                            <div class="col">
                                                <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('item.comments-counter', ['item' => $item,'isActive' => request()->routeIs('items.comments') ? true : false])->html();
} elseif ($_instance->childHasBeenRendered('cDkELEM')) {
    $componentId = $_instance->getRenderedChildComponentId('cDkELEM');
    $componentTag = $_instance->getRenderedChildComponentTagName('cDkELEM');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('cDkELEM');
} else {
    $response = \Livewire\Livewire::mount('item.comments-counter', ['item' => $item,'isActive' => request()->routeIs('items.comments') ? true : false]);
    $html = $response->html();
    $_instance->logRenderedChild('cDkELEM', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                                            </div>
                                        <?php endif; ?>
                                        <?php if(@$itemSettings->support_status && $item->isSupported()): ?>
                                            <div class="col">
                                                <a href="<?php echo e($item->getSupportLink()); ?>"
                                                    class="btn <?php echo e(request()->routeIs('items.support') ? 'btn-primary' : 'btn-outline-secondary'); ?> btn-md w-100">
                                                    <i class="fa-solid fa-headset me-1"></i>
                                                    <span><?php echo e(translate('Support')); ?></span>
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                                <?php echo $__env->yieldContent('content'); ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-lg-5 col-xl-5 col-xxl-4">
                        <?php if(licenseType(2) && @$settings->premium->status && $item->isPremium()): ?>
                            <?php if(authUser() && authUser()->isSubscribed()): ?>
                                <div class="card-v border border-2 border-primary p-3 mb-4">
                                    <div class="card-v-body text-center p-3">
                                        <div class="mb-4">
                                            <div class="mb-3">
                                                <i class="fa-solid fa-download text-primary fa-3x"></i>
                                            </div>
                                            <h3 class="mb-3"><?php echo e(translate('Premium download')); ?></h3>
                                            <p class="mb-0">
                                                <?php echo e(translate('You are subscribed to a premium plan. You can download this item directly.')); ?>

                                            </p>
                                        </div>
                                        <?php if($item->isMainFileExternal()): ?>
                                            <a href="<?php echo e(route('items.premium.download.external', hash_encode($item->id))); ?>"
                                                target="_blank"
                                                class="btn btn-primary btn-md w-100 <?php echo e($item->author->id == authUser()->id ? 'disabled' : ''); ?>">
                                                <i class="fa-solid fa-download me-1"></i>
                                                <?php echo e(translate('Download')); ?>

                                            </a>
                                        <?php else: ?>
                                            <form
                                                action="<?php echo e(route('items.premium.download', hash_encode($item->id))); ?>"
                                                method="POST">
                                                <?php echo csrf_field(); ?>
                                                <button
                                                    class="btn btn-primary btn-md w-100 <?php echo e($item->author->id == authUser()->id ? 'disabled' : ''); ?>">
                                                    <i class="fa-solid fa-download me-1"></i>
                                                    <?php echo e(translate('Download')); ?>

                                                </button>
                                            </form>
                                        <?php endif; ?>
                                        <?php if($item->author->id != authUser()->id): ?>
                                            <div class="text-center mt-3">
                                                <a href="<?php echo e(route('items.premium.license', encrypt($item->id))); ?>"
                                                    target="_blank">
                                                    <?php echo e(translate('License certificate')); ?>

                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php else: ?>
                                <div class="card-v border border-2 border-premium p-3 mb-4">
                                    <div class="card-v-body p-4">
                                        <div class="mb-4">
                                            <div class="mb-3">
                                                <i class="fa-solid fa-crown text-premium fa-3x"></i>
                                            </div>
                                            <h3 class="mb-3"><?php echo e(translate('Get unlimited downloads')); ?></h3>
                                            <p class="mb-0">
                                                <?php echo e(translate('Subscribe to access unlimited downloads of themes, videos, graphics, plugins, and more premium assets for your creative needs.')); ?>

                                            </p>
                                        </div>
                                        <a href="<?php echo e(route('premium.index')); ?>"
                                            class="btn btn-premium btn-md w-100"><?php echo e(translate('Subscribe to download')); ?></a>
                                        <?php if(@$settings->premium->terms_link): ?>
                                            <div class="text-center mt-3">
                                                <a href="<?php echo e(@$settings->premium->terms_link); ?>" class="text-premium"
                                                    target="_blank">
                                                    <?php echo e(translate('Learn more about premium')); ?>

                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                        <?php if($item->isFree()): ?>
                            <div class="card-v border p-0 mb-4">
                                <div class="card-v-header border-bottom py-3 px-4">
                                    <div class="row row-cols-auto align-items-center justify-content-between g-2">
                                        <div class="col">
                                            <h5 class="mb-0"><?php echo e(translate('Free Item')); ?></h5>
                                        </div>
                                        <?php if(@$settings->links->free_items_policy_link): ?>
                                            <div class="col small">
                                                <a href="<?php echo e(@$settings->links->free_items_policy_link); ?>">
                                                    <span><?php echo e(translate('Free items policy')); ?></span>
                                                    <i class="fa fa-chevron-right fa-rtl ms-1 fa-sm"></i>
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="card-v-body p-4">
                                    <p class="text-muted">
                                        <?php echo e(translate('The author :author has offered the item for free, you can now download it.', [
                                            'author' => strtolower($item->author->username),
                                        ])); ?>

                                    </p>
                                    <?php if($item->isMainFileExternal()): ?>
                                        <a href="<?php echo e(route('items.free.download.external', hash_encode($item->id))); ?>"
                                            target="_blank" class="btn btn-primary btn-md w-100">
                                            <i class="fa fa-download me-1"></i>
                                            <?php echo e(translate('Download')); ?>

                                        </a>
                                    <?php else: ?>
                                        <form action="<?php echo e(route('items.free.download', hash_encode($item->id))); ?>"
                                            method="POST">
                                            <?php echo csrf_field(); ?>
                                            <button class="btn btn-primary btn-md w-100">
                                                <i class="fa-solid fa-download me-1"></i>
                                                <?php echo e(translate('Download')); ?>

                                            </button>
                                        </form>
                                    <?php endif; ?>
                                    <?php if(authUser()): ?>
                                        <div class="text-center mt-3">
                                            <a href="<?php echo e(route('items.free.license', encrypt($item->id))); ?>"
                                                target="_blank">
                                                <?php echo e(translate('License certificate')); ?>

                                            </a>
                                        </div>
                                    <?php else: ?>
                                        <div class="text-center mt-3">
                                            <a href="<?php echo e(route('login')); ?>">
                                                <?php echo e(translate('License certificate')); ?>

                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if($item->isPurchasingEnabled()): ?>
                            <div class="card-v border p-0">
                                <div class="card-v-header border-bottom py-3 px-4">
                                    <div class="row row-cols-auto align-items-center justify-content-between g-2">
                                        <div class="col">
                                            <h5 class="mb-0"><?php echo e(translate('License Option')); ?></h5>
                                        </div>
                                        <?php if(@$settings->links->licenses_terms_link): ?>
                                            <div class="col small">
                                                <a href="<?php echo e(@$settings->links->licenses_terms_link); ?>">
                                                    <span><?php echo e(translate('Licenses terms')); ?></span>
                                                    <i class="fa fa-chevron-right fa-rtl ms-1 fa-sm"></i>
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="card-v-body p-4">
                                    <form data-action="<?php echo e(route('cart.add-item')); ?>" class="add-to-cart-form"
                                        method="POST">
                                        <input type="hidden" name="item_id" value="<?php echo e($item->id); ?>">
                                        <div class="form-check form-check-lg mb-3">
                                            <input id="license-type-regular"
                                                class="form-check-input license-type mt-1" type="radio"
                                                name="license_type" value="1" checked>
                                            <label class="form-check-label d-flex justify-content-between"
                                                for="license-type-regular">
                                                <div>
                                                    <h6 class="mb-1"><?php echo e(translate('Regular')); ?></h6>
                                                    <span
                                                        class="small text-muted"><?php echo e(translate('For one project')); ?></span>
                                                </div>
                                                <div class="item-price">
                                                    <?php if($item->isOnDiscount()): ?>
                                                        <span class="item-price-through">
                                                            <?php echo e(getAmount($item->getRegularPrice(), 2, '.', '', true)); ?>

                                                        </span>
                                                        <span class="item-price-number">
                                                            <?php echo e(getAmount($item->price->regular, 2, '.', '', true)); ?>

                                                        </span>
                                                    <?php else: ?>
                                                        <span class="item-price-number">
                                                            <?php echo e(getAmount($item->getRegularPrice(), 2, '.', '', true)); ?>

                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </label>
                                        </div>
                                        <div class="form-check form-check-lg mb-3">
                                            <input id="license-type-extended"
                                                class="form-check-input license-type mt-1" type="radio"
                                                name="license_type" value="2">
                                            <label class="form-check-label d-flex justify-content-between"
                                                for="license-type-extended">
                                                <div>
                                                    <h6 class="mb-1"><?php echo e(translate('Extended')); ?></h6>
                                                    <span
                                                        class="small text-muted"><?php echo e(translate('For unlimited projects')); ?></span>
                                                </div>
                                                <div class="item-price">
                                                    <?php if($item->isOnDiscount() && $item->isExtendedOnDiscount()): ?>
                                                        <span class="item-price-through">
                                                            <?php echo e(getAmount($item->getExtendedPrice(), 2, '.', '', true)); ?>

                                                        </span>
                                                        <span class="item-price-number">
                                                            <?php echo e(getAmount($item->price->extended, 2, '.', '', true)); ?>

                                                        </span>
                                                    <?php else: ?>
                                                        <span class="item-price-number">
                                                            <?php echo e(getAmount($item->getExtendedPrice(), 2, '.', '', true)); ?>

                                                        </span>
                                                    <?php endif; ?>
                                                </div>
                                            </label>
                                        </div>
                                        <?php if(@$settings->item->support_status): ?>
                                            <?php if($item->isSupported()): ?>
                                                <?php
                                                    $supportPeriods = supportPeriods();
                                                ?>
                                                <?php if($supportPeriods->count() > 0): ?>
                                                    <div class="p-4 bg-light mb-3 rounded-3">
                                                        <div class="row g-2">
                                                            <?php $__currentLoopData = $supportPeriods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supportPeriod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <div class="col-12">
                                                                    <div class="row g-3">
                                                                        <div class="col">
                                                                            <div class="form-check">
                                                                                <input
                                                                                    class="form-check-input item-support"
                                                                                    type="radio" name="support"
                                                                                    id="support<?php echo e($supportPeriod->id); ?>"
                                                                                    value="<?php echo e($supportPeriod->id); ?>"
                                                                                    <?php if($supportPeriod->isDefault()): echo 'checked'; endif; ?>>
                                                                                <label class="form-check-label"
                                                                                    for="support<?php echo e($supportPeriod->id); ?>">
                                                                                    <?php echo e($supportPeriod->title); ?>

                                                                                </label>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-auto">
                                                                            <strong class="regular-support">
                                                                                <?php echo e($supportPeriod->isFree() ? translate('Free') : getAmount(($item->price->regular * $supportPeriod->percentage) / 100)); ?>

                                                                            </strong>
                                                                            <strong class="extended-support d-none">
                                                                                <?php echo e($supportPeriod->isFree() ? translate('Free') : getAmount(($item->price->extended * $supportPeriod->percentage) / 100)); ?>

                                                                            </strong>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                        <button class="btn btn-primary btn-md w-100" <?php if(authUser() && authUser()->id == $item->author_id): echo 'disabled'; endif; ?>>
                                            <i class="fa fa-cart-shopping me-1"></i>
                                            <?php echo e(translate('Add to Cart')); ?>

                                        </button>
                                    </form>
                                    <?php if(@$itemSettings->buy_now_button): ?>
                                        <form action="<?php echo e(route('items.buy-now', [$item->slug, $item->id])); ?>"
                                            class="buy-now-form" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="item_id" value="<?php echo e($item->id); ?>">
                                            <input type="hidden" name="license_type" value="1">
                                            <?php if(@$settings->item->support_status && defaultSupportPeriod() && $item->isSupported()): ?>
                                                <input type="hidden" name="support"
                                                    value="<?php echo e(defaultSupportPeriod()->id); ?>">
                                            <?php endif; ?>
                                            <button class="btn btn-outline-primary btn-md w-100 mt-3"
                                                <?php if(authUser() && authUser()->id == $item->author_id): echo 'disabled'; endif; ?>>
                                                <?php echo e(translate('Buy Now')); ?>

                                            </button>
                                        </form>
                                    <?php endif; ?>
                                    <div class="list mt-3">
                                        <div class="list-item small">
                                            <i class="fa fa-check text-primary me-1"></i>
                                            <?php echo e(translate('Quality checked by :website_name', ['website_name' => @$settings->general->site_name])); ?>

                                        </div>
                                        <div class="list-item small">
                                            <i class="fa fa-check text-primary me-1"></i>
                                            <?php echo e(translate('Full Documentation')); ?>

                                        </div>
                                        <div class="list-item small">
                                            <i class="fa fa-check text-primary me-1"></i>
                                            <?php echo e(translate('Future updates')); ?>

                                        </div>
                                        <div class="list-item small">
                                            <i
                                                class="fa <?php echo e($item->isSupported() ? 'fa-check text-primary' : 'fa-times text-danger'); ?> me-1"></i>
                                            <?php echo e(translate('Author Support')); ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php
                            $featuredItemBadge = featuredItemBadge();
                        ?>
                        <?php if($featuredItemBadge && $item->wasFeatured()): ?>
                            <div class="card-v border p-4 mt-4">
                                <div class="row alig-items-center g-3">
                                    <div class="col-auto">
                                        <img src="<?php echo e($featuredItemBadge->getImageLink()); ?>"
                                            alt="<?php echo e($featuredItemBadge->name); ?>"
                                            title="<?php echo e($featuredItemBadge->name); ?>" width="50px" height="50px">
                                    </div>
                                    <div class="col">
                                        <h5 class="mb-1"><?php echo e(translate('Featured Item')); ?></h5>
                                        <p class="mb-0">
                                            <?php echo e(translate('This item was featured on :website_name', [
                                                'website_name' => @$settings->general->site_name,
                                            ])); ?>

                                        </p>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                        <div class="card-v border p-4 mt-4">
                            <div class="row align-items-center g-2 mb-3">
                                <?php
                                    $author = $item->author;
                                ?>
                                <div class="col">
                                    <div class="row row-cols-auto align-items-center g-2">
                                        <div class="col">
                                            <a href="<?php echo e($author->getProfileLink()); ?>"
                                                class="user-avatar user-avatar-lg me-1">
                                                <img src="<?php echo e($author->getAvatar()); ?>"
                                                    alt="<?php echo e($author->username); ?>">
                                            </a>
                                        </div>
                                        <div class="col">
                                            <a href="<?php echo e($author->getProfileLink()); ?>"
                                                class="d-block text-dark fs-5 mb-1">
                                                <h5 class="mb-0">
                                                    <?php echo e($author->username); ?>

                                                    <?php if($author->isBanned()): ?>
                                                        <span class="badge bg-danger fw-light ms-2">
                                                            <i class="fa-solid fa-ban me-1"></i>
                                                            <?php echo e(translate('Banned')); ?>

                                                        </span>
                                                    <?php endif; ?>
                                                </h5>
                                            </a>
                                            <p class="mb-0 fs-6">
                                                <span class="text-muted small">
                                                    <?php echo e(translate('Member since :date', ['date' => dateFormat($author->created_at, 'M Y')])); ?>

                                                </span>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <?php if(!$author->isBanned()): ?>
                                    <div class="col-auto">
                                        <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('follow-button', ['user' => $author,'iconButton' => true])->html();
} elseif ($_instance->childHasBeenRendered('rRZjWxf')) {
    $componentId = $_instance->getRenderedChildComponentId('rRZjWxf');
    $componentTag = $_instance->getRenderedChildComponentTagName('rRZjWxf');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('rRZjWxf');
} else {
    $response = \Livewire\Livewire::mount('follow-button', ['user' => $author,'iconButton' => true]);
    $html = $response->html();
    $_instance->logRenderedChild('rRZjWxf', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="row row-cols-auto g-2">
                                <?php $__currentLoopData = $userBadges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $userBadge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col">
                                        <div class="item-author-badge">
                                            <img src="<?php echo e($userBadge->badge->getImageLink()); ?>"
                                                alt="<?php echo e($userBadge->badge->name); ?>"
                                                title="<?php echo e($userBadge->badge->getFullTitle()); ?>">
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <a href="<?php echo e($author->getPortfolioLink()); ?>"
                                class="btn btn-outline-secondary w-100 mt-4">
                                <?php echo e(translate('View Portfolio')); ?>

                            </a>
                        </div>
                        <?php if($item->isPurchasingEnabled() && $item->hasSales()): ?>
                            <div class="card-v border p-4 mt-4">
                                <h5 class="mb-0">
                                    <i class="fa fa-cart-shopping me-2"></i>
                                    <?php echo e(translate($item->total_sales > 1 ? ':count Sales' : ':count Sale', [
                                        'count' => number_format($item->total_sales),
                                    ])); ?>

                                </h5>
                            </div>
                        <?php endif; ?>
                        <?php if(@$itemSettings->free_item_total_downloads && $item->isFree() && $item->free_downloads > 0): ?>
                            <div class="card-v border p-4 mt-4">
                                <h5 class="mb-0">
                                    <i class="fa fa-download me-2"></i>
                                    <?php echo e(translate($item->free_downloads > 1 ? ':count Downloads' : ':count Download', ['count' => numberFormat($item->free_downloads)])); ?>

                                </h5>
                            </div>
                        <?php endif; ?>
                        <div class="card-v border p-4 mt-4">
                            <div class="small">
                                <?php if($item->last_update_at): ?>
                                    <div class="d-flex justify-content-between border-bottom pb-3 mb-3"">
                                        <p class="mb-0"><?php echo e(translate('Last Update')); ?>:</p>
                                        <p class="mb-0 ms-2"><?php echo e(dateFormat($item->last_update_at)); ?></p>
                                    </div>
                                <?php endif; ?>
                                <div class="d-flex justify-content-between border-bottom pb-3 mb-3"">
                                    <p class="mb-0"><?php echo e(translate('Published')); ?>:</p>
                                    <p class="mb-0 ms-2"><?php echo e(dateFormat($item->created_at)); ?></p>
                                </div>
                                <?php if($item->version): ?>
                                    <div class="d-flex justify-content-between border-bottom pb-3 mb-3"">
                                        <p class="mb-0"><?php echo e(translate('Version')); ?>:</p>
                                        <p class="mb-0 ms-2">
                                            <?php if(@$settings->item->changelogs_status && $item->hasChangelogs()): ?>
                                                <a href="<?php echo e($item->getChangelogsLink()); ?>">
                                                    <?php echo e(translate('v:version', ['version' => $item->version])); ?>

                                                </a>
                                            <?php else: ?>
                                                <span><?php echo e(translate('v:version', ['version' => $item->version])); ?></span>
                                            <?php endif; ?>
                                        </p>
                                    </div>
                                <?php endif; ?>
                                <div class="d-flex justify-content-between border-bottom pb-3 mb-3"">
                                    <p class="mb-0"><?php echo e(translate('Category')); ?>:</p>
                                    <nav aria-label="breadcrumb">
                                        <ol class="breadcrumb justify-content-center m-0">
                                            <li class="breadcrumb-item">
                                                <a
                                                    href="<?php echo e($item->category->getLink()); ?>"><?php echo e($item->category->name); ?></a>
                                            </li>
                                            <?php if($item->subCategory): ?>
                                                <li class="breadcrumb-item">
                                                    <a
                                                        href="<?php echo e($item->subCategory->getLink()); ?>"><?php echo e($item->subCategory->name); ?></a>
                                                </li>
                                            <?php endif; ?>
                                        </ol>
                                    </nav>
                                </div>
                                <?php if($item->options && count($item->options) > 0): ?>
                                    <?php $__currentLoopData = $item->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="d-flex justify-content-between border-bottom pb-3 mb-3">
                                            <p class="mb-0"><?php echo e($key); ?>:</p>
                                            <?php if(is_array($value)): ?>
                                                <div class="col-7 text-end ms-2">
                                                    <?php $__currentLoopData = $value; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <a
                                                            href="<?php echo e(route('items.index', ['search' => strtolower($option)])); ?>">
                                                            <?php echo e($option); ?>

                                                        </a><?php echo e(!$loop->last ? ',' : ''); ?>

                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            <?php else: ?>
                                                <span><?php echo e($value); ?></span>
                                            <?php endif; ?>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                                <div class="d-flex justify-content-between">
                                    <p class="mb-0"><?php echo e(translate('Tags')); ?>:</p>
                                    <div class="col-7 text-end ms-2">
                                        <?php $__currentLoopData = $item->getTags(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a href="<?php echo e(route('items.index', ['search' => strtolower($tag)])); ?>">
                                                <?php echo e($tag); ?></a><?php echo e(!$loop->last ? ',' : ''); ?>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-v border p-4 mt-4">
                            <div class="d-flex align-items-center gap-3">
                                <span class="fs-5"><?php echo e(translate('Share')); ?>:</span>
                                <?php echo $__env->make('themes.basic.partials.share-buttons', [
                                    'link' => $item->getLink(),
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php if (isset($component)) { $__componentOriginalfd18b85732e6a336f727c097d7e6751f = $component; } ?>
<?php $component = App\View\Components\Ad::resolve(['alias' => 'item_page_center'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('ad'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Ad::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(\Illuminate\Support\Arr::toCssClasses('container my-4'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfd18b85732e6a336f727c097d7e6751f)): ?>
<?php $component = $__componentOriginalfd18b85732e6a336f727c097d7e6751f; ?>
<?php unset($__componentOriginalfd18b85732e6a336f727c097d7e6751f); ?>
<?php endif; ?>
    <?php if($authorItems->count() > 0): ?>
        <div class="section section-start">
            <div class="container">
                <div class="section-header">
                    <div
                        class="row row-cols-auto align-items-center justify-content-center justify-content-lg-between g-3">
                        <div class="col">
                            <div class="section-title mb-0">
                                <h2 class="section-title-text">
                                    <?php echo e(translate(":username's items", ['username' => $author->username])); ?>

                                </h2>
                                <div class="section-title-divider"></div>
                            </div>
                        </div>
                        <div class="col d-none d-lg-block">
                            <a href="<?php echo e($author->getPortfolioLink()); ?>">
                                <?php echo e(translate('View More')); ?>

                                <i class="fa fa-chevron-right fa-rtl fa-sm ms-2"></i>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="section-body">
                    <div class="row row-cols-1 row-cols-md-2 row-cols-xl-3 g-3">
                        <?php $__currentLoopData = $authorItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $authorItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col">
                                <?php echo $__env->make('themes.basic.partials.item', [
                                    'item' => $authorItem,
                                    'item_classes' => 'border',
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="text-center mt-5 d-block d-lg-none">
                        <a href="<?php echo e($author->getPortfolioLink()); ?>" class="btn btn-primary btn-md btn-icon">
                            <?php echo e(translate('View More')); ?>

                            <i class="fa fa-arrow-right fa-rtl ms-2"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <?php if($similarItems->count() > 0): ?>
        <div class="section section-start">
            <div class="container">
                <div class="section-header">
                    <div
                        class="row row-cols-auto align-items-center justify-content-center justify-content-lg-between g-3">
                        <div class="col">
                            <div class="section-title mb-0">
                                <h2 class="section-title-text"><?php echo e(translate('Similar items')); ?></h2>
                                <div class="section-title-divider"></div>
                            </div>
                        </div>
                        <div class="col d-none d-lg-block">
                            <a
                                href="<?php echo e($item->subCategory ? $item->subCategory->getLink() : $item->category->getLink()); ?>">
                                <?php echo e(translate('View More')); ?>

                                <i class="fa fa-chevron-right fa-rtl fa-sm ms-2"></i>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="section-body">
                    <div class="row row-cols-1 row-cols-md-2 row-cols-xl-3 g-3">
                        <?php $__currentLoopData = $similarItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $similarItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col">
                                <?php echo $__env->make('themes.basic.partials.item', [
                                    'item' => $similarItem,
                                    'item_classes' => 'border',
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="text-center mt-5 d-block d-lg-none">
                        <a href="<?php echo e($item->subCategory ? $item->subCategory->getLink() : $item->category->getLink()); ?>"
                            class="btn btn-primary btn-md btn-icon">
                            <?php echo e(translate('View More')); ?>

                            <i class="fa fa-arrow-right fa-rtl ms-2"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <?php if (isset($component)) { $__componentOriginalfd18b85732e6a336f727c097d7e6751f = $component; } ?>
<?php $component = App\View\Components\Ad::resolve(['alias' => 'item_page_bottom'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('ad'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Ad::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(\Illuminate\Support\Arr::toCssClasses('container mb-5'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfd18b85732e6a336f727c097d7e6751f)): ?>
<?php $component = $__componentOriginalfd18b85732e6a336f727c097d7e6751f; ?>
<?php unset($__componentOriginalfd18b85732e6a336f727c097d7e6751f); ?>
<?php endif; ?>
    <?php echo $__env->make('themes.basic.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('themes.basic.includes.config', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php $__env->startPush('scripts_libs'); ?>
        <script src="<?php echo e(asset('vendor/libs/swiper/swiper-bundle.min.js')); ?>"></script>
        <script src="<?php echo e(asset('vendor/libs/jquery/fancybox/jquery.fancybox.min.js')); ?>"></script>
    <?php $__env->stopPush(); ?>
    <?php echo $__env->make('themes.basic.includes.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>

</html>
<?php /**PATH /home/taqwahub/public_html/resources/views/themes/basic/items/layout.blade.php ENDPATH**/ ?>