<div class="tab-pane fade" id="items-all" role="tabpanel" aria-labelledby="items-all-tab">
    <div class="mb-4">
        <h2 class="mb-3"><?php echo e(translate('Get All Items')); ?></h2>
        <p>
            <?php echo e(translate('Retrieves all items associated with the provided API key')); ?>

        </p>
        <div class="alert alert-warning" role="alert">
            <div>
                <i class="fa-regular fa-circle-question fa-lg me-1"></i>
                <span><?php echo e(translate('This only works for authors and will not work for regular users.')); ?></span>
            </div>
        </div>
    </div>
    <h4 class="mb-3"><?php echo e(translate('Endpoint')); ?></h4>
    <div class="code mb-3">
        <div class="copy">
            <i class="far fa-clone"></i>
        </div>
        <code>
            <pre class="mb-0"><div class="method get"><?php echo e(translate('GET')); ?></div><div class="endpoint copy-data"><?php echo e(route('api.items.all')); ?></div></pre>
        </code>
    </div>
    <h4 class="mb-3"><?php echo e(translate('Parameters')); ?></h4>
    <ul>
        <li><strong>api_key</strong>: <?php echo e(translate('Your API key')); ?>

            <code>(<?php echo e(translate('required')); ?>)</code>
        </li>
    </ul>
    <h4 class="mb-3"><?php echo e(translate('Responses')); ?></h4>
    <p><strong><?php echo e(translate('Success Response')); ?>:</strong></p>
    <div class="code mb-3">
        <code>
            <pre class="mb-0 text-success">
{
    "status": "<?php echo e(translate('success')); ?>",
    "items": [
        {
            "id": 1,
            "name": "Sample Item",
            "description": "This is a sample item",
            "category": "Category Name",
            "sub_category": "Subcategory Name",
            "options": ["option1", "option2"],
            "version": 1.0.0,
            "demo_link": "https://example.com/demo",
            "tags": ["tag1", "tag2"],
            "media": {
                "thumbnail": "https://example.com/thumbnail.png",
                "preview_image": "https://example.com/preview.jpg", // <?php echo e(translate('This is not included for audio items')); ?>

                "preview_video": "https://example.com/video.mp4", // <?php echo e(translate('This is only included for video items')); ?>

                "preview_audio": "https://example.com/audio.mp3", // <?php echo e(translate('This is only included for audio items')); ?>

                "screenshots": [ // <?php echo e(translate('This is only included if item has screenshots')); ?>

                    "https://example.com/screenshot1.jpg",
                    "https://example.com/screenshot2.jpg"
                ],
            },
            "price": {
                "regular": 19.99,
                "extended": 29.99
            },
            "currency": "<?php echo e(defaultCurrency()->code); ?>",
            "published_at": "2024-04-27T12:00:00Z"
        },
        {
            // Next item...
        }
    ]
}</pre>
        </code>
    </div>
    <p><strong><?php echo e(translate('Error Response')); ?>:</strong></p>
    <div class="code mb-3">
        <code>
            <pre class="mb-0 text-danger">
{
    "status": "<?php echo e(translate('error')); ?>",
    "msg": "<?php echo e(translate('No Items Found')); ?>"
}</pre>
        </code>
    </div>
</div>
<?php /**PATH /home/taqwahub/public_html/resources/views/api-docs/sections/items-all.blade.php ENDPATH**/ ?>