<?php $__env->startSection('section', translate('Financial')); ?>
<?php $__env->startSection('title', translate('Edit Payment Gateway')); ?>
<?php $__env->startSection('back', route('admin.financial.payment-gateways.index')); ?>
<?php $__env->startSection('container', 'container-max-lg'); ?>
<?php $__env->startSection('content'); ?>
    <form id="vironeer-submited-form" action="<?php echo e(route('admin.financial.payment-gateways.update', $paymentGateway->id)); ?>"
        method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="row g-3">
            <div class="col-12">
                <div class="card">
                    <div class="card-body p-4">
                        <div class="vironeer-file-preview-box mb-3 bg-light p-4 text-center">
                            <div class="file-preview-box mb-3">
                                <img id="filePreview" src="<?php echo e(asset($paymentGateway->logo)); ?>" width="150px">
                            </div>
                            <button id="selectFileBtn" type="button" class="btn btn-secondary mb-2"><i
                                    class="fas fa-camera me-2"></i><?php echo e(translate('Choose Logo')); ?></button>
                            <input id="selectedFileInput" type="file" name="logo" accept=".png, .jpg, .jpeg, .webp"
                                hidden>
                            <small class="text-muted d-block"><?php echo e(translate('Allowed (PNG, JPG, JPEG, WEBP)')); ?></small>
                        </div>
                        <div class="row g-3">
                            <div class="col-lg-6">
                                <label class="form-label"><?php echo e(translate('Name')); ?></label>
                                <input type="text" name="name" class="form-control"
                                    value="<?php echo e($paymentGateway->name); ?>">
                            </div>
                            <div class="col-lg-6">
                                <label class="form-label"><?php echo e(translate('Status')); ?> </label>
                                <input type="checkbox" name="status" data-toggle="toggle"
                                    <?php echo e($paymentGateway->isActive() ? 'checked' : ''); ?>>
                            </div>
                            <?php if(!$paymentGateway->isAccountBalance()): ?>
                                <?php if($paymentGateway->mode): ?>
                                    <div class="col-lg-6">
                                        <label class="form-label"><?php echo e(translate('Mode')); ?> </label>
                                        <select name="mode" class="form-select">
                                            <?php $__currentLoopData = \App\Models\PaymentGateway::getModes(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($mode); ?>"
                                                    <?php echo e($paymentGateway->mode == $mode ? 'selected' : ''); ?>>
                                                    <?php echo e(ucfirst($mode)); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                <?php endif; ?>
                                <div class="<?php echo e($paymentGateway->mode ? 'col-lg-6' : 'col-lg-12'); ?>">
                                    <label class="form-label"><?php echo e(translate('Fees')); ?></label>
                                    <div class="input-group">
                                        <input type="number" name="fees" class="form-control" placeholder="0"
                                            value="<?php echo e($paymentGateway->fees); ?>">
                                        <span class="input-group-text"><i class="fas fa-percent"></i></span>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php if(!$paymentGateway->isAccountBalance()): ?>
                <?php if(!$paymentGateway->isManual()): ?>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header"><?php echo e(translate('Charge Currency')); ?></div>
                            <div class="card-body p-4">

                                <div class="row g-2 align-items-center">
                                    <div class="col-12">
                                        <input type="text" name="charge_currency" class="form-control"
                                            placeholder="<?php echo e(translate('Currency Code (USD)')); ?>"
                                            value="<?php echo e($paymentGateway->charge_currency); ?>">
                                    </div>
                                    <div class="col-lg-5">
                                        <?php echo $__env->make('admin.partials.input-price', [
                                            'value' => 1,
                                            'disabled' => true,
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                    <div class="col text-center d-none d-lg-inline">
                                        <div class="fs-1">=</div>
                                    </div>
                                    <div class="col-lg-5">
                                        <input type="number" name="charge_rate" class="form-control"
                                            value="<?php echo e($paymentGateway->charge_rate); ?>" step="any" placeholder="0.00">
                                    </div>
                                </div>
                                <div class="note note-warning mb-0 mt-3">
                                    <i
                                        class="fa-regular fa-circle-question me-2"></i><?php echo e(translate('Use this in case you want to charge users with different currency or the gateway does not support your website currency')); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if($paymentGateway->parameters): ?>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header"><?php echo e(translate('Parameters')); ?></div>
                            <div class="card-body p-4">
                                <div class="row g-3">
                                    <?php $__currentLoopData = $paymentGateway->parameters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $parameter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-lg-12">
                                            <label class="form-label capitalize"><?php echo e(translate($parameter->label)); ?></label>
                                            <?php if($parameter->type == 'route'): ?>
                                                <div class="input-group">
                                                    <input id="input-link-<?php echo e($key); ?>" type="text"
                                                        value="<?php echo e(url($parameter->content)); ?>" class="form-control"
                                                        readonly>
                                                    <button type="button" class="btn btn-secondary btn-copy"
                                                        data-clipboard-target="#input-link-<?php echo e($key); ?>"><i
                                                            class="far fa-clone"></i></button>
                                                </div>
                                            <?php else: ?>
                                                <div class="input-group">
                                                    <input id="input-text-<?php echo e($key); ?>" type="text"
                                                        value="<?php echo e($parameter->content); ?>" class="form-control" readonly>
                                                    <button type="button" class="btn btn-secondary btn-copy"
                                                        data-clipboard-target="#input-text-<?php echo e($key); ?>"><i
                                                            class="far fa-clone"></i></button>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="col-12">
                    <?php if(!$paymentGateway->isManual()): ?>
                        <div class="card">
                            <div class="card-header"><?php echo e(translate('Credentials')); ?></div>
                            <div class="card-body p-4">
                                <div class="row g-3">
                                    <?php $__currentLoopData = $paymentGateway->credentials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-lg-12">
                                            <label class="form-label capitalize">
                                                <?php echo e(translate(str_replace('_', ' ', $key))); ?>

                                            </label>
                                            <input type="text" name="credentials[<?php echo e($key); ?>]"
                                                value="<?php echo e(demo($value)); ?>" class="form-control">
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="card">
                            <div class="card-header"><?php echo e(translate('Instructions')); ?></div>
                            <div class="card-body p-4">
                                <textarea name="instructions" class="ckeditor"><?php echo e($paymentGateway->instructions); ?></textarea>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </form>
    <?php $__env->startPush('scripts_libs'); ?>
        <script src="<?php echo e(asset('vendor/libs/clipboard/clipboard.min.js')); ?>"></script>
    <?php $__env->stopPush(); ?>
    <?php echo $__env->make('admin.partials.ckeditor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/taqwahub/public_html/resources/views/admin/financial/payment-gateways/edit.blade.php ENDPATH**/ ?>