<?php $__env->startSection('section', $user->username); ?>
<?php $__env->startSection('title', translate('Portfolio')); ?>
<?php $__env->startSection('content_size', 9); ?>
<?php $__env->startSection('content'); ?>
    <div class="mb-4">
        <div class="row row-cols-auto justify-content-between align-items-center g-3">
            <div class="col">
                <h4 class="mb-0"><?php echo e(translate('Portfolio')); ?></h4>
            </div>
            <div class="col">
                <div class="row g-3 row-cols-auto align-items-center">
                    <div class="col">
                        <form action="<?php echo e(url()->current()); ?>" method="GET">
                            <div class="form-search form-search-reverse">
                                <button class="icon">
                                    <i class="fa fa-search"></i>
                                </button>
                                <input type="text" name="search" placeholder="<?php echo e(translate('Search...')); ?>"
                                    class="form-control" value="<?php echo e(request('search')); ?>">
                            </div>
                        </form>
                    </div>
                    <div class="col">
                        <?php echo $__env->make('themes.basic.partials.grid-buttons', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php if($items->count() > 0): ?>
        <div class="items">
            <div class="row row-cols-1 row-cols-md-2 row-cols-xxl-3 g-3">
                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col w-100">
                        <?php echo $__env->make('themes.basic.partials.item', [
                            'item' => $item,
                            'item_classes' => 'border item-inline',
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php echo e($items->links()); ?>

    <?php else: ?>
        <div class="card-v border card-bg text-center">
            <div class="py-3">
                <i class="fa-regular fa-file fa-lg"></i>
                <p class="mb-0 mt-3"><?php echo e(translate('No Items found')); ?></p>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('themes.basic.profile.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/taqwahub/public_html/resources/views/themes/basic/profile/portfolio.blade.php ENDPATH**/ ?>