<!DOCTYPE html>
<html lang="<?php echo e(getLocale()); ?>">

<head>
    <?php echo $__env->make('themes.basic.includes.head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>

<body class="bg-white">
    <?php echo $__env->make('themes.basic.includes.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('themes.basic.profile.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <section class="section section-profile">
        <div class="container <?php echo $__env->yieldContent('container'); ?>">
            <div class="section-body">
                <div class="row g-3">
                    <div
                        class="col-12 col-xl-<?php echo e($__env->yieldContent('content_size') ? $__env->yieldContent('content_size') : '8'); ?>">
                        <?php echo $__env->yieldContent('content'); ?>
                    </div>
                    <div
                        class="col-12 col-xl-<?php echo e($__env->yieldContent('content_size') ? 12 - $__env->yieldContent('content_size') : '4'); ?>">
                        <?php echo $__env->make('themes.basic.profile.includes.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
                <?php if(request()->routeIs('profile.index') && $user->total_followers > 0 && $followers->count() > 0): ?>
                    <div class="card-v card-bg border p-4 mt-4">
                        <div class="row g-3 mb-4">
                            <div class="col">
                                <h3 class="mb-0">
                                    <?php echo e(translate('Followers (:count)', ['count' => numberFormat($user->total_followers)])); ?>

                                </h3>
                            </div>
                            <div class="col-auto">
                                <a href="<?php echo e(route('profile.followers', strtolower($user->username))); ?>"
                                    class="btn btn-outline-secondary"><?php echo e(translate('View All Followers')); ?></a>
                            </div>
                        </div>
                        <div class="row row-cols-auto g-1">
                            <?php $__currentLoopData = $followers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $follower): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $follower = $follower->follower;
                                ?>
                                <div class="col">
                                    <a href="<?php echo e($follower->getProfileLink()); ?>" class="user-avatar user-avatar-xl me-1">
                                        <img src="<?php echo e($follower->getAvatar()); ?>" alt="<?php echo e($follower->username); ?>">
                                    </a>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <?php echo $__env->make('themes.basic.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('themes.basic.includes.config', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('themes.basic.includes.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>

</html>
<?php /**PATH /home/taqwahub/public_html/resources/views/themes/basic/profile/layout.blade.php ENDPATH**/ ?>