<?php $__env->startSection('section', translate('Financial')); ?>
<?php $__env->startSection('title', translate('Payment Gateways')); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header p-3 border-bottom-small">
            <form class="multiple-select-search-form" action="<?php echo e(request()->url()); ?>" method="GET">
                <div class="row g-3">
                    <div class="col-12 col-lg-8">
                        <input type="text" name="search" class="form-control" placeholder="<?php echo e(translate('Search...')); ?>"
                            value="<?php echo e(request()->input('search') ?? ''); ?>">
                    </div>
                    <div class="col-12 col-lg-2">
                        <select name="status" class="form-select selectpicker" title="<?php echo e(translate('Status')); ?>">
                            <option value="1" <?php echo e(request('status') == '1' ? 'selected' : ''); ?>>
                                <?php echo e(translate('Active')); ?>

                            </option>
                            <option value="0" <?php echo e(request('status') == '0' ? 'selected' : ''); ?>>
                                <?php echo e(translate('Disabled')); ?></option>
                        </select>
                    </div>
                    <div class="col">
                        <button class="btn btn-primary w-100"><i class="fa fa-search"></i></button>
                    </div>
                    <div class="col">
                        <a href="<?php echo e(url()->current()); ?>" class="btn btn-secondary w-100"><?php echo e(translate('Reset')); ?></a>
                    </div>
                </div>
            </form>
        </div>
        <div>
            <div class="table-responsive">
                <table class="table sortable-table w-100">
                    <thead>
                        <tr>
                            <th><i class="fa-solid fa-hashtag"></i></th>
                            <th><?php echo e(translate('Logo')); ?></th>
                            <th><?php echo e(translate('Name')); ?></th>
                            <th class="text-center"><?php echo e(translate('Fees')); ?></th>
                            <th class="text-center"><?php echo e(translate('Status')); ?></th>
                            <th class="text-end"><?php echo e(translate('Action')); ?></th>
                        </tr>
                    </thead>
                    <tbody class="sortable-table-tbody">
                        <?php $__empty_1 = true; $__currentLoopData = $paymentGateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paymentGateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr data-id="<?php echo e($paymentGateway->id); ?>">
                                <td>
                                    <span class="sortable-table-handle me-2 text-muted">
                                        <i class="fas fa-arrows-alt fa-lg"></i>
                                    </span>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('admin.financial.payment-gateways.edit', $paymentGateway->id)); ?>">
                                        <img src="<?php echo e(asset($paymentGateway->logo)); ?>" alt="<?php echo e($paymentGateway->name); ?>"
                                            width="100px">
                                    </a>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('admin.financial.payment-gateways.edit', $paymentGateway->id)); ?>"
                                        class="text-dark">
                                        <?php echo e($paymentGateway->name); ?>

                                    </a>
                                    <?php echo addonBadge($paymentGateway->alias); ?>

                                </td>
                                <td class="text-center">
                                    <?php echo e(!$paymentGateway->isAccountBalance() ? $paymentGateway->fees . '%' : '--'); ?></td>
                                <td class="text-center">
                                    <?php if($paymentGateway->isActive()): ?>
                                        <span class="badge bg-success"><?php echo e(translate('Active')); ?></span>
                                    <?php else: ?>
                                        <span class="badge bg-danger"><?php echo e(translate('Disabled')); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-end">
                                    <a href="<?php echo e(route('admin.financial.payment-gateways.edit', $paymentGateway->id)); ?>"
                                        class="btn btn-secondary">
                                        <i class="fa-regular fa-pen-to-square"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5">
                                    <div class="p-3 text-center text-muted">
                                        <?php echo e(translate('Not data found')); ?>

                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php $__env->startPush('top_scripts'); ?>
        <script>
            const sortingRoute = "<?php echo e(route('admin.financial.payment-gateways.sortable')); ?>";
        </script>
    <?php $__env->stopPush(); ?>
    <?php $__env->startPush('styles_libs'); ?>
        <link rel="stylesheet" href="<?php echo e(asset('vendor/libs/bootstrap/select/bootstrap-select.min.css')); ?>">
        <link href="<?php echo e(asset('vendor/libs/jquery/jquery-ui.min.css')); ?>" />
    <?php $__env->stopPush(); ?>
    <?php $__env->startPush('scripts_libs'); ?>
        <script src="<?php echo e(asset('vendor/libs/bootstrap/select/bootstrap-select.min.js')); ?>"></script>
        <script src="<?php echo e(asset('vendor/libs/jquery/jquery-ui.min.js')); ?>"></script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.grid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/taqwahub/public_html/resources/views/admin/financial/payment-gateways/index.blade.php ENDPATH**/ ?>