<?php if(@$settings->actions->blog && $blogArticlesSection && $blogArticles->count() > 0): ?>
    <div class="section">
        <div class="container container-custom">
            <div class="section-header">
                <div class="col-lg-7 mx-auto">
                    <div class="section-title mb-0">
                        <h2 class="section-title-text"><?php echo e($blogArticlesSection->name); ?></h2>
                        <div class="section-title-divider"></div>
                    </div>
                    <?php if($blogArticlesSection->description): ?>
                        <p class="section-text mt-3"><?php echo e($blogArticlesSection->description); ?></p>
                    <?php endif; ?>
                </div>
            </div>
            <div class="section-body">
                <div class="row row-cols-1 row-cols-md-2 row-cols-lg-2 row-cols-xxl-3 justify-content-center g-3">
                    <?php $__currentLoopData = $blogArticles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blogArticle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col" data-aos="fade-right" data-aos-duration="1000"
                            data-aos-delay="<?php echo e(($loop->index + 1) * 100); ?>">
                            <div class="blog-post h-100">
                                <div class="blog-post-header">
                                    <a href="<?php echo e($blogArticle->getLink()); ?>">
                                        <img src="<?php echo e($blogArticle->getImageLink()); ?>" alt="<?php echo e($blogArticle->title); ?>"
                                            class="blog-post-img">
                                    </a>
                                </div>
                                <div class="blog-post-body">
                                    <div class="post-meta mb-2">
                                        <div class="post-meta-item">
                                            <i class="far fa-calendar"></i>
                                            <span><?php echo e(dateFormat($blogArticle->created_at)); ?></span>
                                        </div>
                                        <div class="post-meta-item">
                                            <i class="fa-solid fa-tag"></i>
                                            <span>
                                                <a href="<?php echo e($blogArticle->category->getLink()); ?>">
                                                    <?php echo e($blogArticle->category->name); ?></a>
                                            </span>
                                        </div>
                                    </div>
                                    <h5 class="blog-post-title">
                                        <a href="<?php echo e($blogArticle->getLink()); ?>"><?php echo e($blogArticle->title); ?></a>
                                    </h5>
                                    <p class="blog-post-text">
                                        <?php echo e($blogArticle->short_description); ?>

                                    </p>
                                    <div class="mt-auto">
                                        <a href="<?php echo e($blogArticle->getLink()); ?>">
                                            <?php echo e(translate('Read More')); ?><i
                                                class="fa fa-arrow-right fa-sm fa-rtl ms-1"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="text-center mt-5">
                    <a href="<?php echo e(route('blog.index')); ?>" class="btn btn-primary btn-md">
                        <?php echo e(translate('View All')); ?>

                        <i class="fa fa-arrow-right fa-rtl ms-2"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /home/taqwahub/public_html/resources/views/themes/basic/sections/blog-articles.blade.php ENDPATH**/ ?>