<?php $__env->startSection('title', translate('Tickets')); ?>
<?php $__env->startSection('create', route('admin.tickets.create')); ?>
<?php $__env->startSection('content'); ?>
    <div class="row g-3 mb-4">
        <div class="col-12 col-lg-6 col-xxl-6">
            <div class="vironeer-counter-card bg-green">
                <div class="vironeer-counter-card-icon">
                    <i class="fa-regular fa-clock"></i>
                </div>
                <div class="vironeer-counter-card-meta">
                    <p class="vironeer-counter-card-title"><?php echo e(translate('Opened tickets')); ?></p>
                    <p class="vironeer-counter-card-number"><?php echo e($counters['opened_tickets']); ?></p>
                </div>
            </div>
        </div>
        <div class="col-12 col-lg-6 col-xxl-6">
            <div class="vironeer-counter-card bg-red">
                <div class="vironeer-counter-card-icon">
                    <i class="fa-regular fa-circle-xmark"></i>
                </div>
                <div class="vironeer-counter-card-meta">
                    <p class="vironeer-counter-card-title"><?php echo e(translate('Closed tickets')); ?></p>
                    <p class="vironeer-counter-card-number"><?php echo e($counters['closed_tickets']); ?></p>
                </div>
            </div>
        </div>
    </div>
    <div class="card">
        <div class="card-header p-3 border-bottom-small">
            <form action="<?php echo e(request()->url()); ?>" method="GET">
                <div class="row g-3">
                    <div class="col-12 col-lg-6">
                        <input type="text" name="search" class="form-control" placeholder="<?php echo e(translate('Search...')); ?>"
                            value="<?php echo e(request()->input('search') ?? ''); ?>">
                    </div>
                    <div class="col-12 col-lg-2">
                        <select name="category" class="form-select selectpicker" title="<?php echo e(translate('Category')); ?>"
                            data-live-search="true">
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->id); ?>" <?php if($category->id == request('category')): echo 'selected'; endif; ?>>
                                    <?php echo e($category->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-12 col-lg-2">
                        <select name="status" class="form-select selectpicker" title="<?php echo e(translate('Status')); ?>">
                            <?php $__currentLoopData = \App\Models\Ticket::getStatusOptions(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>" <?php if(request('status') == $key): echo 'selected'; endif; ?>>
                                    <?php echo e($value); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col">
                        <button class="btn btn-primary w-100"><i class="fa fa-search"></i></button>
                    </div>
                    <div class="col">
                        <a href="<?php echo e(url()->current()); ?>" class="btn btn-secondary w-100"><?php echo e(translate('Reset')); ?></a>
                    </div>
                </div>
            </form>
        </div>
        <div>
            <?php if($tickets->count() > 0): ?>
                <div class="table-responsive">
                    <table class="vironeer-normal-table table w-100">
                        <thead class="bg-light">
                            <tr>
                                <th><?php echo e(translate('ID')); ?></th>
                                <th><?php echo e(translate('Subject')); ?></th>
                                <th><?php echo e(translate('User')); ?></th>
                                <th><?php echo e(translate('Category')); ?></th>
                                <th class="text-center"><?php echo e(translate('Status')); ?></th>
                                <th class="text-center"><?php echo e(translate('Created date')); ?></th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <a href="<?php echo e(route('admin.tickets.show', $ticket->id)); ?>">
                                            <i class="fa-solid fa-hashtag"></i>
                                            <span><?php echo e($ticket->id); ?></span>
                                        </a>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('admin.tickets.show', $ticket->id)); ?>" class="text-dark">
                                            <?php echo e(shorterText($ticket->subject, 50)); ?>

                                        </a>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('admin.members.users.edit', $ticket->user->id)); ?>"
                                            class="text-dark">
                                            <i class="fa fa-user me-1"></i>
                                            <?php echo e($ticket->user->username); ?>

                                        </a>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('admin.tickets.categories.edit', $ticket->category->id)); ?>"
                                            class="text-dark">
                                            <i class="fa-solid fa-tag me-2"></i>
                                            <?php echo e($ticket->category->name); ?>

                                        </a>
                                    </td>
                                    <td class="text-center">
                                        <?php if($ticket->isOpened()): ?>
                                            <span class="badge bg-green">
                                                <?php echo e($ticket->getStatusName()); ?>

                                            </span>
                                        <?php else: ?>
                                            <span class="badge bg-red">
                                                <?php echo e($ticket->getStatusName()); ?>

                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center"><?php echo e(dateFormat($ticket->created_at)); ?></td>
                                    <td>
                                        <div class="text-end">
                                            <button type="button" class="btn btn-sm rounded-3" data-bs-toggle="dropdown"
                                                aria-expanded="true">
                                                <i class="fa fa-ellipsis-v fa-sm text-muted"></i>
                                            </button>
                                            <ul class="dropdown-menu dropdown-menu-lg dropdown-menu-sm-end"
                                                data-popper-placement="bottom-end">
                                                <li>
                                                    <a class="dropdown-item"
                                                        href="<?php echo e(route('admin.tickets.show', $ticket->id)); ?>"><i
                                                            class="fas fa-eye me-2"></i><?php echo e(translate('View')); ?></a>
                                                </li>
                                                <li>
                                                    <hr class="dropdown-divider" />
                                                </li>
                                                <li>
                                                    <form action="<?php echo e(route('admin.tickets.destroy', $ticket->id)); ?>"
                                                        method="POST">
                                                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                                        <button class="action-confirm dropdown-item text-danger"><i
                                                                class="far fa-trash-alt me-2"></i><?php echo e(translate('Delete')); ?></button>
                                                    </form>
                                                </li>
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <?php echo $__env->make('admin.partials.empty', ['empty_classes' => 'empty-lg'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        </div>
    </div>
    <?php echo e($tickets->links()); ?>

    <?php $__env->startPush('styles_libs'); ?>
        <link rel="stylesheet" href="<?php echo e(asset('vendor/libs/bootstrap/select/bootstrap-select.min.css')); ?>">
    <?php $__env->stopPush(); ?>
    <?php $__env->startPush('scripts_libs'); ?>
        <script src="<?php echo e(asset('vendor/libs/bootstrap/select/bootstrap-select.min.js')); ?>"></script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.grid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/taqwahub/public_html/resources/views/admin/tickets/index.blade.php ENDPATH**/ ?>