<?php $__env->startSection('section', translate('Records')); ?>
<?php $__env->startSection('title', translate('Referral Earnings')); ?>
<?php $__env->startSection('container', 'container-max-xxl'); ?>
<?php $__env->startSection('content'); ?>
    <div class="row g-3 mb-4">
        <div class="col-12 col-lg-6 col-xxl-4">
            <div class="vironeer-counter-card bg-green">
                <div class="vironeer-counter-card-bg"></div>
                <div class="vironeer-counter-card-icon">
                    <i class="fa-solid fa-circle-check"></i>
                </div>
                <div class="vironeer-counter-card-meta">
                    <p class="vironeer-counter-card-title"><?php echo e(translate('Active')); ?></p>
                    <p class="vironeer-counter-card-number"><?php echo e(numberFormat($counters['active'])); ?></p>
                </div>
            </div>
        </div>
        <div class="col-12 col-lg-6 col-xxl-4">
            <div class="vironeer-counter-card bg-blue">
                <div class="vironeer-counter-card-bg"></div>
                <div class="vironeer-counter-card-icon">
                    <i class="fa-solid fa-share"></i>
                </div>
                <div class="vironeer-counter-card-meta">
                    <p class="vironeer-counter-card-title"><?php echo e(translate('Refunded')); ?></p>
                    <p class="vironeer-counter-card-number"><?php echo e(numberFormat($counters['refunded'])); ?></p>
                </div>
            </div>
        </div>
        <div class="col-12 col-lg-12 col-xxl-4">
            <div class="vironeer-counter-card bg-red">
                <div class="vironeer-counter-card-bg"></div>
                <div class="vironeer-counter-card-icon">
                    <i class="fa-solid fa-circle-xmark"></i>
                </div>
                <div class="vironeer-counter-card-meta">
                    <p class="vironeer-counter-card-title"><?php echo e(translate('Cancelled')); ?></p>
                    <p class="vironeer-counter-card-number"><?php echo e(numberFormat($counters['cancelled'])); ?></p>
                </div>
            </div>
        </div>
    </div>
    <div class="card">
        <div class="card-header p-3 border-bottom-small">
            <form action="<?php echo e(url()->current()); ?>" method="GET">
                <div class="row g-3">
                    <div class="col-12 col-lg-6">
                        <input type="text" name="search" class="form-control" placeholder="<?php echo e(translate('Search...')); ?>"
                            value="<?php echo e(request('search') ?? ''); ?>">
                    </div>
                    <div class="col-12 col-lg-2">
                        <input type="text" name="date_from" class="form-control text-secondary"
                            placeholder="<?php echo e(translate('From Date')); ?>" onfocus="(this.type='date')"
                            onblur="(this.type='text')" value="<?php echo e(request('date_from')); ?>">
                    </div>
                    <div class="col-12 col-lg-2">
                        <input type="text" name="date_to" class="form-control text-secondary"
                            placeholder="<?php echo e(translate('To Date')); ?>" onfocus="(this.type='date')"
                            onblur="(this.type='text')" value="<?php echo e(request('date_to')); ?>">
                    </div>
                    <div class="col">
                        <button class="btn btn-primary w-100"><i class="fa fa-search"></i></button>
                    </div>
                    <div class="col">
                        <a href="<?php echo e(url()->current()); ?>" class="btn btn-secondary w-100"><?php echo e(translate('Reset')); ?></a>
                    </div>
                </div>
            </form>
        </div>
        <div>
            <?php if($referralEarnings->count() > 0): ?>
                <div class="overflow-hidden">
                    <div class="table-custom-container">
                        <table class="table-custom table">
                            <thead>
                                <tr class="bg-light">
                                    <th><?php echo e(translate('ID')); ?></th>
                                    <th><?php echo e(translate('Referral ID')); ?></th>
                                    <th class="text-center"><?php echo e(translate('Referred User')); ?></th>
                                    <th class="text-center"><?php echo e(translate('Referred By Author')); ?></th>
                                    <th class="text-center"><?php echo e(translate('Author Earnings')); ?></th>
                                    <th class="text-center"><?php echo e(translate('Status')); ?></th>
                                    <th class="text-center"><?php echo e(translate('Date')); ?></th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $referralEarnings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $referralEarning): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <span><i class="fa-solid fa-hashtag me-1"></i><?php echo e($referralEarning->id); ?></span>
                                        </td>
                                        <td>
                                            <span><i
                                                    class="fa-solid fa-hashtag me-1"></i><?php echo e($referralEarning->referral->id); ?></span>
                                        </td>
                                        <td class="text-center">
                                            <a href="<?php echo e(route('admin.members.users.edit', $referralEarning->referral->user->id)); ?>"
                                                class="text-dark">
                                                <i class="fa-regular fa-user me-1"></i>
                                                <?php echo e($referralEarning->referral->user->username); ?>

                                            </a>
                                        </td>
                                        <td class="text-center">
                                            <a href="<?php echo e(route('admin.members.users.edit', $referralEarning->author->id)); ?>"
                                                class="text-dark">
                                                <i class="fa fa-user me-1"></i>
                                                <?php echo e($referralEarning->author->username); ?>

                                            </a>
                                        </td>
                                        <td class="text-center">
                                            <strong
                                                class="text-success"><?php echo e(getAmount($referralEarning->author_earning)); ?></strong>
                                        </td>
                                        <td class="text-center">
                                            <?php if($referralEarning->isActive()): ?>
                                                <div class="badge bg-green">
                                                    <?php echo e(translate('Active')); ?>

                                                </div>
                                            <?php elseif($referralEarning->isRefunded()): ?>
                                                <div class="badge bg-blue">
                                                    <?php echo e(translate('Refunded')); ?>

                                                </div>
                                            <?php else: ?>
                                                <div class="badge bg-red">
                                                    <?php echo e(translate('Cancelled')); ?>

                                                </div>
                                            <?php endif; ?>
                                        </td>
                                        <td class="text-center"><?php echo e(dateFormat($referralEarning->created_at)); ?></td>
                                        <td>
                                            <div class="text-end">
                                                <button type="button" class="btn btn-sm rounded-3"
                                                    data-bs-toggle="dropdown" aria-expanded="true">
                                                    <i class="fa fa-ellipsis-v fa-sm text-muted"></i>
                                                </button>
                                                <ul class="dropdown-menu dropdown-menu-sm-end"
                                                    data-popper-placement="bottom-end">
                                                    <li>
                                                        <a class="dropdown-item"
                                                            href="<?php echo e(route('admin.records.sales.show', $referralEarning->sale->id)); ?>"
                                                            target="_blank">
                                                            <i class="fa-solid fa-up-right-from-square me-1"></i>
                                                            <?php echo e(translate('View Sale')); ?>

                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            <?php else: ?>
                <?php echo $__env->make('admin.partials.empty', ['empty_classes' => 'empty-lg'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        </div>
    </div>
    <?php echo e($referralEarnings->links()); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.grid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/taqwahub/public_html/resources/views/admin/records/referral-earnings.blade.php ENDPATH**/ ?>