<div class="border-top pt-3">
    <?php if(authUser()): ?>
        <div class="card-v card-bg border mt-2 <?php echo e($comments->count() > 1 ? 'mb-4' : ''); ?> p-4">
            <div class="leave-comment">
                <div class="d-flex align-items-start">
                    <div class="user-avatar">
                        <img src="<?php echo e(authUser()->getAvatar()); ?>" alt="<?php echo e(authUser()->username); ?>">
                    </div>
                    <div class="flex-grow-1">
                        <form wire:submit.prevent="storeComment">
                            <textarea class="form-control form-control-md w-100 mb-3" wire:model.defer="comment"
                                placeholder="<?php echo e(translate('Your comment')); ?>" rows="2" required></textarea>
                            <div class="d-flex justify-content-end">
                                <button class="btn btn-primary"><?php echo e(translate('Publish')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    <?php elseif($comments->count() < 1): ?>
        <div class="card-v card-bg text-center">
            <i class="fa-regular fa-comments fa-lg"></i>
            <p class="mt-3"><?php echo e(translate('This item has no comments')); ?></p>
            <?php if(!authUser()): ?>
                <p class="mt-2 mb-0"><?php echo translate(':sign_in to comment', [
                    'sign_in' => '<a href="' . route('login') . '">' . translate('Sign In') . '</a>',
                ]); ?></p>
            <?php endif; ?>
        </div>
    <?php endif; ?>
    <?php if($comments->count() > 0): ?>
        <div class="item-comments">
            <div class="row row-cols-1 <?php echo e($comments->count() > 1 ? 'g-4' : (authUser() ? 'mt-4' : '')); ?>">
                <?php $__currentLoopData = $comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('item.comment-replies', ['comment' => $comment])->html();
} elseif ($_instance->childHasBeenRendered(''.e(hash_encode($comment->id)).'')) {
    $componentId = $_instance->getRenderedChildComponentId(''.e(hash_encode($comment->id)).'');
    $componentTag = $_instance->getRenderedChildComponentTagName(''.e(hash_encode($comment->id)).'');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild(''.e(hash_encode($comment->id)).'');
} else {
    $response = \Livewire\Livewire::mount('item.comment-replies', ['comment' => $comment]);
    $html = $response->html();
    $_instance->logRenderedChild(''.e(hash_encode($comment->id)).'', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php echo e($comments->links()); ?>

    <?php endif; ?>
</div>
<?php /**PATH /home/taqwahub/public_html/resources/views/themes/basic/livewire/item/comments.blade.php ENDPATH**/ ?>