<?php $__env->startSection('header_title', translate('Categories')); ?>
<?php $__env->startSection('title', translate('Categories')); ?>
<?php $__env->startSection('breadcrumbs', Breadcrumbs::render('categories')); ?>
<?php $__env->startSection('breadcrumbs_schema', Breadcrumbs::view('breadcrumbs::json-ld', 'categories')); ?>
<?php $__env->startSection('header_v2', true); ?>
<?php $__env->startSection('container', 'container-custom'); ?>
<?php $__env->startSection('content'); ?>
    <?php if($categories->count() > 0): ?>
        <div class="categories">
            <div class="row row-cols-1 row-cols-lg-2 row-cols-xxl-3 g-4">
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col">
                        <div class="card-v border p-0 h-100">
                            <div class="category">
                                <a href="<?php echo e($category->getLink()); ?>" class="category-header">
                                    <div class="category-icon">
                                        <i class="fa-solid fa-tags fa-rtl"></i>
                                    </div>
                                    <div>
                                        <h5 class="mb-1"><?php echo e($category->name); ?></h5>
                                        <p class="mb-0 text-muted small">
                                            <?php echo e(translate_choice(':count item|:count items', $category->items_count, ['count' => $category->items_count])); ?>

                                        </p>
                                    </div>
                                </a>
                                <div class="category-body">
                                    <div class="category-links">
                                        <?php $__currentLoopData = $category->subCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a href="<?php echo e($subCategory->getLink()); ?>" class="category-link">
                                                <i class="fa-solid fa-tag fa-rtl me-2"></i>
                                                <?php echo e(translate(':category_name (:count)', [
                                                    'category_name' => $subCategory->name,
                                                    'count' => $subCategory->items_count,
                                                ])); ?>

                                            </a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php echo e($categories->links()); ?>

    <?php else: ?>
        <div class="card-v border p-5 text-center">
            <span class="text-muted"><?php echo e(translate('No Categories found')); ?></span>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('themes.basic.layouts.single', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/taqwahub/public_html/resources/views/themes/basic/categories/index.blade.php ENDPATH**/ ?>