<?php $__env->startSection('noindex', true); ?>
<?php $__env->startSection('section', $user->username); ?>
<?php $__env->startSection('title', translate('Reviews')); ?>
<?php $__env->startSection('content'); ?>
    <div class="mb-4">
        <div class="row row-cols-auto justify-content-between align-items-center g-3">
            <div class="col">
                <h4 class="mb-0"><?php echo e(translate('Reviews')); ?></h4>
            </div>
            <div class="col">
                <div class="d-flex align-items-center">
                    <?php echo $__env->make('themes.basic.partials.rating-stars', [
                        'stars' => $user->avg_reviews,
                        'ratings_classes' => 'ratings-lg',
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <span class="d-flex ms-2">
                        <?php echo e(translate(':count out of 5 stars', ['count' => $user->avg_reviews])); ?>

                    </span>
                </div>
            </div>
        </div>
    </div>
    <?php if($reviews->count() > 0): ?>
        <div class="reviews">
            <div class="row row-cols-1 g-4">
                <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php echo $__env->make('themes.basic.partials.item-review', [
                        'item' => $review->item,
                        'review' => $review,
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        <?php echo e($reviews->links()); ?>

    <?php else: ?>
        <div class="card-v border card-bg text-center">
            <div class="py-3">
                <i class="far fa-star fa-lg"></i>
                <p class="mb-0 mt-3"><?php echo e(translate('No reviews found')); ?></p>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('themes.basic.profile.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/taqwahub/public_html/resources/views/themes/basic/profile/reviews.blade.php ENDPATH**/ ?>