<!DOCTYPE html>
<html lang="<?php echo e(getLocale()); ?>" dir="<?php echo e(getDirection()); ?>">

<head>
    <?php echo $__env->make('admin.includes.head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('admin.includes.styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>

<body>
    <?php echo $__env->make('admin.includes.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="vironeer-page-content">
        <?php echo $__env->make('admin.includes.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="container <?php echo $__env->yieldContent('container'); ?>">
            <div class="vironeer-page-body px-1 px-sm-2 px-xxl-0">
                <div class="py-4 g-3">
                    <div class="row g-3 align-items-center">
                        <div class="col">
                            <?php echo $__env->make('admin.partials.breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <?php if (! empty(trim($__env->yieldContent('back')))): ?>
                            <div class="col-auto">
                                <a href="<?php echo $__env->yieldContent('back'); ?>" class="btn btn-secondary"><i
                                        class="fas fa-arrow-left fa-rtl me-2"></i><?php echo e(translate('Back')); ?></a>
                            </div>
                        <?php endif; ?>
                        <?php if (! empty(trim($__env->yieldContent('create')))): ?>
                            <div class="col-auto">
                                <a href="<?php echo $__env->yieldContent('create'); ?>" class="btn btn-primary"><i class="fa fa-plus"></i></a>
                            </div>
                        <?php endif; ?>
                        <?php if (! empty(trim($__env->yieldContent('item_view')))): ?>
                            <?php if($item->isApproved()): ?>
                                <div class="col-auto">
                                    <a href="<?php echo e($item->getLink()); ?>" target="_blank" class="btn btn-dark">
                                        <i class="fa-solid fa-up-right-from-square me-1"></i>
                                        <?php echo e(translate('View Item')); ?>

                                    </a>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                        <?php if (! empty(trim($__env->yieldContent('add_modal')))): ?>
                            <div class="col-auto">
                                <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                    data-bs-target="#addModal">
                                    <i class="fa fa-plus"></i>
                                </button>
                            </div>
                        <?php endif; ?>
                        <?php if (! empty(trim($__env->yieldContent('upload_modal')))): ?>
                            <div class="col-auto">
                                <button type="button" class="btn btn-primary" data-bs-toggle="modal"
                                    data-bs-target="#uploadModal">
                                    <i class="fa fa-upload me-2"></i><?php echo $__env->yieldContent('upload_modal'); ?>
                                </button>
                            </div>
                        <?php endif; ?>
                        <?php if(request()->routeIs('admin.notifications.index')): ?>
                            <?php if($notifications->count() > 0): ?>
                                <div class="col-12 col-lg-auto">
                                    <form action="<?php echo e(route('admin.notifications.read.all')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <button class="action-confirm btn btn-outline-success">
                                            <i class="fa-regular fa-bookmark me-2"></i>
                                            <?php echo e(translate('Make All as Read')); ?>

                                        </button>
                                    </form>
                                </div>
                                <div class="col-12 col-lg-auto">
                                    <form action="<?php echo e(route('admin.notifications.delete.read')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button class="action-confirm btn btn-outline-danger">
                                            <i class="fa-regular fa-trash-can me-2"></i>
                                            <?php echo e(translate('Delete All Read')); ?>

                                        </button>
                                    </form>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                        <?php if(request()->routeIs('admin.system.info.index')): ?>
                            <div class="col-auto">
                                <a href="<?php echo e(config('system.author.profile')); ?>" target="_blank"
                                    class="btn btn-secondary"><i
                                        class="far fa-question-circle me-2"></i><?php echo e(translate('Get Help')); ?></a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="row g-3 g-xl-3">
                    <div class="col">
                        <?php echo $__env->yieldContent('content'); ?>
                    </div>
                </div>
            </div>
        </div>
        <?php echo $__env->make('admin.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <?php echo $__env->make('admin.includes.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>

</html>
<?php /**PATH /home/taqwahub/public_html/resources/views/admin/layouts/grid.blade.php ENDPATH**/ ?>