<?php
    $userBadges = $user->badges;
?>
<?php if($userBadges->count() > 0): ?>
    <div class="card-v card-bg border p-4 mb-3">
        <h5 class="mb-3"><?php echo e(translate('Badges')); ?></h5>
        <div class="row row-cols-auto g-2">
            <?php $__currentLoopData = $userBadges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $userBadge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col">
                    <div class="author-badge">
                        <img src="<?php echo e($userBadge->badge->getImageLink()); ?>" alt="<?php echo e($userBadge->badge->name); ?>"
                            title="<?php echo e($userBadge->badge->getFullTitle()); ?>">
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
<?php endif; ?>
<?php if($user->profile_contact_email): ?>
    <div class="card-v card-bg border p-4 mb-3">
        <h5 class="mb-3">
            <?php echo e(translate('Contact :username', ['username' => $user->username])); ?>

        </h5>
        <?php if(authUser()): ?>
            <form action="<?php echo e(route('profile.sendmail', $user->username)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="mb-3">
                    <label class="form-label"><?php echo e(translate('From')); ?></label>
                    <input class="form-control form-control-md" value="<?php echo e(authUser()->email); ?>" disabled />
                </div>
                <div class="mb-3">
                    <label class="form-label"><?php echo e(translate('Message')); ?></label>
                    <textarea name="message" class="form-control form-control-md" placeholder="<?php echo e(translate('Enter Your Message')); ?>"
                        rows="6" required><?php echo e(old('message')); ?></textarea>
                </div>
                <div class="text-end">
                    <button class="btn btn-primary btn-md"><?php echo e(translate('Send')); ?></button>
                </div>
            </form>
        <?php else: ?>
            <p>
                <?php echo e(translate('Please sign in to contact this :username.', ['username' => $user->username])); ?>

            </p>
            <a href="<?php echo e(route('login')); ?>" class="btn btn-outline-secondary"><?php echo e(translate('Sign In')); ?></a>
        <?php endif; ?>
    </div>
<?php endif; ?>
<?php if($user->profile_social_links): ?>
    <div class="card-v card-bg border p-4">
        <h5 class="mb-3"><?php echo e(translate('Social links')); ?></h5>
        <div class="socials">
            <?php if($user->profile_social_links->facebook): ?>
                <a href="https://facebook.com/<?php echo e($user->profile_social_links->facebook); ?>" target="_blank"
                    class="social-btn social-facebook">
                    <i class="fab fa-facebook-f"></i>
                </a>
            <?php endif; ?>
            <?php if($user->profile_social_links->x): ?>
                <a href="https://x.com/<?php echo e($user->profile_social_links->x); ?>" target="_blank"
                    class="social-btn social-x">
                    <i class="fab fa-x-twitter"></i>
                </a>
            <?php endif; ?>
            <?php if($user->profile_social_links->linkedin): ?>
                <a href="https://linkedin.com/in/<?php echo e($user->profile_social_links->linkedin); ?>" target="_blank"
                    class="social-btn social-linkedin">
                    <i class="fab fa-linkedin"></i>
                </a>
            <?php endif; ?>
            <?php if($user->profile_social_links->youtube): ?>
                <a href="https://youtube.com/<?php echo e('@' . $user->profile_social_links->youtube); ?>" target="_blank"
                    class="social-btn social-youtube">
                    <i class="fab fa-youtube"></i>
                </a>
            <?php endif; ?>
            <?php if($user->profile_social_links->instagram): ?>
                <a href="https://instagram.com/<?php echo e($user->profile_social_links->instagram); ?>" target="_blank"
                    class="social-btn social-instagram">
                    <i class="fab fa-instagram"></i>
                </a>
            <?php endif; ?>
            <?php if($user->profile_social_links->pinterest): ?>
                <a href="https://pinterest.com/<?php echo e($user->profile_social_links->pinterest); ?>" target="_blank"
                    class="social-btn social-pinterest">
                    <i class="fab fa-pinterest"></i>
                </a>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /home/taqwahub/public_html/resources/views/themes/basic/profile/includes/sidebar.blade.php ENDPATH**/ ?>