<div id="searchFiltersSidebar" class="d-none d-xl-block">
    <?php if(isset($category)): ?>
        <?php if($category->subCategories->count() > 0): ?>
            <div class="card-v card-bg border p-4 mb-4">
                <h5 class="mb-4"><?php echo e($category->name); ?></h5>
                <?php $__currentLoopData = $category->subCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="filter-item <?php echo e(!$loop->last ? 'mb-3' : ''); ?>">
                        <a href="<?php echo e(route('categories.sub-category', [$category->slug, $subCategory->slug] + request()->all())); ?>"
                            class="text-dark">
                            <div class="row align-items-center g-3">
                                <div class="col">
                                    <?php echo e($subCategory->name); ?>

                                </div>
                                <div class="col-auto">
                                    <i class="fa-solid fa-tag fa-rtl"></i>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    <?php endif; ?>
    <div class="card-v card-bg border p-4 mb-4">
        <h5 class="mb-4"><?php echo e(translate('Options')); ?></h5>
        <div class="filter-item">
            <div class="form-check">
                <input class="form-check-input search-param" type="checkbox" name="free" value="true"
                    id="op1">
                <label class="form-check-label" for="op1"><?php echo e(translate('Free')); ?></label>
            </div>
        </div>
        <?php if(licenseType(2) && @$settings->premium->status): ?>
            <div class="filter-item">
                <div class="form-check">
                    <input class="form-check-input search-param" type="checkbox" name="premium" value="true"
                        id="op2">
                    <label class="form-check-label" for="op2"><?php echo e(translate('Premium')); ?></label>
                </div>
            </div>
        <?php endif; ?>
        <div class="filter-item">
            <div class="form-check">
                <input class="form-check-input search-param" type="checkbox" name="on_sale" value="true"
                    id="op3">
                <label class="form-check-label" for="op3"><?php echo e(translate('On Sale')); ?></label>
            </div>
        </div>
        <div class="filter-item">
            <div class="form-check">
                <input class="form-check-input search-param" type="checkbox" name="best_selling" value="true"
                    id="op4">
                <label class="form-check-label" for="op4"><?php echo e(translate('Best Selling')); ?></label>
            </div>
        </div>
        <div class="filter-item">
            <div class="form-check">
                <input class="form-check-input search-param" type="checkbox" name="trending" value="true"
                    id="op5">
                <label class="form-check-label" for="op5"><?php echo e(translate('Trending')); ?></label>
            </div>
        </div>
        <div class="filter-item">
            <div class="form-check">
                <input class="form-check-input search-param" type="checkbox" name="featured" value="true"
                    id="op6">
                <label class="form-check-label" for="op6"><?php echo e(translate('Featured')); ?></label>
            </div>
        </div>
    </div>
    <div class="card-v card-bg border p-4 mb-4">
        <h5 class="mb-4"><?php echo e(translate('Price')); ?></h5>
        <div class="filter-item">
            <div class="d-flex align-items-center gap-2">
                <input id="priceForm" type="number" name="min_price" class="form-control form-control-md"
                    placeholder="<?php echo e(translate('min')); ?>" value="<?php echo e(request()->input('min_price')); ?>" />
                <span>-</span>
                <input id="priceTo" type="number" name="max_price" class="form-control form-control-md"
                    placeholder="<?php echo e(translate('max')); ?>" value="<?php echo e(request()->input('max_price')); ?>" />
                <button id="searchByPrice" class="btn btn-primary btn-md btn-padding">
                    <i class="fa fa-arrow-right fa-rtl"></i>
                </button>
            </div>
        </div>
    </div>
    <?php if(isset($category) && $category->categoryOptions->count() > 0): ?>
        <?php $__currentLoopData = $category->categoryOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoryOption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="card-v card-bg border p-4 mb-4">
                <h5 class="mb-4"><?php echo e($categoryOption->name); ?></h5>
                <?php $__currentLoopData = $categoryOption->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="filter-item">
                        <div class="form-check">
                            <input class="form-check-input search-param"
                                type="<?php echo e($categoryOption->isMultiple() ? 'checkbox' : 'radio'); ?>"
                                name="<?php echo e(strtolower(Str::slug($categoryOption->name, '_'))); ?><?php echo e($categoryOption->isMultiple() ? '[]' : ''); ?>"
                                value="<?php echo e(strtolower(Str::slug($value))); ?>" id="cop<?php echo e($key); ?>"
                                <?php echo e($categoryOption->isMultiple() ? 'data-multiple=true' : ''); ?>>
                            <label class="form-check-label" for="cop<?php echo e($key); ?>"><?php echo e($value); ?></label>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    <?php if(@$settings->item->reviews_status): ?>
        <div class="card-v card-bg border p-4 mb-4">
            <h5 class="mb-4"><?php echo e(translate('Rating')); ?></h5>
            <div class="filter-item">
                <div class="form-check">
                    <input class="form-check-input search-param" type="radio" name="stars" value=""
                        id="rating1">
                    <label class="form-check-label" for="rating1"><?php echo e(translate('Show All')); ?></label>
                </div>
            </div>
            <div class="filter-item">
                <div class="form-check">
                    <input class="form-check-input search-param" type="radio" name="stars" value="5"
                        id="rating2">
                    <label class="form-check-label" for="rating2">
                        <div class="row g-2 row-cols-auto align-items-center">
                            <div class="col">
                                <?php echo $__env->make('themes.basic.partials.rating-stars', [
                                    'stars' => 5,
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="col">
                                <?php echo e(translate('5 stars')); ?>

                            </div>
                        </div>
                    </label>
                </div>
            </div>
            <div class="filter-item">
                <div class="form-check">
                    <input class="form-check-input search-param" type="radio" name="stars" value="4"
                        id="rating3">
                    <label class="form-check-label" for="rating3">
                        <div class="row g-2 row-cols-auto align-items-center">
                            <div class="col">
                                <?php echo $__env->make('themes.basic.partials.rating-stars', [
                                    'stars' => 4,
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="col">
                                <?php echo e(translate('4 stars')); ?>

                            </div>
                        </div>
                    </label>
                </div>
            </div>
            <div class="filter-item">
                <div class="form-check">
                    <input class="form-check-input search-param" type="radio" name="stars" value="3"
                        id="rating4">
                    <label class="form-check-label" for="rating4">
                        <div class="row g-2 row-cols-auto align-items-center">
                            <div class="col">
                                <?php echo $__env->make('themes.basic.partials.rating-stars', [
                                    'stars' => 3,
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="col">
                                <?php echo e(translate('3 stars')); ?>

                            </div>
                        </div>
                    </label>
                </div>
            </div>
            <div class="filter-item">
                <div class="form-check">
                    <input class="form-check-input search-param" type="radio" name="stars" value="2"
                        id="rating5">
                    <label class="form-check-label" for="rating5">
                        <div class="row g-2 row-cols-auto align-items-center">
                            <div class="col">
                                <?php echo $__env->make('themes.basic.partials.rating-stars', [
                                    'stars' => 2,
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="col">
                                <?php echo e(translate('2 stars')); ?>

                            </div>
                        </div>
                    </label>
                </div>
            </div>
            <div class="filter-item">
                <div class="form-check">
                    <input class="form-check-input search-param" type="radio" name="stars" value="1"
                        id="rating6">
                    <label class="form-check-label" for="rating6">
                        <div class="row g-2 row-cols-auto align-items-center">
                            <div class="col">
                                <?php echo $__env->make('themes.basic.partials.rating-stars', [
                                    'stars' => 1,
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                            <div class="col">
                                <?php echo e(translate('1 star')); ?>

                            </div>
                        </div>
                    </label>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <div class="card-v card-bg border p-4 mb-4">
        <h5 class="mb-4"><?php echo e(translate('Date Added')); ?></h5>
        <div class="filter-item">
            <div class="form-check">
                <input class="form-check-input search-param" type="radio" name="date" value=""
                    id="date1">
                <label class="form-check-label" for="date1"><?php echo e(translate('Any time')); ?></label>
            </div>
        </div>
        <div class="filter-item">
            <div class="form-check">
                <input class="form-check-input search-param" type="radio" name="date" value="this_month"
                    id="date2">
                <label class="form-check-label" for="date2"><?php echo e(translate('This month')); ?></label>
            </div>
        </div>
        <div class="filter-item">
            <div class="form-check">
                <input class="form-check-input search-param" type="radio" name="date" value="last_month"
                    id="date3">
                <label class="form-check-label" for="date3"><?php echo e(translate('Last month')); ?></label>
            </div>
        </div>
        <div class="filter-item">
            <div class="form-check">
                <input class="form-check-input search-param" type="radio" name="date" value="this_year"
                    id="date4">
                <label class="form-check-label" for="date4"><?php echo e(translate('This year')); ?></label>
            </div>
        </div>
        <div class="filter-item">
            <div class="form-check">
                <input class="form-check-input search-param" type="radio" name="date" value="last_year"
                    id="date5">
                <label class="form-check-label" for="date5"><?php echo e(translate('Last year')); ?></label>
            </div>
        </div>
    </div>
</div>
<div id="searchFiltersMenu">
    <div class="offcanvas offcanvas-start" tabindex="-1" id="searchFilters" aria-labelledby="searchFiltersLabel">
        <div class="offcanvas-header">
            <h5 class="offcanvas-title" id="searchFiltersLabel"><?php echo e(translate('Search Filters')); ?></h5>
            <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
        </div>
        <div class="offcanvas-body">
            <?php if(isset($category)): ?>
                <?php if($category->subCategories->count() > 0): ?>
                    <div class="card-v card-bg border p-4 mb-4">
                        <h5 class="mb-4"><?php echo e($category->name); ?></h5>
                        <?php $__currentLoopData = $category->subCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="filter-item <?php echo e(!$loop->last ? 'mb-3' : ''); ?>">
                                <a href="<?php echo e(route('categories.sub-category', [$category->slug, $subCategory->slug] + request()->all())); ?>"
                                    class="text-dark">
                                    <div class="row align-items-center g-3">
                                        <div class="col">
                                            <?php echo e($subCategory->name); ?>

                                        </div>
                                        <div class="col-auto">
                                            <i class="fa-solid fa-tag fa-rtl"></i>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
            <div class="card-v card-bg border p-4 mb-4">
                <h5 class="mb-4"><?php echo e(translate('Options')); ?></h5>
                <div class="filter-item">
                    <div class="form-check">
                        <input class="form-check-input search-param" type="checkbox" name="free" value="true"
                            id="op1-1">
                        <label class="form-check-label" for="op1-1"><?php echo e(translate('Free')); ?></label>
                    </div>
                </div>
                <?php if(licenseType(2) && @$settings->premium->status): ?>
                    <div class="filter-item">
                        <div class="form-check">
                            <input class="form-check-input search-param" type="checkbox" name="premium"
                                value="true" id="op2-2">
                            <label class="form-check-label" for="op2-2"><?php echo e(translate('Premium')); ?></label>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="filter-item">
                    <div class="form-check">
                        <input class="form-check-input search-param" type="checkbox" name="on_sale" value="true"
                            id="op3-3">
                        <label class="form-check-label" for="op3-3"><?php echo e(translate('On Sale')); ?></label>
                    </div>
                </div>
                <div class="filter-item">
                    <div class="form-check">
                        <input class="form-check-input search-param" type="checkbox" name="best_selling"
                            value="true" id="op4-4">
                        <label class="form-check-label" for="op4-4"><?php echo e(translate('Best Selling')); ?></label>
                    </div>
                </div>
                <div class="filter-item">
                    <div class="form-check">
                        <input class="form-check-input search-param" type="checkbox" name="trending" value="true"
                            id="op5-5">
                        <label class="form-check-label" for="op5-5"><?php echo e(translate('Trending')); ?></label>
                    </div>
                </div>
                <div class="filter-item">
                    <div class="form-check">
                        <input class="form-check-input search-param" type="checkbox" name="featured" value="true"
                            id="op6-6">
                        <label class="form-check-label" for="op6-6"><?php echo e(translate('Featured')); ?></label>
                    </div>
                </div>
            </div>
            <div class="card-v card-bg border p-4 mb-4">
                <h5 class="mb-4"><?php echo e(translate('Price')); ?></h5>
                <div class="filter-item">
                    <div class="d-flex align-items-center gap-2">
                        <input id="priceForm1" type="number" name="min_price" class="form-control form-control-md"
                            placeholder="<?php echo e(translate('min')); ?>" value="<?php echo e(request()->input('min_price')); ?>" />
                        <span>-</span>
                        <input id="priceTo1" type="number" name="max_price" class="form-control form-control-md"
                            placeholder="<?php echo e(translate('max')); ?>" value="<?php echo e(request()->input('max_price')); ?>" />
                        <button id="searchByPrice" class="btn btn-primary btn-md btn-padding">
                            <i class="fa fa-arrow-right fa-rtl"></i>
                        </button>
                    </div>
                </div>
            </div>
            <?php if(isset($category) && $category->categoryOptions->count() > 0): ?>
                <?php $__currentLoopData = $category->categoryOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoryOption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="card-v card-bg border p-4 mb-4">
                        <h5 class="mb-4"><?php echo e($categoryOption->name); ?></h5>
                        <?php $__currentLoopData = $categoryOption->options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="filter-item">
                                <div class="form-check">
                                    <input class="form-check-input search-param"
                                        type="<?php echo e($categoryOption->isMultiple() ? 'checkbox' : 'radio'); ?>"
                                        name="<?php echo e(strtolower(Str::slug($categoryOption->name, '_'))); ?><?php echo e($categoryOption->isMultiple() ? '[]' : ''); ?>"
                                        value="<?php echo e(strtolower(Str::slug($value))); ?>"
                                        id="cop<?php echo e($key); ?>-<?php echo e($key); ?>"
                                        <?php echo e($categoryOption->isMultiple() ? 'data-multiple=true' : ''); ?>>
                                    <label class="form-check-label"
                                        for="cop<?php echo e($key); ?>-<?php echo e($key); ?>"><?php echo e($value); ?></label>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
            <?php if(@$settings->item->reviews_status): ?>
                <div class="card-v card-bg border p-4 mb-4">
                    <h5 class="mb-4"><?php echo e(translate('Rating')); ?></h5>
                    <div class="filter-item">
                        <div class="form-check">
                            <input class="form-check-input search-param" type="radio" name="stars"
                                value="" id="rating1-1">
                            <label class="form-check-label" for="rating1-1"><?php echo e(translate('Show All')); ?></label>
                        </div>
                    </div>
                    <div class="filter-item">
                        <div class="form-check">
                            <input class="form-check-input search-param" type="radio" name="stars"
                                value="5" id="rating2-2">
                            <label class="form-check-label" for="rating2-2">
                                <div class="row g-2 row-cols-auto align-items-center">
                                    <div class="col">
                                        <?php echo $__env->make('themes.basic.partials.rating-stars', [
                                            'stars' => 5,
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                    <div class="col">
                                        <?php echo e(translate('5 stars')); ?>

                                    </div>
                                </div>
                            </label>
                        </div>
                    </div>
                    <div class="filter-item">
                        <div class="form-check">
                            <input class="form-check-input search-param" type="radio" name="stars"
                                value="4" id="rating3-3">
                            <label class="form-check-label" for="rating3-3">
                                <div class="row g-2 row-cols-auto align-items-center">
                                    <div class="col">
                                        <?php echo $__env->make('themes.basic.partials.rating-stars', [
                                            'stars' => 4,
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                    <div class="col">
                                        <?php echo e(translate('4 stars')); ?>

                                    </div>
                                </div>
                            </label>
                        </div>
                    </div>
                    <div class="filter-item">
                        <div class="form-check">
                            <input class="form-check-input search-param" type="radio" name="stars"
                                value="3" id="rating4-4">
                            <label class="form-check-label" for="rating4-4">
                                <div class="row g-2 row-cols-auto align-items-center">
                                    <div class="col">
                                        <?php echo $__env->make('themes.basic.partials.rating-stars', [
                                            'stars' => 3,
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                    <div class="col">
                                        <?php echo e(translate('3 stars')); ?>

                                    </div>
                                </div>
                            </label>
                        </div>
                    </div>
                    <div class="filter-item">
                        <div class="form-check">
                            <input class="form-check-input search-param" type="radio" name="stars"
                                value="2" id="rating5-5">
                            <label class="form-check-label" for="rating5-5">
                                <div class="row g-2 row-cols-auto align-items-center">
                                    <div class="col">
                                        <?php echo $__env->make('themes.basic.partials.rating-stars', [
                                            'stars' => 2,
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                    <div class="col">
                                        <?php echo e(translate('2 stars')); ?>

                                    </div>
                                </div>
                            </label>
                        </div>
                    </div>
                    <div class="filter-item">
                        <div class="form-check">
                            <input class="form-check-input search-param" type="radio" name="stars"
                                value="1" id="rating6-6">
                            <label class="form-check-label" for="rating6-6">
                                <div class="row g-2 row-cols-auto align-items-center">
                                    <div class="col">
                                        <?php echo $__env->make('themes.basic.partials.rating-stars', [
                                            'stars' => 1,
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                    <div class="col">
                                        <?php echo e(translate('1 star')); ?>

                                    </div>
                                </div>
                            </label>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <div class="card-v card-bg border p-4 mb-4">
                <h5 class="mb-4"><?php echo e(translate('Date Added')); ?></h5>
                <div class="filter-item">
                    <div class="form-check">
                        <input class="form-check-input search-param" type="radio" name="date" value=""
                            id="date1-1">
                        <label class="form-check-label" for="date1-1"><?php echo e(translate('Any time')); ?></label>
                    </div>
                </div>
                <div class="filter-item">
                    <div class="form-check">
                        <input class="form-check-input search-param" type="radio" name="date"
                            value="this_month" id="date2-2">
                        <label class="form-check-label" for="date2-2"><?php echo e(translate('This month')); ?></label>
                    </div>
                </div>
                <div class="filter-item">
                    <div class="form-check">
                        <input class="form-check-input search-param" type="radio" name="date"
                            value="last_month" id="date3-3">
                        <label class="form-check-label" for="date3-3"><?php echo e(translate('Last month')); ?></label>
                    </div>
                </div>
                <div class="filter-item">
                    <div class="form-check">
                        <input class="form-check-input search-param" type="radio" name="date" value="this_year"
                            id="date4-4">
                        <label class="form-check-label" for="date4-4"><?php echo e(translate('This year')); ?></label>
                    </div>
                </div>
                <div class="filter-item">
                    <div class="form-check">
                        <input class="form-check-input search-param" type="radio" name="date" value="last_year"
                            id="date5-5">
                        <label class="form-check-label" for="date5-5"><?php echo e(translate('Last year')); ?></label>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/taqwahub/public_html/resources/views/themes/basic/partials/search-params.blade.php ENDPATH**/ ?>