<?php $__env->startSection('section', translate('Categories')); ?>
<?php $__env->startSection('title', translate('Sub Categories')); ?>
<?php $__env->startSection('create', route('admin.categories.sub-categories.create')); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header p-3 border-bottom-small">
            <form action="<?php echo e(request()->url()); ?>" method="GET">
                <div class="row g-3">
                    <div class="col-12 col-lg-7">
                        <input type="text" name="search" class="form-control" placeholder="<?php echo e(translate('Search...')); ?>"
                            value="<?php echo e(request()->input('search') ?? ''); ?>">
                    </div>
                    <div class="col-12 col-lg-3">
                        <select name="category" class="form-select selectpicker" title="<?php echo e(translate('Category')); ?>"
                            data-live-search="true">
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->id); ?>"
                                    <?php echo e($category->id == request('category') ? 'selected' : ''); ?>>
                                    <?php echo e($category->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col">
                        <button class="btn btn-primary w-100"><i class="fa fa-search"></i></button>
                    </div>
                    <div class="col">
                        <a href="<?php echo e(url()->current()); ?>" class="btn btn-secondary w-100"><?php echo e(translate('Reset')); ?></a>
                    </div>
                </div>
            </form>
        </div>
        <div>
            <div class="table-responsive">
                <table class="table vironeer-normal-table sortable-table w-100">
                    <thead>
                        <tr>
                            <th><i class="fa-solid fa-hashtag"></i></th>
                            <th><?php echo e(translate('Name')); ?></th>
                            <th><?php echo e(translate('Main Category')); ?></th>
                            <th class="text-center"><?php echo e(translate('Views')); ?></th>
                            <th class="text-center"><?php echo e(translate('Created date')); ?></th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody class="sortable-table-tbody">
                        <?php $__empty_1 = true; $__currentLoopData = $subCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr data-id="<?php echo e($subCategory->id); ?>">
                                <td>
                                    <span class="sortable-table-handle me-2 text-muted">
                                        <i class="fas fa-arrows-alt fa-lg"></i>
                                    </span>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('admin.categories.sub-categories.edit', $subCategory->id)); ?>"
                                        class="text-dark">
                                        <i class="fa-solid fa-tag me-2"></i>
                                        <span><?php echo e($subCategory->name); ?></span>
                                    </a>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('admin.categories.edit', $subCategory->category->id)); ?>"
                                        class="text-muted">
                                        <i class="fa-solid fa-tags me-2"></i>
                                        <span><?php echo e($subCategory->category->name); ?></span>
                                    </a>

                                </td>
                                <td class="text-center"><span class="badge bg-dark"><?php echo e($subCategory->views); ?></span></td>
                                <td class="text-center"><?php echo e(dateFormat($subCategory->created_at)); ?></td>
                                <td>
                                    <div class="text-end">
                                        <button type="button" class="btn btn-sm rounded-3" data-bs-toggle="dropdown"
                                            aria-expanded="true">
                                            <i class="fa fa-ellipsis-v fa-sm text-muted"></i>
                                        </button>
                                        <ul class="dropdown-menu dropdown-menu-sm-end" data-popper-placement="bottom-end">
                                            <li>
                                                <a class="dropdown-item" href="<?php echo e($subCategory->getLink()); ?>"
                                                    target="_blank"><i
                                                        class="fa fa-eye me-2"></i><?php echo e(translate('View')); ?></a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item"
                                                    href="<?php echo e(route('admin.categories.sub-categories.edit', $subCategory->id)); ?>"><i
                                                        class="fa-regular fa-pen-to-square me-2"></i><?php echo e(translate('Edit')); ?></a>
                                            </li>
                                            <li>
                                                <hr class="dropdown-divider" />
                                            </li>
                                            <li>
                                                <form
                                                    action="<?php echo e(route('admin.categories.sub-categories.destroy', $subCategory->id)); ?>"
                                                    method="POST">
                                                    <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                                    <button class="action-confirm dropdown-item text-danger"><i
                                                            class="far fa-trash-alt me-2"></i><?php echo e(translate('Delete')); ?></button>
                                                </form>
                                            </li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="5" class="text-center">
                                    <span class="text-muted"><?php echo e(translate('No Sub Categories Found')); ?></span>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php $__env->startPush('top_scripts'); ?>
        <script>
            const sortingRoute = "<?php echo e(route('admin.categories.sub-categories.sortable')); ?>";
        </script>
    <?php $__env->stopPush(); ?>
    <?php $__env->startPush('styles_libs'); ?>
        <link rel="stylesheet" href="<?php echo e(asset('vendor/libs/bootstrap/select/bootstrap-select.min.css')); ?>">
        <link href="<?php echo e(asset('vendor/libs/jquery/jquery-ui.min.css')); ?>" />
    <?php $__env->stopPush(); ?>
    <?php $__env->startPush('scripts_libs'); ?>
        <script src="<?php echo e(asset('vendor/libs/bootstrap/select/bootstrap-select.min.js')); ?>"></script>
        <script src="<?php echo e(asset('vendor/libs/jquery/jquery-ui.min.js')); ?>"></script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.grid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/taqwahub/public_html/resources/views/admin/categories/sub-categories/index.blade.php ENDPATH**/ ?>