<?php $__env->startSection('title', translate('Dashboard')); ?>
<?php $__env->startSection('container', 'container-max-xxl'); ?>
<?php $__env->startSection('content'); ?>
    <?php if(!@$settings->cronjob->last_execution): ?>
        <div class="alert alert-danger p-4 mb-4">
            <div class="row row-cols-auto g-4">
                <div class="col">
                    <i class="fas fa-exclamation-triangle fa-3x"></i>
                </div>
                <div class="col">
                    <h4><?php echo e(translate('Cron Job Not Working')); ?></h4>
                    <p class="mb-2">
                        <?php echo e(translate("It seems that your Cron Job isn't set up correctly, which might be causing it not to work as expected. Please double-check and ensure that your Cron Job is properly configured.")); ?>

                    </p>
                    <p class="mb-3">
                        <?php echo e(translate('Cron Job is required by multiple things to be run (Emails, Badges, Discounts, Cache, Sitemap, etc...)')); ?>

                    </p>
                    <a href="<?php echo e(route('admin.system.cronjob.index')); ?>"
                        class="btn btn-outline-danger"><?php echo e(translate('Setup Cron Job')); ?><i
                            class="fa-solid fa-arrow-right ms-2"></i></a>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <?php if(!@$settings->smtp->status): ?>
        <div class="alert alert-warning border border-warning p-4 mb-4">
            <div class="row row-cols-auto g-4">
                <div class="col">
                    <i class="fa-solid fa-circle-info fa-3x"></i>
                </div>
                <div class="col">
                    <h4><?php echo e(translate('SMTP Is Not Enabled')); ?></h4>
                    <p class="mb-3">
                        <?php echo e(translate('SMTP is not enabled, set it now to be able to recover the password and use all the features that needs to send an email.')); ?>

                    </p>
                    <a href="<?php echo e(route('admin.settings.smtp.index')); ?>"
                        class="btn btn-outline-dark"><?php echo e(translate('Setup SMTP')); ?><i
                            class="fa-solid fa-arrow-right ms-2"></i></a>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <div class="card mb-4">
        <div class="card-header fs-5"><?php echo e(translate('Sales Statistics')); ?></div>
        <div class="card-body">
            <div class="row row-cols-1 row-cols-lg-2 row-cols-xxl-4 g-3 mb-3">
                <div class="col">
                    <div class="vironeer-counter-card bg-c-1">
                        <div class="vironeer-counter-card-icon">
                            <i class="fa-solid fa-dollar-sign"></i>
                        </div>
                        <div class="vironeer-counter-card-meta">
                            <p class="vironeer-counter-card-title"><?php echo e(translate('Authors Sales')); ?></p>
                            <p class="vironeer-counter-card-number"><?php echo e(getAmount($counters['authors_sales'])); ?></p>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="vironeer-counter-card bg-c-2">
                        <div class="vironeer-counter-card-icon">
                            <i class="fa-solid fa-circle-dollar-to-slot"></i>
                        </div>
                        <div class="vironeer-counter-card-meta">
                            <p class="vironeer-counter-card-title"><?php echo e(translate('Authors Earnings')); ?></p>
                            <p class="vironeer-counter-card-number"><?php echo e(getAmount($counters['authors_earnings'])); ?></p>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="vironeer-counter-card bg-c-3">
                        <div class="vironeer-counter-card-icon">
                            <i class="fa-solid fa-percent"></i>
                        </div>
                        <div class="vironeer-counter-card-meta">
                            <p class="vironeer-counter-card-title"><?php echo e(translate('Buyer Fees')); ?></p>
                            <p class="vironeer-counter-card-number"><?php echo e(getAmount($counters['buyer_fees'])); ?></p>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="vironeer-counter-card bg-c-4">
                        <div class="vironeer-counter-card-icon">
                            <i class="fa-solid fa-percent"></i>
                        </div>
                        <div class="vironeer-counter-card-meta">
                            <p class="vironeer-counter-card-title"><?php echo e(translate('Author Fees')); ?></p>
                            <p class="vironeer-counter-card-number"><?php echo e(getAmount($counters['author_fees'])); ?></p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row row-cols-1 row-cols-lg-2 row-cols-xxl-3 g-3">
                <div class="col">
                    <div class="vironeer-counter-card bg-c1">
                        <div class="vironeer-counter-card-icon">
                            <i class="fa-solid fa-money-bill-trend-up"></i>
                        </div>
                        <div class="vironeer-counter-card-meta">
                            <p class="vironeer-counter-card-title"><?php echo e(translate('Support Earnings')); ?></p>
                            <p class="vironeer-counter-card-number"><?php echo e(getAmount($counters['support_earning'])); ?></p>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="vironeer-counter-card bg-c-16">
                        <div class="vironeer-counter-card-icon">
                            <i class="fa-solid fa-money-bill-1-wave"></i>
                        </div>
                        <div class="vironeer-counter-card-meta">
                            <p class="vironeer-counter-card-title"><?php echo e(translate('Authors Support Earnings')); ?></p>
                            <p class="vironeer-counter-card-number"><?php echo e(getAmount($counters['authors_support_earnings'])); ?>

                            </p>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="vironeer-counter-card bg-c9">
                        <div class="vironeer-counter-card-icon">
                            <i class="fa-solid fa-percent"></i>
                        </div>
                        <div class="vironeer-counter-card-meta">
                            <p class="vironeer-counter-card-title"><?php echo e(translate('Support Earnings Author fees')); ?></p>
                            <p class="vironeer-counter-card-number">
                                <?php echo e(getAmount($counters['support_earnings_author_fees'])); ?>

                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php if(licenseType(2) && @$settings->premium->status): ?>
        <div class="card mb-4">
            <div class="card-header fs-5"><?php echo e(translate('Premium Statistics')); ?></div>
            <div class="card-body">
                <div class="row g-3 row-cols-1 row-cols-lg-2 row-cols-xxl-4">
                    <div class="col">
                        <div class="vironeer-counter-card bg-c-20">
                            <div class="vironeer-counter-card-icon">
                                <i class="fa-solid fa-crown"></i>
                            </div>
                            <div class="vironeer-counter-card-meta">
                                <p class="vironeer-counter-card-title"><?php echo e(translate('Free Subscriptions')); ?></p>
                                <p class="vironeer-counter-card-number">
                                    <?php echo e(number_format($counters['premium_free_subscriptions'])); ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="col">
                        <div class="vironeer-counter-card bg-c-22">
                            <div class="vironeer-counter-card-icon">
                                <i class="fa-solid fa-crown"></i>
                            </div>
                            <div class="vironeer-counter-card-meta">
                                <p class="vironeer-counter-card-title"><?php echo e(translate('Paid Subscriptions')); ?></p>
                                <p class="vironeer-counter-card-number">
                                    <?php echo e(number_format($counters['premium_paid_subscriptions'])); ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="col">
                        <div class="vironeer-counter-card bg-c-23">
                            <div class="vironeer-counter-card-icon">
                                <i class="fa-solid fa-dollar-sign"></i>
                            </div>
                            <div class="vironeer-counter-card-meta">
                                <p class="vironeer-counter-card-title"><?php echo e(translate('Premium Earnings')); ?></p>
                                <p class="vironeer-counter-card-number">
                                    <?php echo e(getAmount($counters['premium_total_earnings'])); ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="col">
                        <div class="vironeer-counter-card bg-c-25">
                            <div class="vironeer-counter-card-icon">
                                <i class="fa-solid fa-dollar-sign"></i>
                            </div>
                            <div class="vironeer-counter-card-meta">
                                <p class="vironeer-counter-card-title"><?php echo e(translate('Authors Earnings')); ?>

                                </p>
                                <p class="vironeer-counter-card-number">
                                    <?php echo e(getAmount($counters['premium_authors_earnings'])); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <div class="card mb-4">
        <div class="card-header fs-5"><?php echo e(translate('General Statistics')); ?></div>
        <div class="card-body">
            <div class="row row-cols-1 row-cols-lg-2 row-cols-xxl-4 g-3">
                <div class="col">
                    <div class="vironeer-counter-card bg-c-5">
                        <div class="vironeer-counter-card-icon">
                            <i class="fa-solid fa-sack-dollar"></i>
                        </div>
                        <div class="vironeer-counter-card-meta">
                            <p class="vironeer-counter-card-title"><?php echo e(translate('Referral Earnings')); ?></p>
                            <p class="vironeer-counter-card-number"><?php echo e(getAmount($counters['referral_earnings'])); ?></p>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="vironeer-counter-card bg-c-6">
                        <div class="vironeer-counter-card-icon">
                            <i class="fa-solid fa-hand-holding-dollar"></i>
                        </div>
                        <div class="vironeer-counter-card-meta">
                            <p class="vironeer-counter-card-title"><?php echo e(translate('Withdrawal Amount')); ?></p>
                            <p class="vironeer-counter-card-number"><?php echo e(getAmount($counters['withdrawal_amount'])); ?></p>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="vironeer-counter-card bg-c-8">
                        <div class="vironeer-counter-card-icon">
                            <i class="fa-solid fa-money-bill-transfer"></i>
                        </div>
                        <div class="vironeer-counter-card-meta">
                            <p class="vironeer-counter-card-title"><?php echo e(translate('Total Withdrawals')); ?></p>
                            <p class="vironeer-counter-card-number"><?php echo e(number_format($counters['total_withdrawals'])); ?>

                            </p>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="vironeer-counter-card bg-c-9">
                        <div class="vironeer-counter-card-icon">
                            <i class="fa-solid fa-box-open"></i>
                        </div>
                        <div class="vironeer-counter-card-meta">
                            <p class="vironeer-counter-card-title"><?php echo e(translate('Total Items')); ?></p>
                            <p class="vironeer-counter-card-number"><?php echo e(number_format($counters['total_items'])); ?></p>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="vironeer-counter-card bg-c-10">
                        <div class="vironeer-counter-card-icon">
                            <i class="fa-solid fa-cart-arrow-down"></i>
                        </div>
                        <div class="vironeer-counter-card-meta">
                            <p class="vironeer-counter-card-title"><?php echo e(translate('Total Sales')); ?></p>
                            <p class="vironeer-counter-card-number"><?php echo e(number_format($counters['total_sales'])); ?></p>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="vironeer-counter-card bg-c-11">
                        <div class="vironeer-counter-card-icon">
                            <i class="fa-solid fa-share"></i>
                        </div>
                        <div class="vironeer-counter-card-meta">
                            <p class="vironeer-counter-card-title"><?php echo e(translate('Total Refunds')); ?></p>
                            <p class="vironeer-counter-card-number"><?php echo e(number_format($counters['total_refunds'])); ?></p>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="vironeer-counter-card bg-c-19">
                        <div class="vironeer-counter-card-icon">
                            <i class="fa-solid fa-users"></i>
                        </div>
                        <div class="vironeer-counter-card-meta">
                            <p class="vironeer-counter-card-title"><?php echo e(translate('Total Users')); ?></p>
                            <p class="vironeer-counter-card-number"><?php echo e(number_format($counters['total_users'])); ?></p>
                        </div>
                    </div>
                </div>
                <div class="col">
                    <div class="vironeer-counter-card bg-c-13">
                        <div class="vironeer-counter-card-icon">
                            <i class="fa-solid fa-user-group"></i>
                        </div>
                        <div class="vironeer-counter-card-meta">
                            <p class="vironeer-counter-card-title"><?php echo e(translate('Total Authors')); ?></p>
                            <p class="vironeer-counter-card-number"><?php echo e(number_format($counters['total_authors'])); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row g-3 mb-4">
        <div class="col-12 col-lg-6 col-xxl-8">
            <div class="card h-100">
                <div class="vironeer-box chart-bar">
                    <div class="vironeer-box-header">
                        <p class="vironeer-box-header-title large mb-0">
                            <?php echo e(translate('Users Statistics For This Month')); ?>

                        </p>
                        <div class="vironeer-box-header-action ms-auto">
                            <button type="button" class="btn btn-sm rounded-3" data-bs-toggle="dropdown">
                                <i class="fa fa-ellipsis-v"></i>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-sm-end">
                                <li><a class="dropdown-item"
                                        href="<?php echo e(route('admin.members.users.index')); ?>"><?php echo e(translate('View All')); ?></a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="vironeer-box-body">
                        <div class="chart-bar">
                            <canvas id="users-chart"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-lg-6 col-xxl-4">
            <div class="card h-100">
                <div class="vironeer-box v2">
                    <div class="vironeer-box-header mb-3">
                        <p class="vironeer-box-header-title large mb-0"><?php echo e(translate('Recently registered')); ?></p>
                        <div class="vironeer-box-header-action ms-auto">
                            <button type="button" class="btn btn-sm rounded-3" data-bs-toggle="dropdown">
                                <i class="fa fa-ellipsis-v"></i>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-sm-end">
                                <li><a class="dropdown-item"
                                        href="<?php echo e(route('admin.members.users.index')); ?>"><?php echo e(translate('View All')); ?></a>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="vironeer-box-body">
                        <div class="vironeer-random-lists">
                            <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="vironeer-random-list">
                                    <div class="vironeer-random-list-cont">
                                        <a class="vironeer-random-list-img"
                                            href="<?php echo e(route('admin.members.users.edit', $user->id)); ?>">
                                            <img src="<?php echo e($user->getAvatar()); ?>" />
                                        </a>
                                        <div class="vironeer-random-list-info">
                                            <div>
                                                <a class="vironeer-random-list-title fs-exact-14"
                                                    href="<?php echo e(route('admin.members.users.edit', $user->id)); ?>">
                                                    <?php echo e($user->getName()); ?>

                                                </a>
                                                <p class="vironeer-random-list-text mb-0">
                                                    <?php echo e($user->created_at->diffforhumans()); ?>

                                                </p>
                                            </div>
                                            <div class="vironeer-random-list-action d-none d-lg-block">
                                                <a href="<?php echo e(route('admin.members.users.edit', $user->id)); ?>"
                                                    class="btn btn-primary btn-sm"><i class="fas fa-eye"></i></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <?php echo $__env->make('admin.partials.empty', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-lg-6 col-xxl-4">
            <div class="card h-100">
                <div class="vironeer-box v2">
                    <div class="vironeer-box-header mb-3">
                        <p class="vironeer-box-header-title large mb-0"><?php echo e(translate('Top Selling Items')); ?></p>
                    </div>
                    <div class="vironeer-box-body">
                        <div class="vironeer-random-lists">
                            <?php $__empty_1 = true; $__currentLoopData = $topSellingItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $topSellingItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php
                                    $item = $topSellingItem->item;
                                ?>
                                <div class="vironeer-random-list">
                                    <div class="vironeer-random-list-cont">
                                        <a class="vironeer-random-list-img"
                                            href="<?php echo e(route('admin.items.show', $item->id)); ?>">
                                            <img src="<?php echo e($item->getThumbnailLink()); ?>" />
                                        </a>
                                        <div class="vironeer-random-list-info">
                                            <div>
                                                <a class="vironeer-random-list-title fs-exact-14"
                                                    href="<?php echo e(route('admin.items.show', $item->id)); ?>">
                                                    <?php echo e(shorterText($item->name, 50)); ?>

                                                </a>
                                                <p class="vironeer-random-list-text mb-0">
                                                    <?php echo e(translate('Sales (:count)', ['count' => numberFormat($topSellingItem->total_sales)])); ?>

                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <?php echo $__env->make('admin.partials.empty', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-lg-6 col-xxl-8">
            <div class="card h-100">
                <div class="vironeer-box chart-bar">
                    <div class="vironeer-box-header mb-3">
                        <p class="vironeer-box-header-title large mb-0">
                            <?php echo e(translate('Sales Statistics For This Month')); ?>

                        </p>
                    </div>
                    <div class="vironeer-box-body">
                        <div class="chart-bar">
                            <canvas id="sales-chart"></canvas>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-lg-6 col-xxl-8">
            <div class="card h-100">
                <div class="vironeer-box">
                    <div class="vironeer-box-header mb-3">
                        <p class="vironeer-box-header-title large mb-0">
                            <?php echo e(translate('Purchasing Countries')); ?>

                        </p>
                    </div>
                    <div class="vironeer-box-body p-3">
                        <div class="chart-bar">
                            <div id="countries-chart" class="chart w-100"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-12 col-lg-6 col-xxl-4">
            <div class="card h-100">
                <div class="vironeer-box v2">
                    <div class="vironeer-box-header mb-3">
                        <p class="vironeer-box-header-title large mb-0"><?php echo e(translate('Top Purchasing Countries')); ?></p>
                    </div>
                    <div class="vironeer-box-body">
                        <div class="vironeer-random-lists">
                            <?php $__empty_1 = true; $__currentLoopData = $topPurchasingCountries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $topPurchasingCountry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="vironeer-random-list py-2">
                                    <div class="vironeer-random-list-cont">
                                        <div class="vironeer-random-list-img">
                                            <img src="<?php echo e(countryFlag($topPurchasingCountry->country)); ?>"
                                                alt="<?php echo e(countries($topPurchasingCountry->country)); ?>" />
                                        </div>
                                        <div class="vironeer-random-list-info">
                                            <div>
                                                <div class="vironeer-random-list-title fs-exact-14">
                                                    <?php echo e(countries($topPurchasingCountry->country)); ?>

                                                </div>
                                            </div>
                                            <div class="vironeer-random-list-action">
                                                <strong class="text-success">
                                                    <?php echo e(getAmount($topPurchasingCountry->total_spend)); ?>

                                                </strong>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <?php echo $__env->make('admin.partials.empty', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php $__env->startPush('top_scripts'); ?>
        <?php
            $chartsConfig = [
                'users' => $charts['users'],
                'sales' => $charts['sales'],
                'geo' => [
                    'data' => [],
                ],
            ];
            $chartsConfig['geo']['data'][] = ['Country', translate('Sales')];
            if (!$geoCountries->isEmpty()) {
                foreach ($geoCountries as $geoCountry) {
                    $chartsConfig['geo']['data'][] = [$geoCountry->country, (int) $geoCountry->total_sales];
                }
            }
        ?>
        <script>
            "use strict";
            const chartsConfig = <?php echo json_encode($chartsConfig, 15, 512) ?>;
        </script>
    <?php $__env->stopPush(); ?>
    <?php $__env->startPush('scripts_libs'); ?>
        <script src="<?php echo e(asset('vendor/libs/chartjs/chart.min.js')); ?>"></script>
        <script src="<?php echo e(asset('vendor/libs/geochart/geochart.min.js')); ?>"></script>
        <script src="<?php echo e(asset_with_version('vendor/admin/js/charts.js')); ?>"></script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/taqwahub/public_html/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>