<?php if(@$settings->announcement->status && !request()->hasCookie('announce_close')): ?>
    <div class="announcement" style="background-color: <?php echo e(@$settings->announcement->background_color); ?>;">
        <div class="container container-custom d-flex align-items-center position-relative">
            <div class="announcement-text">
                <span><?php echo e(@$settings->announcement->body); ?></span>
                <?php if(@$settings->announcement->button_title && @$settings->announcement->button_link): ?>
                    <a href="<?php echo e(@$settings->announcement->button_link); ?>" class="btn btn-sm ms-2"
                        style="background-color: <?php echo e(@$settings->announcement->button_background_color); ?>; color:<?php echo e(@$settings->announcement->button_text_color); ?>;"><?php echo e(@$settings->announcement->button_title); ?></a>
                <?php endif; ?>
            </div>
            <button class="announcement-close">
                <i class="fa fa-times"></i>
            </button>
        </div>
    </div>
<?php endif; ?>
<div class="nav-bar">
    <div class="container container-custom">
        <div class="nav-bar-container">
            <a href="<?php echo e(route('home')); ?>" class="logo">
                <img src="<?php echo e(asset($themeSettings->general->logo_light)); ?>"
                    alt="<?php echo e(@$settings->general->site_name); ?>" />
            </a>
            <div class="nav-bar-menu ms-auto">
                <div class="overlay"></div>
                <div class="nav-bar-menu-inner">
                    <div class="nav-bar-menu-header">
                        <butaton class="nav-bar-menu-close ms-auto">
                            <i class="fa fa-times"></i>
                        </butaton>
                    </div>
                    <div class="nav-bar-links">
                        <?php $__currentLoopData = $topNavLinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $topNavLink): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($topNavLink->children->count() > 0): ?>
                                <div class="drop-down" data-dropdown data-dropdown-position="top">
                                    <div class="drop-down-btn">
                                        <span class="me-2"><?php echo e($topNavLink->name); ?></span>
                                        <i class="fa fa-angle-down ms-auto"></i>
                                    </div>
                                    <div class="drop-down-menu drop-down-menu-md drop-down-menu-end">
                                        <?php $__currentLoopData = $topNavLink->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a href="<?php echo e($child->link); ?>"
                                                <?php echo e($child->isExternal() ? 'target=_blank' : ''); ?>

                                                class="drop-down-item">
                                                <span><?php echo e($child->name); ?></span>
                                            </a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php else: ?>
                                <a href="<?php echo e($topNavLink->link); ?>"
                                    <?php echo e($topNavLink->isExternal() ? 'target=_blank' : ''); ?> class="link">
                                    <div class="link-title">
                                        <span><?php echo e($topNavLink->name); ?></span>
                                    </div>
                                </a>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php echo $__env->make('themes.basic.partials.currencies-menu', [
                            'group_classes' => 'drop-down-menu-end',
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php if(licenseType(2) && @$settings->premium->status): ?>
                            <a href="<?php echo e(route('premium.index')); ?>" class="link-btn d-block d-xl-none">
                                <button class="btn btn-outline-premium">
                                    <i class="fa-solid fa-crown me-1"></i>
                                    <?php echo e(translate('Premium')); ?>

                                </button>
                            </a>
                        <?php endif; ?>
                        <?php if(auth()->guard()->guest()): ?>
                            <a href="<?php echo e(route('login')); ?>" class="link-btn d-block d-xl-none">
                                <button class="btn btn-outline-primary"><?php echo e(translate('Sign In')); ?></button>
                            </a>
                            <?php if(@$settings->actions->registration): ?>
                                <a href="<?php echo e(route('register')); ?>" class="link-btn d-block d-xl-none">
                                    <button class="btn btn-primary"><?php echo e(translate('Sign Up')); ?></button>
                                </a>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="nav-bar-buttons">
                <?php if(licenseType(2) && @$settings->premium->status): ?>
                    <a href="<?php echo e(route('premium.index')); ?>" class="link-btn">
                        <button class="btn btn-outline-premium">
                            <i class="fa-solid fa-crown me-1"></i>
                            <?php echo e(translate('Premium')); ?>

                        </button>
                    </a>
                <?php endif; ?>
                <a href="<?php echo e(route('cart.index')); ?>" class="link-btn cart-btn d-none d-xl-block">
                    <button class="btn btn-outline-light btn-padding">
                        <i class="fa fa-cart-shopping"></i>
                    </button>
                    <?php if($cartItemsCount): ?>
                        <div class="cart-counter"><?php echo e($cartItemsCount > 99 ? '+99' : $cartItemsCount); ?></div>
                    <?php endif; ?>
                </a>
                <?php if(auth()->guard()->guest()): ?>
                    <a href="<?php echo e(route('login')); ?>" class="link-btn">
                        <button class="btn btn-outline-primary"><?php echo e(translate('Sign In')); ?></button>
                    </a>
                    <?php if(@$settings->actions->registration): ?>
                        <a href="<?php echo e(route('register')); ?>" class="link-btn">
                            <button class="btn btn-primary"><?php echo e(translate('Sign Up')); ?></button>
                        </a>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
            <div class="nav-bar-actions">
                <a href="<?php echo e(route('cart.index')); ?>" class="cart-btn d-block d-xl-none ms-3">
                    <button class="btn btn-outline-light btn-padding">
                        <i class="fa fa-cart-shopping"></i>
                    </button>
                    <?php if($cartItemsCount): ?>
                        <div class="cart-counter"><?php echo e($cartItemsCount > 99 ? '+99' : $cartItemsCount); ?></div>
                    <?php endif; ?>
                </a>
                <?php if(auth()->guard()->check()): ?>
                    <?php echo $__env->make('themes.basic.partials.user-menu', ['menu_class' => 'ms-3 me-0'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
                <div class="nav-bar-menu-btn ms-3">
                    <i class="fa-solid fa-bars fa-lg"></i>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="nav-bar nav-bar-sm nav-bar-bg">
    <div class="container container-custom">
        <div class="nav-bar-container">
            <div class="nav-bar-menu-btn me-3">
                <i class="fa-solid fa-bars fa-lg"></i>
            </div>
            <div class="nav-bar-menu">
                <div class="overlay"></div>
                <div class="nav-bar-menu-inner">
                    <div class="nav-bar-menu-header">
                        <button class="nav-bar-menu-close ms-auto">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                    <div class="nav-bar-links">
                        <?php $__currentLoopData = $bottomNavLinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bottomNavLink): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($bottomNavLink->children->count() > 0): ?>
                                <div class="drop-down" data-dropdown data-dropdown-position="top">
                                    <div class="drop-down-btn">
                                        <span class="me-2"><?php echo e($bottomNavLink->name); ?></span>
                                        <i class="fa fa-angle-down ms-auto"></i>
                                    </div>
                                    <div class="drop-down-menu drop-down-menu-md drop-down-menu-end">
                                        <?php $__currentLoopData = $bottomNavLink->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a href="<?php echo e($child->link); ?>"
                                                <?php echo e($child->isExternal() ? 'target=_blank' : ''); ?>

                                                class="drop-down-item">
                                                <span><?php echo e($child->name); ?></span>
                                            </a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php else: ?>
                                <a href="<?php echo e($bottomNavLink->link); ?>"
                                    <?php echo e($bottomNavLink->isExternal() ? 'target=_blank' : ''); ?> class="link">
                                    <div class="link-title">
                                        <span><?php echo e($bottomNavLink->name); ?></span>
                                    </div>
                                </a>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
            <div class="ms-auto">
                <form action="<?php echo e(route('items.index')); ?>" method="GET">
                    <div class="form-search form-search-reverse">
                        <button class="icon">
                            <i class="fa fa-search"></i>
                        </button>
                        <input type="text" name="search" placeholder="<?php echo e(translate('Search...')); ?>"
                            class="form-control form-control-md" value="<?php echo e(request()->input('search')); ?>" required>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/taqwahub/public_html/resources/views/themes/basic/includes/navbar.blade.php ENDPATH**/ ?>