<div class="tab-pane fade" id="purchases-validation" role="tabpanel" aria-labelledby="purchases-validation-tab">
    <div class="mb-4">
        <h2 class="mb-3"><?php echo e(translate('Purchase Validation')); ?></h2>
        <p>
            <?php echo e(translate('Validate a purchase code and returns details about the purchase if valid.')); ?>

        </p>
        <div class="alert alert-warning" role="alert">
            <div>
                <i class="fa-regular fa-circle-question fa-lg me-1"></i>
                <span><?php echo e(translate('This only works for authors and will not work for regular users.')); ?></span>
            </div>
        </div>
    </div>
    <h4 class="mb-3"><?php echo e(translate('Endpoint')); ?></h4>
    <div class="code mb-3">
        <div class="copy">
            <i class="far fa-clone"></i>
        </div>
        <code>
            <pre class="mb-0"><div class="method post"><?php echo e(translate('POST')); ?></div><div class="endpoint copy-data"><?php echo e(route('api.purchases.validation')); ?></div></pre>
        </code>
    </div>
    <h4 class="mb-3"><?php echo e(translate('Parameters')); ?></h4>
    <ul>
        <li>
            <strong>api_key</strong>: <?php echo e(translate('Your API key')); ?>

            <code>(<?php echo e(translate('required')); ?>)</code>.
        </li>
        <li>
            <strong>purchase_code</strong>:
            <?php echo e(translate('The purchase code to validate')); ?>

            <code>(<?php echo e(translate('required')); ?>)</code>.
        </li>
    </ul>
    <h4 class="mb-3"><?php echo e(translate('Responses')); ?></h4>
    <p><strong><?php echo e(translate('Success Response')); ?>:</strong></p>
    <div class="code mb-3">
        <code>
            <pre class="mb-0 text-success">
{
    "status": "<?php echo e(translate('success')); ?>",
    "data": {
        "purchase": {
            "purchase_code": "abcdefghijklmnopqrstuvwxyz123456789",
            "license_type": "<?php echo e(translate('Regular')); ?>",
            "price": 19.99,
            "currency": "<?php echo e(defaultCurrency()->code); ?>",
            "item": {
                "id": 1,
                "name": "Sample Item",
                "description": "This is a sample item",
                "category": "Category Name",
                "sub_category": "Subcategory Name",
                "options": ["option1", "option2"],
                "version": 1.0.0,
                "demo_link": "https://example.com/demo",
                "tags": ["tag1", "tag2"],
                "media": {
                    "thumbnail": "https://example.com/thumbnail.png",
                    "preview_image": "https://example.com/preview.jpg", // <?php echo e(translate('This is not included for audio items')); ?>

                    "preview_video": "https://example.com/video.mp4", // <?php echo e(translate('This is only included for video items')); ?>

                    "preview_audio": "https://example.com/audio.mp3", // <?php echo e(translate('This is only included for audio items')); ?>

                    "screenshots": [ <?php echo e(translate('This is only included if item has screenshots')); ?>

                        "https://example.com/screenshot1.jpg",
                        "https://example.com/screenshot2.jpg"
                    ],
                },
                "price": {
                    "regular": 19.99,
                    "extended": 29.99
                },
                "currency": "<?php echo e(defaultCurrency()->code); ?>",
                "published_at": "2024-04-27T12:00:00Z"
            },
            "supported_until": "2024-04-27T12:00:00Z", // <?php echo e(translate('This will not exist if support is disabled or its not supported')); ?>

            "downloaded": false,
            "date": "2024-04-27T12:00:00Z"
        }
    }
}</pre>
        </code>
    </div>
    <p><strong><?php echo e(translate('Error Response')); ?>:</strong></p>
    <div class="code mb-3">
        <code>
            <pre class="mb-0 text-danger">
{
    "status": "<?php echo e(translate('error')); ?>",
    "msg": "<?php echo e(translate('Invalid purchase code')); ?>"
}</pre>
        </code>
    </div>
</div>
<?php /**PATH /home/taqwahub/public_html/resources/views/api-docs/sections/purchase-validation.blade.php ENDPATH**/ ?>