<header class="header header-profile"
    <?php echo e($user->isAuthor() ? 'style=background-image:url(' . asset($themeSettings->profile->profile_author_header_background) . ') !important' : ''); ?>>
    <div class="container <?php echo $__env->yieldContent('container'); ?>">
        <div class="header-inner">
            <div class="row row-cols-1 row-cols-md-auto justify-content-between align-items-center g-4">
                <div class="col">
                    <div class="row row-cols-1 row-cols-md-auto text-center text-md-start align-items-center g-2">
                        <div class="col">
                            <div class="user-avatar user-avatar-xl me-1">
                                <img src="<?php echo e($user->getAvatar()); ?>" alt="<?php echo e($user->username); ?>">
                            </div>
                        </div>
                        <div class="col">
                            <div class="d-block text-dark fs-5 mb-1">
                                <h1 class="mb-0 h6 small d-inline">
                                    <?php echo e($user->username); ?>

                                </h1>
                                <?php if($user->isBanned()): ?>
                                    <span class="badge bg-danger fw-light ms-2">
                                        <i class="fa-solid fa-ban me-1"></i>
                                        <?php echo e(translate('Banned')); ?>

                                    </span>
                                <?php endif; ?>
                            </div>
                            <p class="mb-0 fs-6 mb-2">
                                <span class="text-muted small">
                                    <?php echo e(translate('Member since :date', ['date' => dateFormat($user->created_at, 'M Y')])); ?>

                                </span>
                            </p>
                            <div class="row row-cols-auto justify-content-center justify-content-md-start g-2">
                                <?php if($user->isAuthor()): ?>
                                    <div class="col">
                                        <a href="<?php echo e($user->getPortfolioLink()); ?>" class="btn btn-primary">
                                            <span><?php echo e(translate('View Portfolio')); ?></span>
                                        </a>
                                    </div>
                                <?php endif; ?>
                                <div class="col">
                                    <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('follow-button', ['user' => $user])->html();
} elseif ($_instance->childHasBeenRendered('KzfcE8p')) {
    $componentId = $_instance->getRenderedChildComponentId('KzfcE8p');
    $componentTag = $_instance->getRenderedChildComponentTagName('KzfcE8p');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('KzfcE8p');
} else {
    $response = \Livewire\Livewire::mount('follow-button', ['user' => $user]);
    $html = $response->html();
    $_instance->logRenderedChild('KzfcE8p', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if($user->isAuthor()): ?>
                    <div class="col d-flex flex-column align-items-center">
                        <div class="user-stats justify-content-center align-items-center">
                            <div class="user-stat">
                                <p class="user-stat-title"><?php echo e(translate('Sales')); ?></p>
                                <h5 class="user-stat-number fs-5 mb-0"><?php echo e(number_format($user->total_sales)); ?></h5>
                            </div>
                        </div>
                        <?php if(@$settings->item->reviews_status && $user->avg_reviews > 0 && $user->total_reviews > 0): ?>
                            <div class="d-flex flex-column align-items-center gap-2 mt-3">
                                <?php echo $__env->make('themes.basic.partials.rating-stars', [
                                    'stars' => $user->avg_reviews,
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <span class="text-muted small">
                                    <?php echo e(translate($user->total_reviews > 1 ? '(:count Reviews)' : '(:count Review)', [
                                        'count' => $user->total_reviews,
                                    ])); ?>

                                </span>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="dropdown profile-dropdown mb-3 d-block d-lg-none">
            <button class="btn btn-md w-100 dropdown-toggle" type="button" data-bs-toggle="dropdown"
                aria-expanded="false">
                <?php echo $__env->yieldContent('title'); ?>
            </button>
            <ul class="dropdown-menu w-100">
                <li>
                    <a class="dropdown-item <?php echo e(request()->routeIs('profile.index') ? 'active' : ''); ?>"
                        href="<?php echo e($user->getProfileLink()); ?>">
                        <?php echo e(translate('Profile')); ?>

                    </a>
                </li>
                <?php if($user->isAuthor()): ?>
                    <li>
                        <a class="dropdown-item <?php echo e(request()->routeIs('profile.portfolio') ? 'active' : ''); ?>"
                            href="<?php echo e($user->getPortfolioLink()); ?>">
                            <?php echo e(translate('Portfolio')); ?>

                        </a>
                    </li>
                <?php endif; ?>
                <li>
                    <a class="dropdown-item <?php echo e(request()->routeIs('profile.followers') ? 'active' : ''); ?>"
                        href="<?php echo e(route('profile.followers', strtolower($user->username))); ?>">
                        <?php echo e(translate('Followers (:count)', ['count' => numberFormat($user->total_followers)])); ?>

                    </a>
                </li>
                <li>
                    <a class="dropdown-item <?php echo e(request()->routeIs('profile.following') ? 'active' : ''); ?>"
                        href="<?php echo e(route('profile.following', strtolower($user->username))); ?>">
                        <?php echo e(translate('Following (:count)', ['count' => numberFormat($user->total_following)])); ?>

                    </a>
                </li>
                <?php if($user->isAuthor() && @$settings->item->reviews_status): ?>
                    <li>
                        <a class="dropdown-item <?php echo e(request()->routeIs('profile.reviews') ? 'active' : ''); ?>"
                            href="<?php echo e(route('profile.reviews', strtolower($user->username))); ?>">
                            <?php echo e(translate('Reviews (:count)', ['count' => numberFormat($user->total_reviews)])); ?>

                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
        <div class="tabs-custom v2 position-relative d-none d-lg-block">
            <nav class="nav nav-tabs">
                <a href="<?php echo e($user->getProfileLink()); ?>"
                    class="nav-link <?php echo e(request()->routeIs('profile.index') ? 'active' : ''); ?>">
                    <?php echo e(translate('Profile')); ?>

                </a>
                <?php if($user->isAuthor()): ?>
                    <a href="<?php echo e($user->getPortfolioLink()); ?>"
                        class="nav-link <?php echo e(request()->routeIs('profile.portfolio') ? 'active' : ''); ?>">
                        <?php echo e(translate('Portfolio')); ?>

                    </a>
                <?php endif; ?>
                <a href="<?php echo e(route('profile.followers', strtolower($user->username))); ?>"
                    class="nav-link  <?php echo e(request()->routeIs('profile.followers') ? 'active' : ''); ?>">
                    <?php echo e(translate('Followers (:count)', ['count' => numberFormat($user->total_followers)])); ?>

                </a>
                <a href="<?php echo e(route('profile.following', strtolower($user->username))); ?>"
                    class="nav-link  <?php echo e(request()->routeIs('profile.following') ? 'active' : ''); ?>">
                    <?php echo e(translate('Following (:count)', ['count' => numberFormat($user->total_following)])); ?>

                </a>
                <?php if($user->isAuthor() && @$settings->item->reviews_status): ?>
                    <a href="<?php echo e(route('profile.reviews', strtolower($user->username))); ?>"
                        class="nav-link <?php echo e(request()->routeIs('profile.reviews') ? 'active' : ''); ?>">
                        <?php echo e(translate('Reviews (:count)', ['count' => numberFormat($user->total_reviews)])); ?>

                    </a>
                <?php endif; ?>
            </nav>
        </div>
    </div>
</header>
<?php /**PATH /home/taqwahub/public_html/resources/views/themes/basic/profile/includes/header.blade.php ENDPATH**/ ?>