<?php $__env->startSection('title', translate('Transactions')); ?>
<?php $__env->startSection('container', 'container-max-xxl'); ?>
<?php $__env->startSection('content'); ?>
    <div class="row row-cols-1 row-cols-lg-2 row-cols-xxl-3 g-3 mb-4">
        <div class="col">
            <div class="vironeer-counter-card bg-orange">
                <div class="vironeer-counter-card-bg"></div>
                <div class="vironeer-counter-card-icon">
                    <i class="fa-regular fa-hourglass-half"></i>
                </div>
                <div class="vironeer-counter-card-meta">
                    <p class="vironeer-counter-card-title"><?php echo e(translate('Pending')); ?>

                        (<?php echo e(numberFormat($counters['pending']['total'])); ?>)</p>
                    <p class="vironeer-counter-card-number"><?php echo e(getAmount($counters['pending']['amount'])); ?></p>
                </div>
            </div>
        </div>
        <div class="col">
            <div class="vironeer-counter-card bg-green">
                <div class="vironeer-counter-card-bg"></div>
                <div class="vironeer-counter-card-icon">
                    <i class="fa-solid fa-check"></i>
                </div>
                <div class="vironeer-counter-card-meta">
                    <p class="vironeer-counter-card-title"><?php echo e(translate('Paid')); ?>

                        (<?php echo e(numberFormat($counters['paid']['total'])); ?>)</p>
                    <p class="vironeer-counter-card-number"><?php echo e(getAmount($counters['paid']['amount'])); ?></p>
                </div>
            </div>
        </div>
        <div class="col">
            <div class="vironeer-counter-card bg-red">
                <div class="vironeer-counter-card-bg"></div>
                <div class="vironeer-counter-card-icon">
                    <i class="fa-solid fa-xmark"></i>
                </div>
                <div class="vironeer-counter-card-meta">
                    <p class="vironeer-counter-card-title"><?php echo e(translate('Cancelled')); ?>

                        (<?php echo e(numberFormat($counters['cancelled']['total'])); ?>)</p>
                    <p class="vironeer-counter-card-number"><?php echo e(getAmount($counters['cancelled']['amount'])); ?></p>
                </div>
            </div>
        </div>
    </div>
    <div class="card">
        <div class="card-header p-3 border-bottom-small">
            <form action="<?php echo e(request()->url()); ?>" method="GET">
                <div class="row g-3">
                    <div class="col-lg-6">
                        <input type="text" name="search" class="form-control"
                            placeholder="<?php echo e(translate('Search...')); ?>" value="<?php echo e(request('search') ?? ''); ?>">
                    </div>
                    <div class="col-lg-3">
                        <input type="text" name="date_from" class="form-control text-secondary"
                            placeholder="<?php echo e(translate('From Date')); ?>" onfocus="(this.type='date')"
                            onblur="(this.type='text')" value="<?php echo e(request('date_from')); ?>">
                    </div>
                    <div class="col-lg-3">
                        <input type="text" name="date_to" class="form-control text-secondary"
                            placeholder="<?php echo e(translate('To Date')); ?>" onfocus="(this.type='date')"
                            onblur="(this.type='text')" value="<?php echo e(request('date_to')); ?>">
                    </div>
                    <div class="col-12 col-lg-4">
                        <select name="payment_method" class="form-select selectpicker"
                            title="<?php echo e(translate('Payment Method')); ?>" data-live-search="true">
                            <?php $__currentLoopData = $paymentGateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paymentGateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($paymentGateway->id); ?>" <?php if(request('payment_method') == $paymentGateway->id): echo 'selected'; endif; ?>>
                                    <?php echo e($paymentGateway->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-lg-3">
                        <select name="type" class="form-select selectpicker" title="<?php echo e(translate('Type')); ?>">
                            <?php $__currentLoopData = \App\Models\Transaction::getTypeOptions(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>" <?php if(request('type') == $key): echo 'selected'; endif; ?>>
                                    <?php echo e($value); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-12 col-lg-3">
                        <select name="status" class="form-select selectpicker" title="<?php echo e(translate('Status')); ?>">
                            <?php $__currentLoopData = \App\Models\Transaction::getStatusOptions(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($key); ?>" <?php if($key == request('status')): echo 'selected'; endif; ?>>
                                    <?php echo e($value); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col">
                        <button class="btn btn-primary w-100"><i class="fa fa-search"></i></button>
                    </div>
                    <div class="col">
                        <a href="<?php echo e(url()->current()); ?>" class="btn btn-secondary w-100"><?php echo e(translate('Reset')); ?></a>
                    </div>
                </div>
            </form>
        </div>
        <div>
            <?php if($transactions->count() > 0): ?>
                <div class="table-responsive">
                    <table class="vironeer-normal-table table w-100">
                        <thead>
                            <tr class="bg-light">
                                <th><?php echo e(translate('ID')); ?></th>
                                <th><?php echo e(translate('User')); ?></th>
                                <th class="text-center"><?php echo e(translate('SubTotal')); ?></th>
                                <th class="text-center"><?php echo e(translate('Tax')); ?></th>
                                <th class="text-center"><?php echo e(translate('Fees')); ?></th>
                                <th class="text-center"><?php echo e(translate('Total')); ?></th>
                                <th class="text-center"><?php echo e(translate('Type')); ?></th>
                                <th class="text-center"><?php echo e(translate('Status')); ?></th>
                                <th class="text-center"><?php echo e(translate('Date')); ?></th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <a href="<?php echo e(route('admin.transactions.review', $trx->id)); ?>">
                                            <i class="fa-solid fa-hashtag"></i>
                                            <?php echo e($trx->id); ?>

                                        </a>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('admin.members.users.edit', $trx->user->id)); ?>"
                                            class="text-dark">
                                            <i class="fa fa-user me-2"></i>
                                            <?php echo e($trx->user->username); ?>

                                        </a>
                                    </td>
                                    <td class="text-center text-dark"><?php echo e(getAmount($trx->amount)); ?></td>
                                    <td class="text-center text-dark">
                                        <?php echo e(getAmount($trx->hasTax() ? $trx->tax->amount : 0)); ?>

                                    </td>
                                    <td class="text-center text-dark"><?php echo e(getAmount($trx->fees)); ?></td>
                                    <td class="text-center text-dark"><strong><?php echo e(getAmount($trx->total)); ?></strong></td>
                                    <td class="text-center text-dark">
                                        <?php echo e($trx->getTypeName()); ?>

                                    </td>
                                    <td class="text-center">
                                        <?php if($trx->isPending()): ?>
                                            <div class="badge bg-orange">
                                                <?php echo e($trx->getStatusName()); ?>

                                            </div>
                                        <?php elseif($trx->isPaid()): ?>
                                            <div class="badge bg-green">
                                                <?php echo e($trx->getStatusName()); ?>

                                            </div>
                                        <?php elseif($trx->isCancelled()): ?>
                                            <div class="badge bg-red">
                                                <?php echo e($trx->getStatusName()); ?>

                                            </div>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center"><?php echo e(dateFormat($trx->created_at)); ?></td>
                                    <td>
                                        <div class="text-end">
                                            <button type="button" class="btn btn-sm rounded-3" data-bs-toggle="dropdown"
                                                aria-expanded="true">
                                                <i class="fa fa-ellipsis-v fa-sm text-muted"></i>
                                            </button>
                                            <ul class="dropdown-menu dropdown-menu-sm-end"
                                                data-popper-placement="bottom-end">
                                                <li>
                                                    <a class="dropdown-item"
                                                        href="<?php echo e(route('admin.transactions.review', $trx->id)); ?>"><i
                                                            class="fa-solid fa-desktop me-2"></i><?php echo e(translate('Details')); ?></a>
                                                </li>
                                                <li>
                                                    <hr class="dropdown-divider" />
                                                </li>
                                                <li>
                                                    <form action="<?php echo e(route('admin.transactions.destroy', $trx->id)); ?>"
                                                        method="POST">
                                                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                                        <button class="dropdown-item action-confirm text-danger"><i
                                                                class="far fa-trash-alt me-2"></i><?php echo e(translate('Delete')); ?></button>
                                                    </form>
                                                </li>
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <?php echo $__env->make('admin.partials.empty', ['empty_classes' => 'empty-lg'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        </div>
    </div>
    <?php echo e($transactions->links()); ?>

    <?php $__env->startPush('styles_libs'); ?>
        <link rel="stylesheet" href="<?php echo e(asset('vendor/libs/bootstrap/select/bootstrap-select.min.css')); ?>">
    <?php $__env->stopPush(); ?>
    <?php $__env->startPush('scripts_libs'); ?>
        <script src="<?php echo e(asset('vendor/libs/bootstrap/select/bootstrap-select.min.js')); ?>"></script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.grid', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/taqwahub/public_html/resources/views/admin/transactions/index.blade.php ENDPATH**/ ?>