<!DOCTYPE html>
<html lang="<?php echo e(getLocale()); ?>" dir="<?php echo e(getDirection()); ?>">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta http-equiv="X-UA-Compatible" content="ie=edge" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
    <?php $__env->startSection('title', translate('API Docs')); ?>
    <title><?php echo e(seoTitle($__env)); ?></title>
    <link rel="shortcut icon" href="<?php echo e(asset($themeSettings->general->favicon)); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('vendor/libs/fontawesome/fontawesome.min.css')); ?>" />
     <link rel="stylesheet" href="<?php echo e(asset("vendor/libs/bootstrap/bootstrap.min.css")); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('vendor/api-docs/css/app.css')); ?>" />
</head>

<body>
    <div class="page">
        <?php echo $__env->make('api-docs.includes.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="content">
            <div class="content-container">
                <div class="tab-content">
                    <?php echo $__env->make('api-docs.sections.overview', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php echo $__env->make('api-docs.sections.authentication', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php echo $__env->make('api-docs.sections.account-details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php echo $__env->make('api-docs.sections.items-all', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php echo $__env->make('api-docs.sections.items-item', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php echo $__env->make('api-docs.sections.purchase-validation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>
    </div>
    <script src="<?php echo e(asset('vendor/libs/jquery/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('vendor/libs/bootstrap/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('vendor/libs/clipboard/clipboard.min.js')); ?>"></script>
    <script src="<?php echo e(asset('vendor/api-docs/js/app.js')); ?>"></script>
</body>

</html>
<?php /**PATH /home/taqwahub/public_html/resources/views/api-docs/index.blade.php ENDPATH**/ ?>