<?php $__env->startSection('panel'); ?>
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <script src="https://cdn.tailwindcss.com"></script>
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Kanit:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
        <style>
    :root {
      --primary: #4f308e;
      --secondary: #8f5fe8;
      --accent: #00c897;
      --dark: #1a1a2e;
      --light: #f8f9fa;
    }

    * {
      font-family: "Poppins", sans-serif;
      -webkit-touch-callout: none;
      -webkit-user-select: none;
      -moz-user-select: none;
      user-select: none;
      box-sizing: border-box;
      padding: 0;
      margin: 0;
    }

    body {
      background: linear-gradient(135deg, #f5f7fa 0%, #e4e8f0 100%);
      min-height: 100vh;
      display: flex;
      justify-content: center;
      align-items: center;
    }

    .register-container {
      width: 100%;
      max-width: 450px;
      background: white;
      border-radius: 16px;
      box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
      overflow: hidden;
      position: relative;
      z-index: 1;
    }

    .register-container::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      height: 8px;
      background: linear-gradient(90deg, var(--primary), var(--secondary));
    }

    .logo-container {
      display: flex;
      justify-content: center;
      margin-top: -40px;
      margin-bottom: 20px;
    }

    .logo {
      width: 100px;
      height: 100px;
      border-radius: 50%;
      border: 5px solid white;
      box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
      background: white;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .logo img {
      width: 80%;
      height: auto;
    }

    .form-group {
      margin-bottom: 1.2rem;
      position: relative;
    }

    .input-icon {
      position: absolute;
      left: 15px;
      top: 50%;
      transform: translateY(-50%);
      color: var(--primary);
      font-size: 1.1rem;
    }

    .form-control {
      width: 100%;
      padding: 12px 20px 12px 50px;
      border: 2px solid #e2e8f0;
      border-radius: 8px;
      font-size: 0.95rem;
      transition: all 0.3s ease;
      background-color: #f8fafc;
    }

    .form-control:focus {
      outline: none;
      border-color: var(--primary);
      box-shadow: 0 0 0 3px rgba(79, 48, 142, 0.2);
      background-color: white;
    }

    .btn-register {
      width: 100%;
      padding: 14px;
      border: none;
      border-radius: 8px;
      background: linear-gradient(135deg, var(--primary), var(--secondary));
      color: white;
      font-size: 1rem;
      font-weight: 600;
      cursor: pointer;
      transition: all 0.3s ease;
      margin-top: 15px;
    }

    .btn-register:hover {
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(79, 48, 142, 0.4);
    }

    .auth-footer {
      text-align: center;
      margin-top: 1.5rem;
      color: #64748b;
    }

    .auth-footer a {
      color: var(--primary);
      font-weight: 600;
      text-decoration: none;
      transition: all 0.3s ease;
    }

    .auth-footer a:hover {
      color: var(--secondary);
    }

    .theme-selector {
      display: flex;
      justify-content: center;
      gap: 10px;
      margin-top: 1.5rem;
    }

    .theme-btn {
      width: 25px;
      height: 25px;
      border-radius: 50%;
      border: 2px solid white;
      cursor: pointer;
      transition: transform 0.3s ease;
      box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
    }

    .theme-btn:hover {
      transform: scale(1.1);
    }

    /* Theme Colors */
    .theme-1 { background: linear-gradient(90deg, #12c2e9, #c471ed, #f64f59); }
    .theme-2 { background: linear-gradient(90deg, #4f308e, #7258a4); }
    .theme-3 { background: linear-gradient(90deg, #00c6ff, #0072ff); }
    .theme-4 { background: linear-gradient(90deg, #6a11cb, #2575fc); }
    .theme-5 { background: linear-gradient(90deg, #f12711, #f5af19); }
    .theme-6 { background: linear-gradient(90deg, #11998e, #38ef7d); }

    /* Responsive adjustments */
    @media (max-width: 480px) {
      .register-container {
        margin: 20px;
        width: calc(100% - 40px);
        padding: 1.5rem;
      }
      
      .logo {
        width: 80px;
        height: 80px;
      }
      
      .form-control {
        padding: 10px 15px 10px 45px;
        font-size: 0.9rem;
      }
      
      .input-icon {
        font-size: 1rem;
        left: 12px;
      }
    }
  </style>
         </head>
    <body>
        <div class="register-container p-8">
    <div class="logo-container">
      <div class="logo">
        <img src="https://kkkkkk.hatiya-panel.site/assets/images/logoIcon/logo.png" alt="Dabdlab Logo">
      </div>
    </div>
    
                          <form id="regi"  method="post" action="<?php echo e(route('user.register')); ?>">
                              <?php echo csrf_field(); ?>                        
                               <div class="form-group">
        <div class="input-icon">
          <i class="fas fa-user"></i>
        </div>
        <input type="text" name="firstname" class="form-control" placeholder="Full Name" required>
      </div>
      
      <div class="form-group">
        <div class="input-icon">
          <i class="fas fa-phone"></i>
        </div>
        <input type="number" name="mobile" class="form-control" placeholder="Mobile Number" required>
      </div>
      
      <div class="form-group">
        <div class="input-icon">
          <i class="fas fa-at"></i>
        </div>
        <input type="text" name="username" class="form-control" placeholder="Username" required>
      </div>
      
      <div class="form-group">
        <div class="input-icon">
          <i class="fas fa-lock"></i>
        </div>
        <input type="password" name="password" class="form-control" placeholder="Password" required>
      </div>
      
      <div class="form-group">
        <div class="input-icon">
          <i class="fas fa-lock"></i>
        </div>
        <input type="password" name="password_confirmation" class="form-control" placeholder="Confirm Password" required>
      </div>
      
      <button type="submit" class="btn-register">Register Now</button>
      
      <div class="auth-footer">
        <p>Already have an account? <a href="/user/login">Login here</a></p>
      </div>
      
      <div class="theme-selector">
        <div class="theme-btn theme-1" data-theme="theme-1"></div>
        <div class="theme-btn theme-2" data-theme="theme-2"></div>
        <div class="theme-btn theme-3" data-theme="theme-3"></div>
        <div class="theme-btn theme-4" data-theme="theme-4"></div>
        <div class="theme-btn theme-5" data-theme="theme-5"></div>
        <div class="theme-btn theme-6" data-theme="theme-6"></div>
      </div>
    </form>
  </div>
      
        
                  <script src="<?php echo e(asset('assets/front/js/jquery.min.js')); ?>"></script>
                  <script src="<?php echo e(asset('assets/front/js/popper.min.js')); ?>"></script>
                       
                 <link rel="stylesheet" href="<?php echo e(asset('assets/front/css/iziToast.min.css')); ?>">
               <script src="<?php echo e(asset('assets/front/js/iziToast.min.js')); ?>"></script>
                  
      <script type="text/javascript">
          (function($,document){
              "use strict";
                              function notify(status,message) {
                  iziToast[status]({
                      message: message,
                      position: "topRight"
                  });
              }
          })(jQuery);
      </script>
      
            <script>
            (function ($,document) {
                  "use strict";
                    $('select[name=country]').val("");
              })(jQuery,document);
          </script>
      </body>
      </html>
       
</div>

<!-- Modal -->

<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .country-code .input-group-text {
            background: #fff !important;
        }

        .country-code select {
            border: none;
        }

        .country-code select:focus {
            border: none;
            outline: none;
        }
            .btn {
            border: 1px solid transparent !important;
        }

        .content-area {
            z-index: -1;
            height: 100%;
        }

        .btn-outline-linkedin {
            border-color: #0077B5 !important;
            background-color: #0077B5;
            color: #ffff;
        }

        .btn-outline-linkedin:hover {
            border-color: #0077B5 !important;
            color: #fff !important;
            background-color: #0077B5;
        }

        .btn-outline-facebook {
            border-color: #395498 !important;
            background-color: #395498;
            color: #ffff;
        }

        .btn-outline-facebook:hover {
            border-color: #395498 !important;
            color: #fff !important;
            background-color: #395498;
        }

        .btn-outline-google {
            border-color: #D64937 !important;
            background-color: #D64937;
            color: #ffff;
        }

        .btn-outline-google:hover {
            border-color: #D64937;
            color: #fff !important;
            background-color: #D64937;
        }

        .socials-buttons .btn {
            width: calc(33% - 10px);
        }

        @media (max-width: 424px) {
            .socials-buttons .btn {
                width: 100%;
                margin-bottom: 10px;
            }
        }
    </style>
<?php $__env->stopPush(); ?>


<?php if($general->secure_password): ?>
    <?php $__env->startPush('script-lib'); ?>
        <script src="<?php echo e(asset('assets/global/js/secure_password.js')); ?>"></script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>

<?php $__env->startPush('script'); ?>
<script src="<?php echo e(asset('assets/front/js/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/front/js/popper.min.js')); ?>"></script>
     
<link rel="stylesheet" href="<?php echo e(asset('assets/front/css/iziToast.min.css')); ?>">
<script src="<?php echo e(asset('assets/front/js/iziToast.min.js')); ?>"></script>
    <script>
        "use strict";
        (function($) {
            <?php if($mobileCode): ?>
                $(`option[data-code=<?php echo e($mobileCode); ?>]`).attr('selected', '');
            <?php endif; ?>

            $('select[name=country]').change(function() {
                $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
                $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
                $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));
            });
            $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
            $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
            $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));

            $('.checkUser').on('focusout', function(e) {
                var url = '<?php echo e(route('user.checkUser')); ?>';
                var value = $(this).val();
                var token = '<?php echo e(csrf_token()); ?>';
                if ($(this).attr('name') == 'mobile') {
                    var mobile = `${$('.mobile-code').text().substr(1)}${value}`;
                    var data = {
                        mobile: mobile,
                        _token: token
                    }
                }
                if ($(this).attr('name') == 'email') {
                    var data = {
                        email: value,
                        _token: token
                    }
                }
                if ($(this).attr('name') == 'username') {
                    var data = {
                        username: value,
                        _token: token
                    }
                }
                $.post(url, data, function(response) {
                    if (response.data != false && response.type == 'email') {
                        $('#existModalCenter').modal('show');
                    } else if (response.data != false) {
                        $(`.${response.type}Exist`).text(`${response.type} already exist`);
                    } else {
                        $(`.${response.type}Exist`).text('');
                    }
                });
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ecmrce/public_html/core/resources/views/templates/smartlab/user/auth/register.blade.php ENDPATH**/ ?>