<?php $__env->startSection('panel'); ?>
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <form role="form" method="POST" action="<?php echo e(route("admin.ptc.update",$ptc->id)); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                       <div class="form-group col-md-8">
                        <label><?php echo app('translator')->get('Title of the Ad'); ?></label>
                        <input type="text" name="title" class="form-control" value="<?php echo e($ptc->title); ?>" placeholder="<?php echo app('translator')->get('Title'); ?>" required>
                    </div>

                    <div class="form-group col-md-4">
                        <label><?php echo app('translator')->get('Amount'); ?></label>
                        <div class="input-group">
                            <input type="number" step="any" name="amount" class="form-control" value="<?php echo e(getAmount($ptc->amount)); ?>" placeholder="<?php echo app('translator')->get('User will get ...'); ?>" required>
                            <div class="input-group-text"> <?php echo e($general->cur_text); ?> </div>
                        </div>
                    </div>


                    <div class="form-group col-md-4">
                        <label><?php echo app('translator')->get('Duration'); ?></label>
                        <div class="input-group">
                            <input type="number" name="duration" class="form-control" value="<?php echo e($ptc->duration); ?>" placeholder="<?php echo app('translator')->get('Duration'); ?>" required>
                            <div class="input-group-text"><?php echo app('translator')->get('SECONDS'); ?></div>
                        </div>
                    </div>

                    <div class="form-group col-md-4">
                        <label><?php echo app('translator')->get('Maximum Show'); ?></label>
                        <div class="input-group">
                            <input type="number" name="max_show" class="form-control" value="<?php echo e($ptc->max_show); ?>" placeholder="<?php echo app('translator')->get('Maximum Show'); ?> " required>
                            <div class="input-group-text"><?php echo app('translator')->get('Times'); ?></div>
                        </div>
                    </div>

                    <div class="form-group col-md-4">
                        <label><?php echo app('translator')->get('Status'); ?></label>
                        <select class="form-control" name="status" <?php if($ptc->status == 3): echo 'disabled'; endif; ?> required>
                            <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                            <option value="1"><?php echo app('translator')->get('Active / Approve'); ?></option>
                            <option value="2"><?php echo app('translator')->get('Pending / Under Review'); ?></option>
                            <option value="0"><?php echo app('translator')->get('Inactive'); ?></option>
                            <option value="3"><?php echo app('translator')->get('Reject'); ?></option>
                        </select>
                        <?php if($ptc->status == 3): ?> <input type="hidden" name="status" value="3"> <?php endif; ?>
                    </div>

                    <div class="form-group col-md-4 d-none" id="rejectReason">
                        <label><?php echo app('translator')->get('Reject Reason'); ?></label>
                        <div class="input-group">
                            <textarea name="reject_reason" class="form-control"><?php echo e($ptc->reject_reason); ?></textarea>
                        </div>
                    </div>

                </div>


                <div class="row pt-5 mt-5 border-top">
                    <div class="form-group col-md-4">
                        <label for="ads_type"><?php echo app('translator')->get('Advertisement Type'); ?></label>
                        <input type="hidden" name="ads_type" value="<?php echo e($ptc->ads_type); ?>">
                        <div class="pt-3">
                            <?php echo $ptc->typeBadge ?>
                        </div>
                    </div>
                    <?php if($ptc->ads_type == 1): ?>

                    <div class="form-group col-md-8">
                        <label><?php echo app('translator')->get('Link'); ?> <span class="text-danger">*</span></label>
                        <input type="text" name="website_link" class="form-control" value="<?php echo e($ptc->ads_body); ?>" placeholder="<?php echo app('translator')->get('http://example.com'); ?>">
                    </div>
                    <?php elseif($ptc->ads_type == 2): ?>

                    <div class="form-group col-md-4 ">
                        <label><?php echo app('translator')->get('Banner'); ?></label>
                        <input type="file" class="form-control"  name="banner_image">
                    </div>

                       <div class="form-group col-md-4 ">

                        <label><?php echo app('translator')->get('Current Banner'); ?> <span class="text-danger">*</span></label>
                        <img src="<?php echo e(getImage(getFilePath('ptc').'/'.$ptc->ads_body)); ?>" class="w-100">

                    </div>

                    <?php elseif($ptc->ads_type == 3): ?>

                    <div class="form-group col-md-8">
                        <label><?php echo app('translator')->get('Script'); ?> <span class="text-danger">*</span></label>
                        <textarea  name="script" class="form-control"><?php echo e($ptc->ads_body); ?></textarea>
                    </div>

                    <?php else: ?>
                        <div class="form-group col-md-8">
                            <label><?php echo app('translator')->get('Youtube Embaded Link'); ?> <span class="text-danger">*</span></label>
                            <input type="text" name="youtube" class="form-control" value="<?php echo e($ptc->ads_body); ?>">
                        </div>
                    <?php endif; ?>
                </div>

                <div class="pt-5 mt-5 border-top">

                    <div class="d-flex justify-content-between mb-4">
                        <h5><?php echo app('translator')->get('Ad Sechule'); ?></h5>
                        <button type="button" class="btn btn-outline--primary btn-sm scheduleBtn"><i class="la la-plus"> </i><?php echo app('translator')->get('Add'); ?></button>
                    </div>
                    
                    <div id="rowFields">

                        <?php if($ptc->schedule): ?>
                            <?php $__currentLoopData = $ptc->schedule; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $schedule): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="form-group">
                                    <div class="row gy-4">
                                        <div class="col-md-4">
                                            <select name="schedule[<?php echo e($key); ?>][day]" class="form-control" required>
                                                <option value="sunday" <?php if($schedule['day'] == 'sunday'): echo 'selected'; endif; ?>><?php echo app('translator')->get("Sunday"); ?></option>
                                                <option value="monday" <?php if($schedule['day'] == 'monday'): echo 'selected'; endif; ?>><?php echo app('translator')->get("Monday"); ?></option>
                                                <option value="tuesday" <?php if($schedule['day'] == 'tuesday'): echo 'selected'; endif; ?>><?php echo app('translator')->get("Tuesday"); ?></option>
                                                <option value="wednesday" <?php if($schedule['day'] == 'wednesday'): echo 'selected'; endif; ?>><?php echo app('translator')->get("Wednesday"); ?></option>
                                                <option value="thursday" <?php if($schedule['day'] == 'thursday'): echo 'selected'; endif; ?>><?php echo app('translator')->get("Thursday"); ?></option>
                                                <option value="friday" <?php if($schedule['day'] == 'friday'): echo 'selected'; endif; ?>><?php echo app('translator')->get("Friday"); ?></option>
                                                <option value="saturday" <?php if($schedule['day'] == 'saturday'): echo 'selected'; endif; ?>><?php echo app('translator')->get("Saturday"); ?></option>
                                            </select>
                                        </div>
                                        <div class="col-md-3">
                                            <input type="time" name="schedule[<?php echo e($key); ?>][start]" class="form-control" value="<?php echo e($schedule['start']); ?>" required>
                                        </div>
                                        <div class="col-md-3">
                                            <input type="time" name="schedule[<?php echo e($key); ?>][end]" class="form-control" value="<?php echo e($schedule['end']); ?>" required>
                                        </div>
                                        <div class="col-md-2">
                                            <button type="button" class="btn btn--danger w-100 h-45 scheduleClose"><i class="la la-times"></i></button>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                        
                    </div>

                </div>

                <div class="form-group col-md-12 mt-5">
                    <button type="submit" class="btn btn--primary h-45 w-100"><?php echo app('translator')->get('Submit'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
<a href="<?php echo e(route('admin.ptc.index')); ?>" class="btn btn-outline--primary btn-sm"><i class="las la-undo"></i> <?php echo app('translator')->get('Back'); ?> </a>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('script'); ?>
<script>
    (function($){
        "use strict";
        $('#ads_type').change(function(){
            var adType = $(this).val();
            if (adType == 1) {
                $("#websiteLink").removeClass('d-none');
                $("#bannerImage").addClass('d-none');
                $("#script").addClass('d-none');
                $("#youtube").addClass('d-none');
            } else if (adType == 2) {
                $("#bannerImage").removeClass('d-none');
                $("#websiteLink").addClass('d-none');
                $("#script").addClass('d-none');
                $("#youtube").addClass('d-none');
            } else if(adType == 3) {
                $("#bannerImage").addClass('d-none');
                $("#websiteLink").addClass('d-none');
                $("#script").removeClass('d-none');
                $("#youtube").addClass('d-none');
            } else {
                $("#bannerImage").addClass('d-none');
                $("#websiteLink").addClass('d-none');
                $("#script").addClass('d-none');
                $("#youtube").removeClass('d-none');
            }
        }).change();

        $('[name=status]').change(function(){
            var status = $(this).val();
            if( status == 3){
                $('#rejectReason').removeClass('d-none');
            } else {
                $('#rejectReason').addClass('d-none');
            }
        }).change();

        $('[name=status]').val('<?php echo e($ptc->status); ?>');

        var item = <?php echo e($ptc->schedule ? count($ptc->schedule) : 0); ?>;

        $('.scheduleBtn').on('click', function (){
            var html = `
                <div class="form-group">
                    <div class="row gy-4">
                        <div class="col-md-4">
                            <select name="schedule[${item}][day]" class="form-control" required>
                                <option value="sunday"><?php echo app('translator')->get("Sunday"); ?></option>
                                <option value="monday"><?php echo app('translator')->get("Monday"); ?></option>
                                <option value="tuesday"><?php echo app('translator')->get("Tuesday"); ?></option>
                                <option value="wednesday"><?php echo app('translator')->get("Wednesday"); ?></option>
                                <option value="thursday"><?php echo app('translator')->get("Thursday"); ?></option>
                                <option value="friday"><?php echo app('translator')->get("Friday"); ?></option>
                                <option value="saturday"><?php echo app('translator')->get("Saturday"); ?></option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <input type="time" name="schedule[${item}][start]" class="form-control" required>
                        </div>
                        <div class="col-md-3">
                            <input type="time" name="schedule[${item}][end]" class="form-control" required>
                        </div>
                        <div class="col-md-2">
                            <button type="button" class="btn btn--danger w-100 h-45 scheduleClose"><i class="la la-times"></i></button>
                        </div>
                    </div>
                </div>
            `;

            item += 1;

            $('#rowFields').append(html);
        });

        $(document).on('click', '.scheduleClose', function (){
            $(this).closest('.form-group').remove();            
        });

    })(jQuery);
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ecmrce/public_html/core/resources/views/admin/ptc/edit.blade.php ENDPATH**/ ?>