<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Dashboard - Dabdlab</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
   <style>
    :root {
      --primary: #4f308e;
      --secondary: #8f5fe8;
      --accent: #00c897;
      --dark: #1a1a2e;
      --light: #f8f9fa;
      --card-bg: #ffffff;
    }

    body {
      font-family: 'Poppins', sans-serif;
      background: linear-gradient(135deg, #f5f7fa 0%, #e4e8f0 100%);
      color: #1f2937;
    }

    .container {
      max-width: 480px;
      padding: 15px;
      padding-bottom: 20px;
    }

    /* Profile Card */
    .profile-card {
      background: linear-gradient(135deg, var(--primary), var(--secondary));
      border-radius: 12px;
      padding: 20px;
      color: white;
      display: flex;
      align-items: center;
      margin-bottom: 20px;
      box-shadow: 0 5px 15px rgba(79, 48, 142, 0.2);
    }

    .profile-pic {
      width: 60px;
      height: 60px;
      border-radius: 50%;
      overflow: hidden;
      background-color: #e0e0e0;
      display: flex;
      align-items: center;
      justify-content: center;
      margin-right: 15px;
      border: 3px solid rgba(255,255,255,0.3);
    }

    .profile-pic img {
      width: 100%;
      height: auto;
    }

    .profile-info {
      flex: 1;
    }

    .username {
      font-weight: 600;
      font-size: 1.1rem;
      margin-bottom: 5px;
    }

    .balance-btn {
      background: rgba(255,255,255,0.2);
      color: white;
      border: none;
      border-radius: 20px;
      padding: 6px 12px;
      font-size: 0.85rem;
      font-weight: 500;
      display: flex;
      align-items: center;
      transition: all 0.3s ease;
      cursor: pointer;
    }

    .balance-btn:hover {
      background: rgba(255,255,255,0.3);
      transform: translateY(-2px);
    }

    .logout-btn {
      background: transparent;
      border: none;
      color: white;
      font-size: 1.2rem;
      margin-left: 10px;
      transition: transform 0.3s ease;
    }

    .logout-btn:hover {
      transform: scale(1.1);
    }

    /* Notice Banner */
    .notice-banner {
      background: var(--card-bg);
      color: var(--primary);
      padding: 12px 15px;
      border-radius: 10px;
      margin-bottom: 20px;
      box-shadow: 0 3px 10px rgba(0,0,0,0.05);
      border-left: 4px solid var(--primary);
      display: flex;
      align-items: center;
    }

    .notice-icon {
      font-size: 1.2rem;
      margin-right: 10px;
      color: var(--primary);
    }

    /* Menu Section */
    .menu-section {
      background: var(--card-bg);
      border-radius: 12px;
      padding: 20px;
      margin-bottom: 20px;
      box-shadow: 0 5px 15px rgba(0,0,0,0.05);
    }

    .section-title {
      color: var(--primary);
      font-size: 1.2rem;
      font-weight: 600;
      margin-bottom: 20px;
      text-align: center;
      position: relative;
    }

    .section-title:after {
      content: "";
      display: block;
      width: 50px;
      height: 3px;
      background: var(--primary);
      margin: 8px auto 0;
      border-radius: 3px;
    }

    .menu-grid {
      display: grid;
      grid-template-columns: repeat(4, 1fr);
      gap: 15px;
    }

    .menu-item {
      text-align: center;
      text-decoration: none;
      transition: all 0.3s ease;
    }

    .menu-item:hover {
      transform: translateY(-5px);
    }

    .menu-icon {
      width: 50px;
      height: 50px;
      background: linear-gradient(135deg, var(--primary), var(--secondary));
      color: white;
      border-radius: 12px;
      display: flex;
      align-items: center;
      justify-content: center;
      margin: 0 auto 8px;
      font-size: 1.2rem;
      box-shadow: 0 4px 8px rgba(79, 48, 142, 0.2);
    }

    .menu-label {
      font-size: 0.75rem;
      font-weight: 500;
      color: #4b5563;
    }

    /* Slider */
    .slider {
      width: 100%;
      border-radius: 12px;
      overflow: hidden;
      margin-bottom: 20px;
      box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }

    .slider img {
      width: 100%;
      height: auto;
      display: block;
    }

    /* Support Section */
    .support-section {
      text-align: center;
      margin-top: 25px;
    }

    .support-btn {
      background: transparent;
      border: none;
      color: var(--primary);
      font-weight: 600;
      display: inline-flex;
      align-items: center;
      gap: 8px;
      cursor: pointer;
      transition: all 0.3s ease;
    }

    .support-btn:hover {
      color: var(--secondary);
      transform: translateY(-2px);
    }

    /* Bottom Sheet */
    .bottom-sheet {
      position: fixed;
      bottom: 0;
      left: 0;
      right: 0;
      background: white;
      border-radius: 20px 20px 0 0;
      padding: 20px;
      box-shadow: 0 -5px 20px rgba(0,0,0,0.1);
      transform: translateY(100%);
      transition: transform 0.3s ease;
      z-index: 1000;
      max-width: 480px;
      margin: 0 auto;
    }

    .bottom-sheet.open {
      transform: translateY(0);
    }

    .sheet-header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 20px;
      padding-bottom: 10px;
      border-bottom: 1px solid #e5e7eb;
    }

    .sheet-title {
      font-weight: 600;
      color: var(--primary);
    }

    .close-btn {
      background: none;
      border: none;
      font-size: 1.2rem;
      color: #6b7280;
    }

    .support-option {
      display: flex;
      align-items: center;
      padding: 12px 0;
      border-bottom: 1px solid #e5e7eb;
    }

    .support-option:last-child {
      border-bottom: none;
    }

    .option-icon {
      width: 40px;
      height: 40px;
      background: rgba(79, 48, 142, 0.1);
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      margin-right: 15px;
      color: var(--primary);
    }

    .option-text {
      flex: 1;
      text-align: left;
    }

    .option-title {
      font-weight: 500;
      margin-bottom: 2px;
    }

    .option-desc {
      font-size: 0.8rem;
      color: #6b7280;
    }

    .backdrop {
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: rgba(0,0,0,0.5);
      opacity: 0;
      pointer-events: none;
      transition: opacity 0.3s ease;
      z-index: 999;
    }

    .backdrop.active {
      opacity: 1;
      pointer-events: auto;
    }
  </style>
</head>
<body>
 <div class="container">
    <!-- Profile Card -->
    <div class="profile-card">
      <div class="profile-pic">
        <img src="https://kkkkkk.hatiya-panel.site/assets/images/logoIcon/logo.png" alt="Profile">
      </div>
      <div class="profile-info">
        <div class="username"><?php echo e(auth()->user()->username); ?></div>
        <button class="balance-btn" onclick="tapForBalance()">
          <i class="fas fa-wallet me-1"></i>
          <span id="bText">Tap To Balance</span>
          <span id="bNumber" class="d-none"><?php echo e(auth()->user()->balance); ?></span>
        </button>
      </div>
      <a href="/user/logout" class="logout-btn">
        <i class="fas fa-sign-out-alt"></i>
      </a>
    </div>

 
 <div class="notice-banner">
      <div class="notice-icon">
        <i class="fas fa-exclamation-circle"></i>
      </div>
      <marquee behavior="scroll" direction="left">ঈদের ধামাকা অফার দুই হাজার টাকার উপরে ডিপোজিট করলে এক্সটা ৩০ % বোনাস</marquee>
    </div>
    <!-- Ad Slider -->
    <div class="slider">
      <img src='https://newtask.delavalproduit.top/img/roki/20250531_073105.jpg' alt="Advertisement">
    </div>

    <!-- Main Menu -->
    <div class="menu-section">
      <h3 class="section-title">Main Menu</h3>
      <div class="menu-grid">
        <a href="/user/ptc" class="menu-item">
          <div class="menu-icon">
            <i class="fas fa-tasks"></i>
          </div>
          <div class="menu-label">Task</div>
        </a>
        
        <a href="/user/deposit" class="menu-item">
          <div class="menu-icon">
            <i class="fas fa-money-bill-wave"></i>
          </div>
          <div class="menu-label">Deposit</div>
        </a>
        
        <a href="/user/withdraw" class="menu-item">
          <div class="menu-icon">
            <i class="fas fa-wallet"></i>
          </div>
          <div class="menu-label">Withdraw</div>
        </a>
        
        <a href="/user/profile-setting" class="menu-item">
          <div class="menu-icon">
            <i class="fas fa-user"></i>
          </div>
          <div class="menu-label">Profile</div>
        </a>
        
        <a href="/user/plan/buy" class="menu-item">
          <div class="menu-icon">
            <i class="fas fa-credit-card"></i>
          </div>
          <div class="menu-label">Plan</div>
        </a>
        
        <a href="/user/referred-users" class="menu-item">
          <div class="menu-icon">
            <i class="fas fa-users"></i>
          </div>
          <div class="menu-label">Refer</div>
        </a>
        
        <a href="/user/deposit/history" class="menu-item">
          <div class="menu-icon">
            <i class="fa fa-credit-card"></i>
          </div>
          <div class="menu-label">Dp History</div>
        </a>
        
        <a href="/user/transactions" class="menu-item">
          <div class="menu-icon">
            <i class="fas fa-exchange-alt"></i>
          </div>
          <div class="menu-label">Transantions</div>
        </a>
      </div>
    </div>

    

    <!-- Partners Section -->
    <div class="menu-section">
      <h3 class="section-title">Our Partners</h3>
      <div class="menu-grid">
        <a href="/about.php" class="menu-item">
          <div class="menu-icon">
            <i class="fas fa-info-circle"></i>
          </div>
          <div class="menu-label">About</div>
        </a>
        
        <a href="#" class="menu-item">
          <div class="menu-icon">
            <i class="fas fa-tag"></i>
          </div>
          <div class="menu-label">AjkerDeal</div>
        </a>
        
        <a href="#" class="menu-item">
          <div class="menu-icon">
            <i class="fas fa-store"></i>
          </div>
          <div class="menu-label">Bikroy</div>
        </a>
        
        <a href="#" class="menu-item">
          <div class="menu-icon">
            <i class="fas fa-shopping-cart"></i>
          </div>
          <div class="menu-label">Othoba</div>
        </a>
      </div>
    </div>

    <!-- Support Button -->
    <div class="support-section">
      <button class="support-btn" onclick="toggleBottomSheet()">
        <i class="fas fa-headset"></i> Support Center
      </button>
    </div>
  </div>

  <!-- Bottom Sheet -->
  <div class="bottom-sheet" id="bottomSheet">
    <div class="sheet-header">
      <h4 class="sheet-title">Support Options</h4>
      <button class="close-btn" onclick="toggleBottomSheet()">
        <i class="fas fa-times"></i>
      </button>
    </div>
    
    <a href="" class="support-option">
      <div class="option-icon">
        <i class="fab fa-telegram"></i>
      </div>
      <div class="option-text">
        <div class="option-title">Telegram Channel</div>
        <div class="option-desc">Join our public channel</div>
      </div>
      <i class="fas fa-chevron-right text-muted"></i>
    </a>
    
    <a href="" class="support-option">
      <div class="option-icon">
        <i class="fas fa-comments"></i>
      </div>
      <div class="option-text">
        <div class="option-title">Telegram Group</div>
        <div class="option-desc">Chat with our community</div>
      </div>
      <i class="fas fa-chevron-right text-muted"></i>
    </a>
  </div>

  <!-- Backdrop -->
  <div class="backdrop" id="backdrop" onclick="toggleBottomSheet()"></div>

  <script>
    // Toggle balance display
    function tapForBalance() {
      const bText = document.getElementById('bText');
      const bNumber = document.getElementById('bNumber');
      
      bText.classList.add('d-none');
      bNumber.classList.remove('d-none');
      
      setTimeout(() => {
        bText.classList.remove('d-none');
        bNumber.classList.add('d-none');
      }, 1500);
    }

    // Toggle bottom sheet
    function toggleBottomSheet() {
      const sheet = document.getElementById('bottomSheet');
      const backdrop = document.getElementById('backdrop');
      
      sheet.classList.toggle('open');
      backdrop.classList.toggle('active');
    }
  </script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html><?php /**PATH /home/studentjobbd/kkkkkk.hatiya-panel.site/core/resources/views/templates/smartlab/user/dashboard.blade.php ENDPATH**/ ?>