
<?php $__env->startSection('panel'); ?>
<div class="row">
  <div class="col-md-12">
    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive--sm">
                <table class="table table--light style--two">
                    <thead>
                        <tr>
                            <th scope="col"><?php echo app('translator')->get('Name'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Status'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Action'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($type->name); ?></td>
                                <td><?php echo $type->statusBadge ?></td>
                                <td>
                                    <button class="btn btn-outline--primary btn-sm typeBtn" data-id="<?php echo e($type->id); ?>" data-name="<?php echo e($type->name); ?>" data-act="Edit Ptc Report Type">
                                        <i class="la la-pencil"></i> <?php echo app('translator')->get('Edit'); ?>
                                    </button>
                                    <?php if($type->status == Status::ENABLE): ?>
                                        <button class="btn btn-sm btn-outline--danger ms-1 confirmationBtn" data-question="<?php echo app('translator')->get('Are you sure to disable this type?'); ?>" data-action="<?php echo e(route('admin.ptcreport.type.status', $type->id)); ?>">
                                            <i class="la la-eye-slash"></i> <?php echo app('translator')->get('Disable'); ?>
                                        </button>
                                    <?php else: ?>
                                        <button class="btn btn-sm btn-outline--success ms-1 confirmationBtn" data-question="<?php echo app('translator')->get('Are you sure to enable this type?'); ?>" data-action="<?php echo e(route('admin.ptcreport.type.status', $type->id)); ?>">
                                            <i class="la la-eye"></i> <?php echo app('translator')->get('Enable'); ?>
                                        </button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php if($types->hasPages()): ?>
        <div class="card-footer">
            <?php echo e(paginateLinks($types)); ?>

        </div>
        <?php endif; ?>
    </div>
  </div>
</div>

<div class="modal fade" id="typeModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
            <h5 class="modal-title"><?php echo app('translator')->get('PTC Report Type'); ?></h5>
            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                <i class="las la-times"></i>
            </button>
            </div>
            <form action="<?php echo e(route('admin.ptcreport.type.save')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="name"><?php echo app('translator')->get('Name'); ?> </label>
                        <input type="text" class="form-control" name="name" placeholder="<?php echo app('translator')->get('Plan Name'); ?>" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--primary w-100 h-45"><?php echo app('translator')->get('Submit'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php if (isset($component)) { $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b = $component; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\ConfirmationModal::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b)): ?>
<?php $component = $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b; ?>
<?php unset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b); ?>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <button type="button" class="btn btn-outline--primary typeBtn" data-id="0" data-act="<?php echo app('translator')->get('Add PTC Report Type'); ?>"><i class="las la-plus"></i> <?php echo app('translator')->get('Add New'); ?></button>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($){
            "use strict";
            $('.typeBtn').on('click', function() {
                var modal = $('#typeModal');
                modal.find('.modal-title').text($(this).data('act'));
                modal.find('input[name=id]').val($(this).data('id'));
                modal.find('input[name=name]').val($(this).data('name'));
                if($(this).data('id') == 0){
                    modal.find('form')[0].reset();
                }
                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ecmrce/public_html/core/resources/views/admin/ptc/report/type.blade.php ENDPATH**/ ?>