
<?php $__env->startSection('panel'); ?>
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            /* আপনার নির্দেশিত কালার ভ্যারিয়েবল */
            --primary: #4f308e;
            --secondary: #8f5fe8;
            --dark: #1a1a2e;
            --light: #f8f9fa;
            --card-bg: #ffffff;
            --body-gradient-start: #f5f7fa;
            --body-gradient-end: #e4e8f0;
            --default-text: #1f2937;
            --menu-label: #4b5563;
            --muted-text: #6b7280;
            --profile-pic-bg: #e0e0e0;
            --border-color: #e5e7eb;
            --shadow-primary: rgba(79, 48, 142, 0.2);
            --icon-bg-tint: rgba(79, 48, 142, 0.1);
            --shadow-light: rgba(0, 0, 0, 0.05);
            --shadow-medium: rgba(0, 0, 0, 0.1);
            --bottomsheet-shadow: rgba(0, 0, 0, 0.1);
            --backdrop-overlay: rgba(0, 0, 0, 0.5);
            --balance-button-bg: rgba(255, 255, 255, 0.2);
            --balance-button-hover: rgba(255, 255, 255, 0.3);
        }

        body {
            background: linear-gradient(to bottom, var(--body-gradient-start), var(--body-gradient-end));
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
            color: var(--default-text);
        }

        .dashboard-header {
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            color: white;
            padding: 15px 25px;
            border-radius: 12px;
            font-size: 1.4rem;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 15px;
            margin-bottom: 25px;
            box-shadow: 0 4px 6px var(--shadow-primary);
            transition: all 0.3s ease;
            text-decoration: none;
        }

        .dashboard-header:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 12px var(--shadow-medium);
        }

        .dashboard-card {
            background-color: var(--card-bg);
            border-radius: 12px;
            padding: 20px;
            box-shadow: var(--shadow-light);
            transition: all 0.3s ease;
            height: 100%;
            position: relative;
            overflow: hidden;
            border: 1px solid var(--border-color);
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }

        /* সাইডে কালার শেড/গ্রেডিয়েন্ট */
        .dashboard-card::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            bottom: 0;
            width: 6px;
            background: linear-gradient(to bottom, var(--secondary), var(--primary));
            z-index: 1;
        }

        .dashboard-card:hover {
            transform: translateY(-5px);
            box-shadow: var(--shadow-medium);
        }

        .dashboard-card h2 {
            font-size: 1.2rem;
            font-weight: 600;
            margin-bottom: 10px;
            color: var(--default-text);
            padding-left: 10px;
        }

        .dashboard-card h5 {
            font-size: 1.1rem;
            font-weight: 700;
            color: var(--primary);
            margin-bottom: 15px;
            padding-left: 10px;
        }

        .btn-view-ad {
            background: var(--secondary);
            color: white;
            padding: 8px 20px;
            border-radius: 8px;
            font-size: 0.9rem;
            font-weight: 600;
            border: none;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            transition: all 0.3s ease;
            box-shadow: var(--shadow-light);
            width: calc(100% - 10px);
            margin-left: 10px;
        }

        .btn-view-ad:hover {
            background: var(--primary);
            transform: translateY(-2px);
            box-shadow: var(--shadow-medium);
        }

        .no-ads {
            text-align: center;
            padding: 30px;
            font-size: 1.1rem;
            font-weight: 500;
            color: var(--primary);
            background-color: var(--card-bg);
            border-radius: 12px;
            box-shadow: var(--shadow-light);
            border: 1px solid var(--border-color);
        }

        .no-ads i {
            font-size: 2rem;
            margin-bottom: 15px;
            color: var(--secondary);
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .dashboard-header {
                padding: 12px 20px;
                font-size: 1.2rem;
            }
            
            .dashboard-card {
                padding: 15px;
            }
            
            .btn-view-ad {
                padding: 6px 15px;
                font-size: 0.85rem;
            }
        }
    </style>
</head>
<div class="container py-4">
    <a href="/user/dashboard" class="dashboard-header">
        <i class="fas fa-arrow-left"></i>
        <span>Dashboard</span>
    </a>

    <?php $__empty_1 = true; $__currentLoopData = $ads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
             <div class="row g-4">
                    <div class="col-lg-4 col-md-6">
                <div class="dashboard-card">
                    <div>
                                <h2><?php echo e(__($ad->title)); ?></h2>
                                <h5><?php echo e($general->cur_sym); ?><?php echo e(showAmount($ad->amount)); ?></h5>
                                 </div>
                                <a href="<?php echo e(route('user.ptc.show',encrypt($ad->id.'|'.auth()->user()->id))); ?>" target="_blank" class="btn-view-ad">
                        <i class="fas fa-eye"></i>
                        View Ad                    </a>
                </div>
            </div></div>
            <br>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="card custom--card ptc-card">
            <div class="card-body">
                <h2 class="text-center text--base"><?php echo e(__($emptyMessage)); ?></h2>
            </div>
        </div>
    <?php endif; ?>

<?php $__env->stopSection(); ?>


<?php echo $__env->make($activeTemplate.'layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/studentjobbd/kkkkkk.hatiya-panel.site/core/resources/views/templates/smartlab/user/ptc/index.blade.php ENDPATH**/ ?>