<!doctype html>
<html>
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <script src="https://cdn.tailwindcss.com"></script>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Kanit:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
  <style>
  * {
    font-family: Kanit,cursive;
    -webkit-touch-callout: none;
    -webkit-user-select: none;
    -moz-user-select: none;
    user-select: none;
    box-sizing: border-box;
    padding: 0;
    margin: 0;
}
                #nprogress {
                    pointer-events: none;
                }

                #nprogress .bar {
                    background: #7d0984;
                    position: fixed;
                    z-index: 9999;
                    top: 0;
                    left: 0;
                    width: 100%;
                    height: 3px;
                }

                #nprogress .peg {
                    display: block;
                    position: absolute;
                    right: 0px;
                    width: 100px;
                    height: 100%;
                    box-shadow: 0 0 10px #7d0984, 0 0 5px #7d0984;
                    opacity: 1;
                    -webkit-transform: rotate(3deg) translate(0px, -4px);
                    -ms-transform: rotate(3deg) translate(0px, -4px);
                    transform: rotate(3deg) translate(0px, -4px);
                }

                #nprogress .spinner {
                    display: block;
                    position: fixed;
                    z-index: 1031;
                    top: 15px;
                    right: 15px;
                }

                #nprogress .spinner-icon {
                    width: 18px;
                    height: 18px;
                    box-sizing: border-box;
                    border: solid 2px transparent;
                    border-top-color: #7d0984;
                    border-left-color: #7d0984;
                    border-radius: 50%;
                    -webkit-animation: nprogresss-spinner 400ms linear infinite;
                    animation: nprogress-spinner 400ms linear infinite;
                }

                .nprogress-custom-parent {
                    overflow: hidden;
                    position: relative;
                }

                .nprogress-custom-parent #nprogress .spinner, .nprogress-custom-parent #nprogress .bar {
                    position: absolute;
                }

                @-webkit-keyframes nprogress-spinner {
                    0% {
                        -webkit-transform: rotate(0deg);
                    }

                    100% {
                        -webkit-transform: rotate(360deg);
                    }
                }

                @keyframes  nprogress-spinner {
                    0% {
                        transform: rotate(0deg);
                    }

                    100% {
                        transform: rotate(360deg);
                    }
                }
            </style>
</head>
<body>
  <main class="flex bg-white min-h-screen mb-10 min-w-screen flex-col justify-start items-baseline">
    
    <div class="bg-[#e2136e] w-full p-3 flex flex-col sm:flex-row items-center justify-between gap-3">

<div class="flex items-center gap-3 w-full sm:w-auto">

<form id="profile-form" action="https://taka5.com/user/profileupdate" method="POST" enctype="multipart/form-data" class="text-center">
    <input type="hidden" name="_token" value="W4CwhtR7KWBQZO4psUFUNKpP8YnW8ToUrsN0zKA1">    <input type="file" id="profile_image" name="profile_image" accept="image/png, image/jpeg, image/jpg" style="display: none;">
    

    <div id="avatarWrapper" class="inline-block cursor-pointer">
        <img src="/profile1.png" alt="avatar"
             id="avatarImage" class="inline-block object-cover object-center rounded-full w-24 h-24 border-2 border-white">
    </div>
    

    <button type="button" onclick="document.getElementById('profile_image').click();" class="bg-[#e2136e] p-2 text-white rounded-full mb-3 hidden">Upload Image</button>
</form>

<script type="text/javascript">

    document.getElementById('avatarWrapper').addEventListener('click', function() {
    document.getElementById('profile_image').click();
});

document.getElementById('profile_image').addEventListener('change', function(event) {
    const file = event.target.files[0];
    if (file) {
        const validTypes = ['image/png', 'image/jpeg', 'image/jpg'];
        if (!validTypes.includes(file.type)) {
            iziToast.error({
                message: "Invalid file type. Please select a PNG, JPEG, or JPG image.",
                position: "topRight"
            });
            return;
        }

 
        const reader = new FileReader();
        reader.onload = function(e) {
            document.getElementById('avatarImage').src = e.target.result;
        };
        reader.readAsDataURL(file);


        var formData = new FormData();
        formData.append('profile_image', file);
        formData.append('_token', "W4CwhtR7KWBQZO4psUFUNKpP8YnW8ToUrsN0zKA1");


        $.ajax({
            url: "https://taka5.com/user/profileupdate",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.imageUrl) {
               
                    document.getElementById('avatarImage').src = response.imageUrl;

                    iziToast.success({
                        message: "Profile image updated successfully!",
                        position: "topRight"
                    });

              
                    window.location.reload();
                }
            },
            error: function() {
                iziToast.error({
                    message: "Failed to update profile image.",
                    position: "topRight"
                });
            }
        });
    }
});

</script>

            <div class="flex-1 sm:flex sm:flex-col sm:items-start">
                <h2 class="text-white text-xl mb-1 whitespace-nowrap"><?php echo e($user->firstname); ?><?php echo e($user->lastname); ?></h2>
                <h2 class="text-white text-xl mb-1"><?php echo e(auth()->user()->mobile); ?></h2>
            </div>
        </div>

        <div class="w-full flex justify-center mt-2 sm:mt-0">
            <span id="toggleSpan" class="bg-[#fff] text-sm px-2 py-1 text-[#444] rounded-full cursor-pointer flex items-center gap-1">
                <img src="https://taka5.com/assets/icon/tap.jpg" alt="" class="h-4 w-4 rounded-full">
                <span id="textContent">Tap for Balance</span>
            </span>
        </div>
</div><a href="https://taka5.com/user/logout" class="rounded-full bg-white absolute top-3 right-3 p-2"><svg xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 24 24" fill="currentColor" aria-hidden="true"
            class="h-6 font-bold cursor-pointer w-6 text-black">
            <path fill-rule="evenodd"
                d="M7.5 3.75A1.5 1.5 0 006 5.25v13.5a1.5 1.5 0 001.5 1.5h6a1.5 1.5 0 001.5-1.5V15a.75.75 0 011.5 0v3.75a3 3 0 01-3 3h-6a3 3 0 01-3-3V5.25a3 3 0 013-3h6a3 3 0 013 3V9A.75.75 0 0115 9V5.25a1.5 1.5 0 00-1.5-1.5h-6zm10.72 4.72a.75.75 0 011.06 0l3 3a.75.75 0 010 1.06l-3 3a.75.75 0 11-1.06-1.06l1.72-1.72H9a.75.75 0 010-1.5h10.94l-1.72-1.72a.75.75 0 010-1.06z"
                clip-rule="evenodd"></path>
        </svg></a>
        <div class="notification-icon" id="notificationIcon">
            <i class="fa fa-bell"></i>
            <span class="badge">1</span>
        </div>

    </div>

    <style>
        .notification-icon {
            position: relative;
            font-size: 24px;
            color: #fff;
            cursor: pointer;
            margin-left: auto; 
            margin-top: 20px; 
        }

        .notification-icon .badge {
            position: absolute;
            top: 5px; 
            right: -5px;
            background-color: red;
            color: white;
            border-radius: 50%;
            padding: 4px 6px;
            font-size: 12px;
        }

        @media (max-width: 576px) {
            .notification-icon {
                position: absolute; 
                top: 10px; 
                right: 20px; 
                margin-top: 0; 
                font-size: 20px; 
            }

            .bg-[#e2136e] {
                padding-top: 20px; 
            }
        }

        .custom-popup {
            border-radius: 10px; 
            background: #f0f8ff; 
            padding: 20px; 
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3); 
        }

        .swal2-title {
            color: #e2136e; 
            font-size: 1.5em;
        }

        .swal2-html {
            color: #333;
        }
    </style>

    
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    function nl2br(str) {
        return str.replace(/\n/g, '<br>');
    }

    document.getElementById('notificationIcon').addEventListener('click', function() {
        const notice = `“taka5.com"<div class="explain">                             <p>1. প্রথমবার ২০০০০</p>                             <p>2. Please initiate each deposit through this page and do not save account transfers.</p>                             <p>3. Single deposit amount between 2,000 naira and 10,000,000 naira.</p>                             <p>4. Deposit initiated for more than 5 minutes but not received, please submit the issue of                                 deposit not received through the help center self-service</p>                             <p>5. Due to the platform's popularity, deposit initiation failed. Please try multiple times</p>                             <p>6. After the transfer is successful, please make sure to fill in the Sender's name or Session                                 ID correctly</p>                         </div>”`;
        const formattedNotice = nl2br(notice);

        Swal.fire({
            html: `<p style="margin: 0; line-height: 1.5;">${formattedNotice}</p>`, 
            icon: 'info',
            confirmButtonText: 'Close',
            customClass: {
                popup: 'custom-popup' 
            }
        });
    });
</script>
<div class="p-3 pt-1 w-full ">
             <div class="mySlides mb-1">
                 <img alt="" style="border: 2px solid #7614ff;border-radius: 15px;" width="500" height="500" class="w-full lg:h-[80vh] rounded" src="/bdt.png">
             </div>
             <div class="mySlides mb-1">
                 <img alt="" style="border: 2px solid #7614ff;border-radius: 15px;" width="500" height="500" class="w-full lg:h-[80vh] rounded" src="/bdt.png">
             </div>
                            
             <div class="mySlides mb-1">
                 <img alt="" style="border: 2px solid #7614ff;border-radius: 15px;" width="500" height="500" class="w-full lg:h-[80vh] rounded" src="/bdt.png">
             </div>
             <div class="mySlides mb-1">
                 <img alt="" style="border: 2px solid #7614ff;border-radius: 15px;" width="500" height="500" class="w-full lg:h-[80vh] rounded" src="/bdt.png">
             </div>
    </div>
                
            
</div>



        
<div class="marquee_notice" style="background: #e2136e; color: #fff; padding: 5px 0; border-radius: 10px; display: flex; align-items: center;">
    <i class="fas fa-volume-up" style="margin-right: 10px;"></i>
    <marquee>
        
                    পবিত্র ঈদের শুভেচ্ছা জানাই TAKA5.COM এর পক্ষ থেকে । আমাদের সাইটে আপনারা ডিপোজিট করলেই পাচ্ছেন ঈদের স্পেশাল বোনাস তাই দেরি না করে এখনি উপভোগ করুন আনলিমিটেড বোনাস।
            </marquee>
</div>
     </div>
       </div><a href="https://taka5.com/user/logout" class="rounded-full bg-white absolute top-3 right-3 p-2"><svg xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 24 24" fill="currentColor" aria-hidden="true"
            class="h-6 font-bold cursor-pointer w-6 text-black">
            <path fill-rule="evenodd"
                d="M7.5 3.75A1.5 1.5 0 006 5.25v13.5a1.5 1.5 0 001.5 1.5h6a1.5 1.5 0 001.5-1.5V15a.75.75 0 011.5 0v3.75a3 3 0 01-3 3h-6a3 3 0 01-3-3V5.25a3 3 0 013-3h6a3 3 0 013 3V9A.75.75 0 0115 9V5.25a1.5 1.5 0 00-1.5-1.5h-6zm10.72 4.72a.75.75 0 011.06 0l3 3a.75.75 0 010 1.06l-3 3a.75.75 0 11-1.06-1.06l1.72-1.72H9a.75.75 0 010-1.5h10.94l-1.72-1.72a.75.75 0 010-1.06z"
                clip-rule="evenodd"></path>
        </svg></a>
                
    <div class="p-5 w-full ">
        <div class=" ">
            <hr class="">
            
            <div class="">
            <div class="grid  grid-cols-4 gap-2 rounded-lg my-2">
                <a href="https://taka5.com/user/deposit">
                    <div class="cursor-pointer flex items-center flex-col" style="border: 3px solid #e2136e;padding: 8px;border-radius: 10px;">
                        <img width="1000" height="1000" class="h-18 cursor-pointer w-18 img-fluid" src="/deposit.png" >
                        <h2 class=" text-black mt-2 text-center">Deposit</h2>
                    </div>
                </a>


                <a href="https://taka5.com/user/withdraw">
                    <div class="cursor-pointer flex items-center flex-col" style="border: 3px solid #e2136e;padding: 8px;border-radius: 10px;">
                        <img width="1000" height="1000" class="h-18 cursor-pointer w-18 img-fluid" src="/withdraw.png" >
                        <h2 class=" text-black mt-2 text-center">Withdraw</h2>
                    </div>
                </a>
                <a href="/plans">
                    <div class="cursor-pointer flex items-center flex-col" style="border: 3px solid #e2136e;padding: 8px;border-radius: 10px;">
                        <img width="1000" height="1000" class="h-18 cursor-pointer w-18 img-fluid" src="/plan.png" >
                        <h2 class=" text-black mt-2 text-center">Plan</h2>
                    </div>
                </a>
                <a href="/user/ptc">
                    <div class="cursor-pointer flex items-center flex-col" style="border: 3px solid #e2136e;padding: 8px;border-radius: 10px;">
                        <img width="1000" height="1000" class="h-18 cursor-pointer w-18 img-fluid" src="/task.png">
                        <h2 class=" text-black mt-2 text-center">Task</h2>
                    </div>
                </a>
                <a href="/user/profile-setting">
                    <div class="cursor-pointer flex items-center flex-col" style="border: 3px solid #e2136e;padding: 8px;border-radius: 10px;">
                        <img width="1000" height="1000" class="h-18 cursor-pointer w-18 img-fluid" src="/profile.png" >
                        <h2 class=" text-black mt-2 text-center">Profile</h2>
                    </div>
                </a>
                <a href="/user/transactions">
                    <div class="cursor-pointer flex items-center flex-col" style="border: 3px solid #e2136e;padding: 8px;border-radius: 10px;">
                        <img width="1000" height="1000" class="h-18 cursor-pointer w-18 img-fluid" src="/transaction.png" >
                        <h2 class=" text-black mt-2 text-center">Transac</h2>
                    </div>
                </a>
                <a href="https://taka5.com/user/referred-users">
                    <div class="cursor-pointer flex items-center flex-col" style="border: 3px solid #e2136e;padding: 8px;border-radius: 10px;">
                        <img width="1000" height="1000" class="h-18 cursor-pointer w-18 img-fluid" src="/refer.png" >
                        <h2 class=" text-black mt-2 text-center">Refer</h2>
                    </div>
                </a>

                <a href="https://t.me/taka5_official">
                    <div class="cursor-pointer flex items-center flex-col" style="border: 3px solid #e2136e;padding: 8px;border-radius: 10px;">
                        <img width="1000" height="1000" class="h-18 cursor-pointer w-18 img-fluid" src="/thelp1.png" >
                        <h2 class=" text-black mt-2 text-center">Helpline</h2>
                    </div>
                </a>
                </div>
        </div>
        
        
        <a class="px-1 py-0" target="blank" href="https://apk.e-droid.net/apk/app3514296-gi39kl.apk?v=1">
                    <div class="cursor-pointer flex items-center flex-col" style="border:3px solid #7614ff;padding:10px 0px;border-radius:10px;">
                        <img alt="" width="500" height="500" class="w-full lg:h-[80vh]" src="/app.png">
                    </div>
                </a>

        </div>
        
        
        

        </div>
        
        


            </div>
</div>
    
    
</main>

  
<script src="<?php echo e(asset('assets/front/js/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/front/js/popper.min.js')); ?>"></script>
     
<link rel="stylesheet" href="<?php echo e(asset('assets/front/css/iziToast.min.css')); ?>">
<script src="<?php echo e(asset('assets/front/js/iziToast.min.js')); ?>"></script>

<script type="text/javascript">
    (function($,document){
        "use strict";
                        function notify(status,message) {
            iziToast[status]({
                message: message,
                position: "topRight"
            });
        }
    })(jQuery);
</script>

  
<script>
document.addEventListener("DOMContentLoaded", function() {
    // Get the span element
    var spanElement = document.getElementById("toggleSpan");
    // Get the span containing the text content
    var textContentSpan = document.getElementById("textContent");

    spanElement.addEventListener("click", function() {
        if (textContentSpan.textContent.trim() === "Tap for Balance") {
            textContentSpan.textContent = <?php echo e(auth()->user()->balance); ?>;
            // Automatically revert after 5 seconds
            setTimeout(function() {
                textContentSpan.textContent = "Tap for Balance";
            }, 5000); // 5000 milliseconds = 5 seconds
        } else {
            textContentSpan.textContent = "Tap for Balance";
        }
    });
});
</script>


<script>
    // Get the modal
var modal = document.getElementById("myModal");

// Get the button that opens the modal
var btn = document.getElementById("myBtn");

// Get the <span> element that closes the modal
var span = document.getElementsByClassName("close")[0];

// When the user clicks the button, open the modal 
btn.onclick = function() {
  modal.style.display = "block";
}

// When the user clicks on <span> (x), close the modal
span.onclick = function() {
  modal.style.display = "none";
}

// When the user clicks anywhere outside of the modal, close it
window.onclick = function(event) {
  if (event.target == modal) {
    modal.style.display = "none";
  }
}

</script>
<script>
let slideIndex = 0;
showSlides();

function showSlides() {
  let i;
  let slides = document.getElementsByClassName("mySlides");
  for (i = 0; i < slides.length; i++) {
    slides[i].style.display = "none";
  }
  slideIndex++;
  if (slideIndex > slides.length) {slideIndex = 1}
  slides[slideIndex-1].style.display = "block";
  setTimeout(showSlides, 2000); // Change image every 2 seconds
}

</script>
</body>
</html><?php /**PATH /home/takacom2/public_html/core/resources/views/templates/smartlab/user/dashboard.blade.php ENDPATH**/ ?>