
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=ice-width, initial-scale=1.0">
  <title>Dabdlab  - Earn Online</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <style>
    :root {
      /* Primary Colors */
      --primary: #4f308e;          /* গাঢ় বেগুনি (প্রধান থিম) */
      --secondary: #8f5fe8;        /* হালকা বেগুনি */
      --accent: #00c897;           /* অ্যাকসেন্ট – সবুজাভ */
      
      /* Background & Surface Colors */
      --dark: #1a1a2e;            /* গাঢ় ব্যাকগ্রাউন্ড */
      --light: #f8f9fa;           /* হালকা সাদা/ছাই */
      --card-bg: #ffffff;         /* সাদা কার্ড ব্যাকগ্রাউন্ড */
      
      /* Gradient Background */
      --body-gradient-start: #f5f7fa;
      --body-gradient-end: #e4e8f0;
      
      /* Text Colors */
      --default-text: #1f2937;    /* সাধারণ টেক্সট রঙ */
      --menu-label: #4b5563;      /* টেক্সট/লেবেল (গাঢ় ধূসর) */
      --muted-text: #6b7280;      /* হালকা টেক্সট/বর্ণ */
      
      /* UI Elements */
      --profile-pic-bg: #e0e0e0;  /* প্রোফাইল ছবির ব্যাকগ্রাউন্ড */
      --border-color: #e5e7eb;    /* হালকা বর্ডার কালার */
      
      /* Shadows & Effects */
      --shadow-primary: rgba(79, 48, 142, 0.2);   /* বেগুনি শ্যাডো */
      --icon-bg-tint: rgba(79, 48, 142, 0.1);     /* হালকা বেগুনি ব্যাকগ্রাউন্ড */
      --shadow-light: rgba(0, 0, 0, 0.05);        /* হালকা কালো শ্যাডো */
      --shadow-medium: rgba(0, 0, 0, 0.1);        /* মিডিয়াম শ্যাডো */
      --bottomsheet-shadow: rgba(0, 0, 0, 0.1);   /* নিচের দিকের শ্যাডো */
      --backdrop-overlay: rgba(0, 0, 0, 0.5);     /* ব্যাকড্রপ ওভারলে */
      
      /* Buttons */
      --balance-button-bg: rgba(255, 255, 255, 0.2);
      --balance-button-hover: rgba(255, 255, 255, 0.3);
    }
    
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }
    
    body {
      font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
      line-height: 1.5;
      color: var(--default-text);
      background: linear-gradient(to bottom, var(--body-gradient-start), var(--body-gradient-end));
    }
    
    /* Modern Header */
    .hero {
      background: linear-gradient(135deg, var(--primary) 0%, #3a1d6e 100%);
      color: white;
      padding: 2.5rem 1.5rem;
      text-align: center;
      border-radius: 0 0 30px 30px;
      position: relative;
      overflow: hidden;
    }
    
    .hero::after {
      content: "";
      position: absolute;
      bottom: -50px;
      right: -50px;
      width: 150px;
      height: 150px;
      background: var(--balance-button-bg);
      border-radius: 50%;
    }
    
    .hero::before {
      content: "";
      position: absolute;
      top: -50px;
      left: -50px;
      width: 200px;
      height: 200px;
      background: var(--icon-bg-tint);
      border-radius: 50%;
    }
    
    .logo {
      width: 70px;
      margin-bottom: 1rem;
      filter: drop-shadow(0 2px 4px var(--shadow-primary));
    }
    
    .hero-title {
      font-size: 2rem;
      font-weight: 800;
      margin-bottom: 0.5rem;
      line-height: 1.2;
    }
    
    .hero-subtitle {
      font-size: 1rem;
      opacity: 0.9;
      max-width: 400px;
      margin: 0 auto 1.5rem;
    }
    
    /* Button Styles */
    .btn-group {
      display: flex;
      gap: 0.8rem;
      justify-content: center;
      margin-top: 1.5rem;
    }
    
    .btn {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      padding: 0.8rem 1.5rem;
      border-radius: 50px;
      font-weight: 600;
      text-decoration: none;
      transition: all 0.2s ease;
      border: none;
      font-size: 0.95rem;
    }
    
    .btn-primary {
      background-color: white;
      color: var(--primary);
      box-shadow: 0 4px 12px var(--shadow-primary);
    }
    
    .btn-primary:hover {
      transform: translateY(-2px);
      box-shadow: 0 6px 16px rgba(79, 48, 142, 0.4);
    }
    
    .btn-outline {
      background: transparent;
      color: white;
      border: 2px solid rgba(255,255,255,0.3);
    }
    
    .btn-outline:hover {
      background: var(--balance-button-hover);
      border-color: rgba(255,255,255,0.5);
    }
    
    /* Stats Section */
    .stats {
      display: grid;
      grid-template-columns: repeat(2, 1fr);
      gap: 1rem;
      margin: 0 1.5rem 2rem;
    }
    
    .stat-card {
      background: var(--card-bg);
      border-radius: 12px;
      padding: 1.2rem;
      text-align: center;
      box-shadow: 0 4px 6px var(--shadow-light);
      border: 1px solid var(--border-color);
    }
    
    .stat-number {
      font-size: 1.8rem;
      font-weight: 700;
      color: var(--primary);
      margin-bottom: 0.2rem;
    }
    
    .stat-label {
      font-size: 0.75rem;
      color: var(--menu-label);
      font-weight: 500;
    }
    
    /* Content Sections */
    .section {
      padding: 2rem 1.5rem;
    }
    
    .section-title {
      font-size: 1.5rem;
      font-weight: 700;
      color: var(--dark);
      margin-bottom: 1.2rem;
      text-align: center;
    }
    
    .feature-card {
      background: var(--card-bg);
      border-radius: 14px;
      padding: 1.5rem;
      margin-bottom: 1rem;
      box-shadow: 0 4px 6px var(--shadow-light);
      border: 1px solid var(--border-color);
    }
    
    .feature-icon {
      width: 50px;
      height: 50px;
      background: linear-gradient(45deg, var(--primary), var(--secondary));
      border-radius: 12px;
      display: flex;
      align-items: center;
      justify-content: center;
      margin-bottom: 1rem;
      color: white;
      font-size: 1.2rem;
    }
    
    .feature-title {
      font-size: 1.1rem;
      font-weight: 600;
      margin-bottom: 0.5rem;
      color: var(--dark);
    }
    
    /* Testimonial */
    .testimonial {
      background: linear-gradient(135deg, var(--dark), #0f172a);
      color: white;
      border-radius: 16px;
      padding: 1.8rem;
      margin: 1.5rem 0;
      position: relative;
      overflow: hidden;
    }
    
    .testimonial::before {
      content: """;
      position: absolute;
      top: 10px;
      left: 15px;
      font-size: 5rem;
      color: rgba(255,255,255,0.05);
      font-family: serif;
      line-height: 1;
    }
    
    .testimonial-text {
      position: relative;
      z-index: 1;
      font-style: italic;
      margin-bottom: 1rem;
    }
    
    .testimonial-author {
      font-weight: 600;
      opacity: 0.9;
    }
    
    /* Rating */
    .rating {
      display: inline-flex;
      align-items: center;
      background: rgba(255,255,255,0.9);
      padding: 0.5rem 1rem;
      border-radius: 50px;
      margin-top: 1rem;
      box-shadow: 0 2px 8px var(--shadow-light);
    }
    
    .stars {
      color: var(--accent);
      margin-right: 0.5rem;
    }
    
    .rating-text {
      font-size: 0.85rem;
      font-weight: 500;
      color: #000;
    }
    
    /* Footer */
    .footer {
      background: var(--light);
      padding: 2rem 1.5rem;
      text-align: center;
      border-top: 1px solid var(--border-color);
    }
    
    .footer-logo {
      width: 60px;
      margin-bottom: 1rem;
      opacity: 0.8;
    }
    
    .footer-text {
      font-size: 0.9rem;
      color: var(--menu-label);
      margin-bottom: 1.5rem;
      max-width: 400px;
      margin-left: auto;
      margin-right: auto;
    }
    
    .social-links {
      display: flex;
      justify-content: center;
      gap: 1rem;
      margin-bottom: 1.5rem;
    }
    
    .social-link {
      width: 40px;
      height: 40px;
      border-radius: 50%;
      background: var(--profile-pic-bg);
      display: flex;
      align-items: center;
      justify-content: center;
      color: var(--menu-label);
      transition: all 0.2s ease;
    }
    
    .social-link:hover {
      background: var(--primary);
      color: white;
    }
    
    .copyright {
      font-size: 0.75rem;
      color: var(--muted-text);
    }
    
    /* Highlight Text */
    .highlight {
      color: var(--accent);
      font-weight: 600;
    }
    
    /* Responsive Adjustments */
    @media (min-width: 768px) {
      .hero-title {
        font-size: 2.5rem;
      }
      
      .stats {
        grid-template-columns: repeat(4, 1fr);
        margin: -2rem 2rem 3rem;
      }
      
      .features {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 1rem;
      }
    }
  </style>
</head>
<body>
  <!-- Hero Section -->
  <section class="hero">
    <img src="https://kkkkkk.hatiya-panel.site/assets/images/logoIcon/logo.png" alt="Dabdlab " class="logo">
    <h1 class="hero-title">Earn Money <span class="highlight">Online</span> With Us</h1>
    <p class="hero-subtitle">Join thousands who are already earning through our innovative platform</p>
    
    <div class="btn-group">
      <a href="/user/register" class="btn btn-primary">
        <i class="fas fa-user-plus" style="margin-right: 8px;"></i> Register
      </a>
      <a href="/user/login" class="btn btn-outline">
        <i class="fas fa-sign-in-alt" style="margin-right: 8px;"></i> Login
      </a>
    </div>
    
    <div class="rating">
      <div class="stars">★★★★☆</div>
      <div class="rating-text">4.5/5 from 155+ reviews</div>
    </div>
  </section>

  <!-- Stats Section -->
  <div class="stats">
    <div class="stat-card">
      <div class="stat-number">10K+</div>
      <div class="stat-label">Active Members</div>
    </div>
    <div class="stat-card">
      <div class="stat-number">$500K+</div>
      <div class="stat-label">Paid Out</div>
    </div>
    <div class="stat-card">
      <div class="stat-number">300+</div>
      <div class="stat-label">Daily Signups</div>
    </div>
    <div class="stat-card">
      <div class="stat-number">24/7</div>
      <div class="stat-label">Support</div>
    </div>
  </div>

  <!-- Features Section -->
  <section class="section">
    <h2 class="section-title">Why Choose Dabdlab ?</h2>
    
    <div class="feature-card">
      <div class="feature-icon">
        <i class="fas fa-bolt"></i>
      </div>
      <h3 class="feature-title">Fast Earnings</h3>
      <p>Start earning from day one with our simple and effective system designed for quick results.</p>
    </div>
    
    <div class="feature-card">
      <div class="feature-icon">
        <i class="fas fa-shield-alt"></i>
      </div>
      <h3 class="feature-title">Secure Platform</h3>
      <p>Your data and earnings are protected with bank-level security measures.</p>
    </div>
    
    <div class="feature-card">
      <div class="feature-icon">
        <i class="fas fa-hand-holding-usd"></i>
      </div>
      <h3 class="feature-title">Multiple Withdrawals</h3>
      <p>Withdraw your earnings anytime through various payment methods.</p>
    </div>
  </section>

  <!-- Testimonial Section -->
  <section class="section">
    <h2 class="section-title">What Our Members Say</h2>
    
    <div class="testimonial">
      <p class="testimonial-text">"অনেক ভালো একটা প্ল্যাটফর্ম। অনেক কম সময়ের মাধ্যমে অনেক ভালো ফলাফল পাওয়া যায় এখান থেকে। আপনারা চাইলে এখান থেকে কাজ করতে পারেন।"</p>
      <div class="testimonial-author">— Mannan Vuiya, Dabdlab  Member</div>
    </div>
  </section>

  <!-- CTA Section -->
  <section class="section">
    <h2 class="section-title">Ready to Get Started?</h2>
    <p style="text-align: center; margin-bottom: 1.5rem;">Join today and get <span class="highlight">bonus earnings</span> on your first week!</p>
    
    <div class="btn-group">
      <a href="https://newtask.delavalproduit.top/user/register" class="btn btn-primary" style="padding: 1rem 2rem;">
        <i class="fas fa-user-plus" style="margin-right: 8px;"></i> Sign Up Free
      </a>
    </div>
  </section>

  <!-- Footer -->
  <footer class="footer">
    <img src="/img/roki/smart.jpg" alt="Dabdlab " class="footer-logo">
    <p class="footer-text">Dabdlab  helps you earn money through innovative online opportunities with complete transparency.</p>
    
    <div class="social-links">
      <a href="" class="social-link"><i class="fab fa-facebook-f"></i></a>
      <a href="" class="social-link"><i class="fab fa-twitter"></i></a>
      <a href="" class="social-link"><i class="fab fa-instagram"></i></a>
      <a href="" class="social-link"><i class="fab fa-youtube"></i></a>
    </div>
    
    <p class="copyright">© 2025 Dabdlab. All rights reserved.</p>
  </footer>
</body>
</html><?php /**PATH /home/ecmrce/public_html/core/resources/views/templates/smartlab/home.blade.php ENDPATH**/ ?>