
<?php $__env->startSection('panel'); ?>
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <script src="https://cdn.tailwindcss.com"></script>
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Kanit:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
        <style>
            * {
                font-family: Kanit,cursive;
                -webkit-touch-callout: none;
                -webkit-user-select: none;
                -moz-user-select: none;
                user-select: none;
                box-sizing: border-box;
                padding: 0;
                margin: 0;
            }

            #nprogress {
                pointer-events: none;
            }

            #nprogress .bar {
                background: #B72B41;
                position: fixed;
                z-index: 9999;
                top: 0;
                left: 0;
                width: 100%;
                height: 3px;
            }

            #nprogress .peg {
                display: block;
                position: absolute;
                right: 0px;
                width: 100px;
                height: 100%;
                box-shadow: 0 0 10px #B72B41, 0 0 5px #B72B41;
                opacity: 1;
                -webkit-transform: rotate(3deg) translate(0px, -4px);
                -ms-transform: rotate(3deg) translate(0px, -4px);
                transform: rotate(3deg) translate(0px, -4px);
            }

            #nprogress .spinner {
                display: block;
                position: fixed;
                z-index: 1031;
                top: 15px;
                right: 15px;
            }

            #nprogress .spinner-icon {
                width: 18px;
                height: 18px;
                box-sizing: border-box;
                border: solid 2px transparent;
                border-top-color: #B72B41;
                border-left-color: #B72B41;
                border-radius: 50%;
                -webkit-animation: nprogresss-spinner 400ms linear infinite;
                animation: nprogress-spinner 400ms linear infinite;
            }

            .nprogress-custom-parent {
                overflow: hidden;
                position: relative;
            }

            .nprogress-custom-parent #nprogress .spinner, .nprogress-custom-parent #nprogress .bar {
                position: absolute;
            }

            @-webkit-keyframes nprogress-spinner {
                0% {
                    -webkit-transform: rotate(0deg);
                }

                100% {
                    -webkit-transform: rotate(360deg);
                }
            }

            @keyframes nprogress-spinner {
                0% {
                    transform: rotate(0deg);
                }

                100% {
                    transform: rotate(360deg);
                }
            }
        </style>
    </head>
    <body>
        <div class="min-h-screen bg-[#ebebeb] pb-10">
            <a href="<?php echo e(route('user.home')); ?>" class="h-14 w-full bg-[#4f308e] pl-4  gap-5 shadow text-white flex items-center ">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true" class="h-7 font-bold cursor-pointer w-7">
                    <path fill-rule="evenodd" d="M7.72 12.53a.75.75 0 010-1.06l7.5-7.5a.75.75 0 111.06 1.06L9.31 12l6.97 6.97a.75.75 0 11-1.06 1.06l-7.5-7.5z" clip-rule="evenodd"></path>
                </svg>
                <h2 class="text-xl font-bold text-white">Packages</h2>
            </a>
    <div class="grid grid-cols-2 gap-2 p-2">
        <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class=" p-2 relative bg-white overflow-hidden border border-gray-300 rounded-lg">
            <div class=" bg-white">
                <h2 class="text-xl text-center font-bold whitespace-nowrap"><?php echo e($plan->name); ?></h2>
                <p
                    class="w-7 text-black h-7 bg-none flex justify-center items-center rounded-full absolute top-0 right-0">
                    3x</p>
                <h2 class="text-lg text-center font-bold whitespace-nowrap"><?php echo e(__(showAmount($plan->price))); ?></h2>
                <hr class="my-2">
                <div class="text-sm text-gray-700">
                    <p class="flex gap-2 items-center"><svg stroke="currentColor" fill="currentColor" stroke-width="0"
                            version="1" viewBox="0 0 48 48" enable-background="new 0 0 48 48" height="1em"
                            width="1em" xmlns="http://www.w3.org/2000/svg">
                            <polygon fill="#4f308e"
                                points="24,3 28.7,6.6 34.5,5.8 36.7,11.3 42.2,13.5 41.4,19.3 45,24 41.4,28.7 42.2,34.5 36.7,36.7 34.5,42.2 28.7,41.4 24,45 19.3,41.4 13.5,42.2 11.3,36.7 5.8,34.5 6.6,28.7 3,24 6.6,19.3 5.8,13.5 11.3,11.3 13.5,5.8 19.3,6.6">
                            </polygon>
                            <polygon fill="#CCFF90" points="34.6,14.6 21,28.2 15.4,22.6 12.6,25.4 21,33.8 37.4,17.4">
                            </polygon>
                        </svg> Daily <?php echo e($plan->daily_limit); ?> Ads </p>
                    
                    <p class="flex gap-2 items-center"><svg stroke="currentColor" fill="currentColor" stroke-width="0"
                            version="1" viewBox="0 0 48 48" enable-background="new 0 0 48 48" height="1em"
                            width="1em" xmlns="http://www.w3.org/2000/svg">
                            <polygon fill="#4f308e"
                                points="24,3 28.7,6.6 34.5,5.8 36.7,11.3 42.2,13.5 41.4,19.3 45,24 41.4,28.7 42.2,34.5 36.7,36.7 34.5,42.2 28.7,41.4 24,45 19.3,41.4 13.5,42.2 11.3,36.7 5.8,34.5 6.6,28.7 3,24 6.6,19.3 5.8,13.5 11.3,11.3 13.5,5.8 19.3,6.6">
                            </polygon>
                            <polygon fill="#CCFF90" points="34.6,14.6 21,28.2 15.4,22.6 12.6,25.4 21,33.8 37.4,17.4">
                            </polygon>
                        </svg> Validity <?php echo e($plan->validity); ?> days </p>
    
                        <p class="flex gap-2 items-center"><svg stroke="currentColor" fill="currentColor" stroke-width="0"
                            version="1" viewBox="0 0 48 48" enable-background="new 0 0 48 48" height="1em"
                            width="1em" xmlns="http://www.w3.org/2000/svg">
                            <polygon fill="#4f308e"
                                points="24,3 28.7,6.6 34.5,5.8 36.7,11.3 42.2,13.5 41.4,19.3 45,24 41.4,28.7 42.2,34.5 36.7,36.7 34.5,42.2 28.7,41.4 24,45 19.3,41.4 13.5,42.2 11.3,36.7 5.8,34.5 6.6,28.7 3,24 6.6,19.3 5.8,13.5 11.3,11.3 13.5,5.8 19.3,6.6">
                            </polygon>
                            <polygon fill="#CCFF90" points="34.6,14.6 21,28.2 15.4,22.6 12.6,25.4 21,33.8 37.4,17.4">
                            </polygon>
                        </svg> Refer Level <?php echo e($plan->ref_level); ?>  </p>
                </div>
    
                <?php if(@auth()->user()->runningPlan && @auth()->user()->plan_id == $plan->id): ?>
                <button disabled  data-id="<?php echo e($plan->id); ?>"  data-title="<?php echo e($plan->name); ?>"  data-price="<?php echo e($plan->price); ?>"
                    class="buyBtn align-middle select-none font-sans font-bold text-center uppercase transition-all disabled:opacity-50 disabled:shadow-none disabled:pointer-events-none text-xs py-2 px-4 shadow-blue-500/20 hover:shadow-lg hover:shadow-blue-500/40 focus:opacity-[0.85] focus:shadow-none active:opacity-[0.85] active:shadow-none block w-full bg-[#3e2f4a] text-white mt-4 border shadow-none rounded-lg"
                    type="button"> Already Buy </button>
            <?php else: ?>
            <button  data-id="<?php echo e($plan->id); ?>"  data-title="<?php echo e($plan->name); ?>"  data-price="<?php echo e($plan->price); ?>"
                class="buyBtn align-middle select-none font-sans font-bold text-center uppercase transition-all disabled:opacity-50 disabled:shadow-none disabled:pointer-events-none text-xs py-2 px-4 shadow-blue-500/20 hover:shadow-lg hover:shadow-blue-500/40 focus:opacity-[0.85] focus:shadow-none active:opacity-[0.85] active:shadow-none block w-full bg-[#4f308e] text-white mt-4 border shadow-none rounded-lg"
                type="button">Purchase now </button>
            <?php endif; ?>
                               
        </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
       

    </div>
</div>

<div id="BuyModal" data-floating-ui-portal="" style="display: none;">
    <div style="position: fixed; overflow: auto; inset: 0px; z-index: 9999;"><span data-type="inside" tabindex="0"
            aria-hidden="true" data-floating-ui-focus-guard="" data-aria-hidden="true"
            style="border: 0px; clip: rect(0px, 0px, 0px, 0px); height: 1px; margin: -1px; overflow: hidden; padding: 0px; position: fixed; white-space: nowrap; width: 1px; top: 0px; left: 0px;"></span>
        <div class="grid place-items-center fixed w-screen h-screen bg-black bg-opacity-60 backdrop-blur-sm"
            style="opacity: 1;">
            <form action="<?php echo e(route('user.buyPlan')); ?>" method="POST">
             <?php echo csrf_field(); ?>
                <input type="hidden" name="id">
                <div tabindex="-1"
                    class="relative bg-white mx-10 rounded- shadow-2xl text-blue-gray-500 antialiased font-sans text-base font-light leading-relaxed w-3/4 min-w-[75%] max-w-[75%]"
                    aria-labelledby=":r0:-label" aria-describedby=":r0:-description" id=":r1:" role="dialog"
                    style="opacity: 1; transform: none;">
                    <div
                        class="flex items-center shrink-0 p-4 text-blue-gray-900 antialiased font-sans text-2xl font-semibold leading-snug">
                        Do you want to buy this Package??</div>
                    <div
                        class="relative p-4 text-blue-gray-500 antialiased font-sans text-base font-light leading-relaxed border-t border-t-blue-gray-100 border-b border-b-blue-gray-100 min-w-full">
                        <h2 class="text-black" id="content"></h2>
                    </div>
                    <div class="flex items-center justify-end shrink-0 flex-wrap p-4 text-blue-gray-500"><button id="cancel"
                            class="align-middle select-none font-sans font-bold text-center uppercase transition-all disabled:opacity-50 disabled:shadow-none disabled:pointer-events-none text-xs py-3 px-6 rounded- text-green-500 hover:bg-green-500/10 active:bg-green-500/30 mr-1"
                            type="button"><span>Cancel</span></button><button
                            class="align-middle select-none font-sans font-bold text-center uppercase transition-all disabled:opacity-50 disabled:shadow-none disabled:pointer-events-none text-xs py-3 px-6 shadow-blue-500/20 hover:shadow- hover:shadow-blue-500/40 focus:opacity-[0.85] focus:shadow-none active:opacity-[0.85] active:shadow-none hover:bg-[#4f308e] hover:text-white bg-transparent border border-[#4f308e] shadow-none text-[#777] flex gap-3 justify-center items-center rounded-full"
                            type="submit">Buy now</button></div>
                </div>
            </form>
        </div><span data-type="inside" tabindex="0" aria-hidden="true" data-floating-ui-focus-guard="" data-aria-hidden="true"
            style="border: 0px; clip: rect(0px, 0px, 0px, 0px); height: 1px; margin: -1px; overflow: hidden; padding: 0px; position: fixed; white-space: nowrap; width: 1px; top: 0px; left: 0px;"></span>
    </div>
</div>


  <div id="BuyModeal" class="modal fade" style="display: none;" role="dialog">
        <div class="modal-dialog">

            <!-- Modal content-->
            <div class="modal-content"style="margin-top: 50%;">
                <div class="modal-header">
                    <h4 class="modal-title">Confirmation</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form action="<?php echo e(route('user.buyPlan')); ?>" method="POST">
                    <div class="modal-body text-center">

                        <input type="hidden" name="_token" value="4n2Ufs2XQzTgxwXUiuxmt76iPF4kLdWZTehJ7LZS">
                        <div class="form-group m-0">
                            
                        </div>
                        <strong>Are you sure to Buy this plan ?</strong>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Confirm</button>
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                    </div>

                </form>
            </div>

        </div>
    </div>
</div>   
<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
    <style>
        .package-disabled {
            opacity: 0.5;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
<script src="<?php echo e(asset('assets/front/js/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/front/js/popper.min.js')); ?>"></script>
     
<link rel="stylesheet" href="<?php echo e(asset('assets/front/css/iziToast.min.css')); ?>">
<script src="<?php echo e(asset('assets/front/js/iziToast.min.js')); ?>"></script>

<script type="text/javascript">
    (function($,document){
        "use strict";
                        function notify(status,message) {
            iziToast[status]({
                message: message,
                position: "topRight"
            });
        }
    })(jQuery);
</script>

  <script type="text/javascript">
    (function ($) {
        "use strict";
    	$('.buyBtn').click(function(){
    		$('#BuyModal').css('display', 'block');
    		$('#BuyModal').find('input[name=id]').val($(this).data('id'));
    		let content = $(this).data('title')+' = '+ $(this).data('price');
    		$('#content').text(content);
    // 		modal.modal('show');
    	});
    	$('#cancel').click(function(){
    		$('#BuyModal').css('display', 'none');
    // 		$('#BuyModal').find('input[name=id]').val($(this).data('id'));
    // 		modal.modal('show');
    	});
    })(jQuery);
</script>

    <script type="text/javascript">
        (function($) {
            "use strict";
            $('.buyBtn').click(function() {
                let symbol = '<?php echo e($general->cur_sym); ?>';
                let currency = '<?php echo e($general->cur_text); ?>';
                $('.gateway-info').addClass('d-none');
                let modal = $('#BuyModal');
                let plan = $(this).data('plan')
                modal.find('.planName').text(plan.name)
                modal.find('[name=id]').val(plan.id)
                let planPrice = parseFloat(plan.price).toFixed(2);
                modal.find('[name=amount]').val(planPrice);
                modal.find('[name=amount]').attr('readonly', true);

                modal.find('.dailyLimit').html(`Daily Ads Limit:<span class="text-danger"> ${plan.daily_limit}</span>`)
                modal.find('.refLevel').html(`Referral Level: <span class="text-danger">${plan.ref_level} </span>`)
                modal.find('.validity').html(`Plan Validity:  <span class="text-danger"> ${plan.validity} Days </span>`)

                $('[name=amount]').on('input', function() {
                    $('[name=wallet_type]').trigger('change');
                })

                $('[name=wallet_type]').change(function() {
                    var amount = $('[name=amount]').val();
                    if ($(this).val() != 'deposit_wallet' && $(this).val() != 'interest_wallet' && amount) {
                        var resource = $('select[name=wallet_type] option:selected').data('gateway');
                        var fixed_charge = parseFloat(resource.fixed_charge);
                        var percent_charge = parseFloat(resource.percent_charge);
                        var charge = parseFloat(fixed_charge + (amount * percent_charge / 100)).toFixed(2);
                        $('.charge').text(charge);
                        $('.rate').text(parseFloat(resource.rate));
                        $('.gateway-info').removeClass('d-none');
                        if (resource.currency == '<?php echo e($general->cur_text); ?>') {
                            $('.rate-info').addClass('d-none');
                        } else {
                            $('.rate-info').removeClass('d-none');
                        }
                        $('.method_currency').text(resource.currency);
                        $('.total').text(parseFloat(charge) + parseFloat(amount));
                    } else {
                        $('.gateway-info').addClass('d-none');
                    }
                });
                modal.find('input[name=id]').val(plan.id);
                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make($activeTemplate.'layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ecmrce/public_html/core/resources/views/templates/smartlab/plans.blade.php ENDPATH**/ ?>