
<?php $__env->startSection('panel'); ?>
<div class="row">
  <div class="col-md-12">
    <div class="card">
        <div class="card-body p-0">
            <div class="table-responsive--sm">
                <table class="table table--light style--two">
                    <thead>
                        <tr>
                            <th scope="col"><?php echo app('translator')->get('User'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Type'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Ad Title'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Description'); ?></th>
                            <th scope="col"><?php echo app('translator')->get('Action'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <span class="fw-bold"><?php echo e($report->user->fullname); ?></span>
                                    <br>
                                    <span class="small">
                                        <a href="<?php echo e(route('admin.users.detail', $report->user_id)); ?>"><span>@</span><?php echo e($report->user->username); ?></a>
                                    </span>
                                </td>
                                <td><?php echo e($report->type->name); ?></td>
                                <td><?php echo e($report->ptc->title); ?></td>
                                <td><?php echo e(strLimit($report->description, 50)); ?></td>
                                <td>
                                    <a href="<?php echo e(route('admin.ptc.edit', $report->ptc_id)); ?>" class="btn btn-outline--info">
                                        <i class="la la-eye"></i><?php echo app('translator')->get('View Ad'); ?>
                                    </a>
                                    <button type="button" class="btn btn-outline--primary ms-1 detailBtn" data-description="<?php echo e($report->description); ?>">
                                        <i class="la la-desktop"></i> <?php echo app('translator')->get('Details'); ?>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php if($reports->hasPages()): ?>
        <div class="card-footer">
            <?php echo e(paginateLinks($reports)); ?>

        </div>
        <?php endif; ?>
    </div>
  </div>
</div>

<div class="modal fade" id="detailModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo app('translator')->get('Report Description'); ?></h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <div class="modal-body">
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($){
            "use strict";
            $('.detailBtn').on('click', function() {
                var modal = $('#detailModal');
                modal.find('.modal-body').text( $(this).data('description') );
                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.search-form','data' => ['placeholder' => 'Ad title or Type']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('search-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['placeholder' => 'Ad title or Type']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ecmrce/public_html/core/resources/views/admin/ptc/report/log.blade.php ENDPATH**/ ?>