@extends($activeTemplate.'layouts.app')
@section('panel')
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <script src="https://cdn.tailwindcss.com"></script>
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Kanit:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
        <style>
            * {
                font-family: Kanit,cursive;
                -webkit-touch-callout: none;
                -webkit-user-select: none;
                -moz-user-select: none;
                user-select: none;
                box-sizing: border-box;
                padding: 0;
                margin: 0;
            }

            #nprogress {
                pointer-events: none;
            }

            #nprogress .bar {
                background: #B72B41;
                position: fixed;
                z-index: 9999;
                top: 0;
                left: 0;
                width: 100%;
                height: 3px;
            }

            #nprogress .peg {
                display: block;
                position: absolute;
                right: 0px;
                width: 100px;
                height: 100%;
                box-shadow: 0 0 10px #B72B41, 0 0 5px #B72B41;
                opacity: 1;
                -webkit-transform: rotate(3deg) translate(0px, -4px);
                -ms-transform: rotate(3deg) translate(0px, -4px);
                transform: rotate(3deg) translate(0px, -4px);
            }

            #nprogress .spinner {
                display: block;
                position: fixed;
                z-index: 1031;
                top: 15px;
                right: 15px;
            }

            #nprogress .spinner-icon {
                width: 18px;
                height: 18px;
                box-sizing: border-box;
                border: solid 2px transparent;
                border-top-color: #B72B41;
                border-left-color: #B72B41;
                border-radius: 50%;
                -webkit-animation: nprogresss-spinner 400ms linear infinite;
                animation: nprogress-spinner 400ms linear infinite;
            }

            .nprogress-custom-parent {
                overflow: hidden;
                position: relative;
            }

            .nprogress-custom-parent #nprogress .spinner, .nprogress-custom-parent #nprogress .bar {
                position: absolute;
            }

            @-webkit-keyframes nprogress-spinner {
                0% {
                    -webkit-transform: rotate(0deg);
                }

                100% {
                    -webkit-transform: rotate(360deg);
                }
            }

            @keyframes nprogress-spinner {
                0% {
                    transform: rotate(0deg);
                }

                100% {
                    transform: rotate(360deg);
                }
            }
        </style>
    </head>
    <body>
        <div class="min-h-screen bg-[#ebebeb] pb-10">
            <a href="{{route('user.home')}}" class="h-14 w-full bg-[#4f308e] pl-4  gap-5 shadow text-white flex items-center ">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true" class="h-7 font-bold cursor-pointer w-7">
                    <path fill-rule="evenodd" d="M7.72 12.53a.75.75 0 010-1.06l7.5-7.5a.75.75 0 111.06 1.06L9.31 12l6.97 6.97a.75.75 0 11-1.06 1.06l-7.5-7.5z" clip-rule="evenodd"></path>
                </svg>
                <h2 class="text-xl font-bold text-white">Deposit </h2>
            </a>
            <div class="flex justify-center m-5 p-4 bg-white rounded-lg py-5 shadow hind">নোটিশ: মিনিমাম ডিপোজিট ৫০০ টাকা।</div>
          
            <form action="{{route('user.deposit.insert')}}" method="post">
                @csrf
                <input type="hidden" name="currency" class="edit-currency" value="">
                <input type="hidden" name="method_code" class="edit-method-code" value="">
                
              <div class="flex flex-col items-center justify-center m-5 p-4 bg-white rounded-lg py-5 shadow">
                    <h2 class="mb-3 text-lg">Select Payment Method</h2>
                    <div class="flex gap-5">
                        @foreach($gatewayCurrency as $data)
                         <div class="deposit p-3 relative rounded-lg cursor-pointer border-4 border-gray-300" data-id="{{$data->method_code}}" data-resource="{{$data}}" data-base_symbol="" onclick="toggleElements()">
                            <img src="/bkng.png" alt="" class="h-8  w-8 mx-auto">
                            <h2 class=" text-[#4f308e] text-sm font-bold">{{$data->name}} </h2>
                        </div>
                        @endforeach
                       
                    </div>
                </div>   
                
                <div class="flex flex-col items-center justify-center m-5 p-4 bg-white rounded-lg py-5 shadow">
                    <h2 class="mb-3  text-xl ">Amount</h2>
                    <div class="flex w-full max-w-lg items-center border justify-center border-gray-300 rounded-lg overflow-hidden">
                        <div class="h-12 w-12 flex items-center justify-center border-r border-gray-300">
                            <svg stroke="currentColor" fill="currentColor" stroke-width="0" viewBox="0 0 640 512" class="h-8 cursor-pointer w-6 text-gray-900" height="1em" width="1em" xmlns="http://www.w3.org/2000/svg">
                                <path d="M320 144c-53.02 0-96 50.14-96 112 0 61.85 42.98 112 96 112 53 0 96-50.13 96-112 0-61.86-42.98-112-96-112zm40 168c0 4.42-3.58 8-8 8h-64c-4.42 0-8-3.58-8-8v-16c0-4.42 3.58-8 8-8h16v-55.44l-.47.31a7.992 7.992 0 0 1-11.09-2.22l-8.88-13.31a7.992 7.992 0 0 1 2.22-11.09l15.33-10.22a23.99 23.99 0 0 1 13.31-4.03H328c4.42 0 8 3.58 8 8v88h16c4.42 0 8 3.58 8 8v16zM608 64H32C14.33 64 0 78.33 0 96v320c0 17.67 14.33 32 32 32h576c17.67 0 32-14.33 32-32V96c0-17.67-14.33-32-32-32zm-16 272c-35.35 0-64 28.65-64 64H112c0-35.35-28.65-64-64-64V176c35.35 0 64-28.65 64-64h416c0 35.35 28.65 64 64 64v160z"></path>
                            </svg>
                        </div>
                        <div class="relative w-full min-w-[200px] h-11">
                            <input placeholder="Enter Amount" id="amount" required name="amount" type="number" class="peer w-full h-full bg-transparent text-blue-gray-700 font-sans font-normal outline outline-0 focus:outline-0 disabled:bg-blue-gray-50 disabled:border-0 transition-all placeholder-shown:border placeholder-shown:border-blue-gray-200 placeholder-shown:border-t-blue-gray-200 border focus:border-2 border-t-transparent focus:border-t-transparent text-sm px-3 py-3 rounded-md border-blue-gray-200 focus:border-green-500 !border !border-gray-300 focus:border-none border-none bg-white text-gray-900  placeholder:text-gray-500 focus:!border-gray-900 focus:!border-t-gray-900 " value="">
                            <label class="flex w-full h-full select-none pointer-events-none absolute left-0 font-normal peer-placeholder-shown:text-blue-gray-500 leading-tight peer-focus:leading-tight peer-disabled:text-transparent peer-disabled:peer-placeholder-shown:text-blue-gray-500 transition-all -top-1.5 peer-placeholder-shown:text-sm text-[11px] peer-focus:text-[11px] before:content[' '] before:block before:box-border before:w-2.5 before:h-1.5 before:mt-[6.5px] before:mr-1 peer-placeholder-shown:before:border-transparent before:rounded-tl-md before:border-t peer-focus:before:border-t-2 before:border-l peer-focus:before:border-l-2 before:pointer-events-none before:transition-all peer-disabled:before:border-transparent after:content[' '] after:block after:flex-grow after:box-border after:w-2.5 after:h-1.5 after:mt-[6.5px] after:ml-1 peer-placeholder-shown:after:border-transparent after:rounded-tr-md after:border-t peer-focus:after:border-t-2 after:border-r peer-focus:after:border-r-2 after:pointer-events-none after:transition-all peer-disabled:after:border-transparent peer-placeholder-shown:leading-[4.1] text-blue-gray-400 peer-focus:text-green-500 before:border-blue-gray-200 peer-focus:before:!border-green-500 after:border-blue-gray-200 peer-focus:after:!border-green-500 hidden">Mobile
                        Number </label>
                        </div>
                    </div>
                    <p class="text-red-500 text-sm text-left w-full mt-1">Minimum deposit 500 BDT</p>
                    <div class="mt-5 flex justify-center gap-3 flex-wrap">
                        <div onclick="addAmount(500)" class="relative grid items-center font-sans font-bold uppercase whitespace-nowrap select-none border border-blue-500 text-blue-700 py-1.5 px-3 text-xs rounded-lg cursor-pointer" style="opacity: 1;">
                            <span class="">500</span>
                        </div>
                        <div onclick="addAmount(1000)" class="relative grid items-center font-sans font-bold uppercase whitespace-nowrap select-none border border-blue-500 text-blue-700 py-1.5 px-3 text-xs rounded-lg cursor-pointer" style="opacity: 1;">
                            <span class="">1000</span>
                        </div>
                        <div onclick="addAmount(2000)" class="relative grid items-center font-sans font-bold uppercase whitespace-nowrap select-none border border-blue-500 text-blue-700 py-1.5 px-3 text-xs rounded-lg cursor-pointer" style="opacity: 1;">
                            <span class="">2000</span>
                        </div>
                        <div onclick="addAmount(3000)" class="relative grid items-center font-sans font-bold uppercase whitespace-nowrap select-none border border-blue-500 text-blue-700 py-1.5 px-3 text-xs rounded-lg cursor-pointer" style="opacity: 1;">
                            <span class="">3000</span>
                        </div>
                        <div onclick="addAmount(5000)" class="relative grid items-center font-sans font-bold uppercase whitespace-nowrap select-none border border-blue-500 text-blue-700 py-1.5 px-3 text-xs rounded-lg cursor-pointer" style="opacity: 1;">
                            <span class="">5000</span>
                        </div>
                        <div onclick="addAmount(9000)" class="relative grid items-center font-sans font-bold uppercase whitespace-nowrap select-none border border-blue-500 text-blue-700 py-1.5 px-3 text-xs rounded-lg cursor-pointer" style="opacity: 1;">
                            <span class="">9000</span>
                        </div>
                        <div onclick="addAmount(15000)" class="relative grid items-center font-sans font-bold uppercase whitespace-nowrap select-none border border-blue-500 text-blue-700 py-1.5 px-3 text-xs rounded-lg cursor-pointer" style="opacity: 1;">
                            <span class="">15000</span>
                        </div>
                        <div onclick="addAmount(18000)" class="relative grid items-center font-sans font-bold uppercase whitespace-nowrap select-none border border-blue-500 text-blue-700 py-1.5 px-3 text-xs rounded-lg cursor-pointer" style="opacity: 1;">
                            <span class="">18000</span>
                        </div>
                        <div onclick="addAmount(25000)" class="relative grid items-center font-sans font-bold uppercase whitespace-nowrap select-none border border-blue-500 text-blue-700 py-1.5 px-3 text-xs rounded-lg cursor-pointer" style="opacity: 1;">
                            <span class="">25000</span>
                        </div>
                    </div>
                </div>
              
                <div class="m-5">
                    <button type="submit" class="align-middle select-none font-sans font-bold text-center uppercase transition-all disabled:opacity-50 disabled:shadow-none disabled:pointer-events-none text-xs py-3 px-6 text-white shadow-blue-500/20 hover:shadow-lg hover:shadow-blue-500/40 focus:opacity-[0.85] focus:shadow-none active:opacity-[0.85] active:shadow-none w-full hover:bg-[#4f308e] mt-6 bg-[#4f308e] shadow-none flex gap-3 justify-center items-center rounded-full">Next</button>
                </div>
            </form>
        </div>
        <div style="display:none; justify-content:center; align-items:center;">
            <span class="balance-text">Total Deposit: 0 Taka </span>
        </div>
        <section class="cmn-section" style="display:none;">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-md-12"></div>
                    <div class="row">
                        <div class="card-4">
                            <button style="background: #2dcd89  ;color: #fff;" type="button" data-id="1" data-resource="{&quot;id&quot;:1,&quot;name&quot;:&quot;Nagad&quot;,&quot;binance_id&quot;:null,&quot;currency&quot;:&quot;Taka&quot;,&quot;symbol&quot;:&quot;&quot;,&quot;method_code&quot;:1000,&quot;gateway_alias&quot;:&quot;nagad&quot;,&quot;min_amount&quot;:&quot;500.00000000&quot;,&quot;max_amount&quot;:&quot;25000.00000000&quot;,&quot;percent_charge&quot;:&quot;0.00&quot;,&quot;fixed_charge&quot;:&quot;0.00000000&quot;,&quot;rate&quot;:&quot;1.00000000&quot;,&quot;image&quot;:&quot;63173ef86893b1662467832.png&quot;,&quot;gateway_parameter&quot;:&quot;{\&quot;\\u099f\\u09cd\\u09b0\\u09be\\u09a8\\u099c\\u09c7\\u0995\\u09b6\\u09a8_\\u0986\\u0987\\u09a1\\u09bf\&quot;:{\&quot;field_name\&quot;:\&quot;\\u099f\\u09cd\\u09b0\\u09be\\u09a8\\u099c\\u09c7\\u0995\\u09b6\\u09a8_\\u0986\\u0987\\u09a1\\u09bf\&quot;,\&quot;field_level\&quot;:\&quot;\\u099f\\u09cd\\u09b0\\u09be\\u09a8\\u099c\\u09c7\\u0995\\u09b6\\u09a8 \\u0986\\u0987\\u09a1\\u09bf\&quot;,\&quot;type\&quot;:\&quot;text\&quot;,\&quot;validation\&quot;:\&quot;required\&quot;},\&quot;\\u09ae\\u09cb\\u09ac\\u09be\\u0987\\u09b2_\\u09a8\\u09be\\u09ae\\u09cd\\u09ac\\u09b0\&quot;:{\&quot;field_name\&quot;:\&quot;\\u09ae\\u09cb\\u09ac\\u09be\\u0987\\u09b2_\\u09a8\\u09be\\u09ae\\u09cd\\u09ac\\u09b0\&quot;,\&quot;field_level\&quot;:\&quot;\\u09ae\\u09cb\\u09ac\\u09be\\u0987\\u09b2 \\u09a8\\u09be\\u09ae\\u09cd\\u09ac\\u09b0\&quot;,\&quot;type\&quot;:\&quot;text\&quot;,\&quot;validation\&quot;:\&quot;required\&quot;}}&quot;,&quot;created_at&quot;:&quot;2022-09-06T15:27:13.000000Z&quot;,&quot;updated_at&quot;:&quot;2024-05-24T10:54:22.000000Z&quot;,&quot;method&quot;:{&quot;id&quot;:37,&quot;code&quot;:&quot;1000&quot;,&quot;alias&quot;:&quot;nagad&quot;,&quot;image&quot;:&quot;63173ef86893b1662467832.png&quot;,&quot;name&quot;:&quot;Nagad&quot;,&quot;status&quot;:true,&quot;parameters&quot;:&quot;[]&quot;,&quot;supported_currencies&quot;:&quot;[]&quot;,&quot;crypto&quot;:0,&quot;extra&quot;:{&quot;delay&quot;:null},&quot;description&quot;:&quot;01404731040&quot;,&quot;input_form&quot;:{&quot;\u099f\u09cd\u09b0\u09be\u09a8\u099c\u09c7\u0995\u09b6\u09a8_\u0986\u0987\u09a1\u09bf&quot;:{&quot;field_name&quot;:&quot;\u099f\u09cd\u09b0\u09be\u09a8\u099c\u09c7\u0995\u09b6\u09a8_\u0986\u0987\u09a1\u09bf&quot;,&quot;field_level&quot;:&quot;\u099f\u09cd\u09b0\u09be\u09a8\u099c\u09c7\u0995\u09b6\u09a8 \u0986\u0987\u09a1\u09bf&quot;,&quot;type&quot;:&quot;text&quot;,&quot;validation&quot;:&quot;required&quot;},&quot;\u09ae\u09cb\u09ac\u09be\u0987\u09b2_\u09a8\u09be\u09ae\u09cd\u09ac\u09b0&quot;:{&quot;field_name&quot;:&quot;\u09ae\u09cb\u09ac\u09be\u0987\u09b2_\u09a8\u09be\u09ae\u09cd\u09ac\u09b0&quot;,&quot;field_level&quot;:&quot;\u09ae\u09cb\u09ac\u09be\u0987\u09b2 \u09a8\u09be\u09ae\u09cd\u09ac\u09b0&quot;,&quot;type&quot;:&quot;text&quot;,&quot;validation&quot;:&quot;required&quot;}},&quot;created_at&quot;:&quot;2022-09-06T15:27:13.000000Z&quot;,&quot;updated_at&quot;:&quot;2024-05-24T10:54:22.000000Z&quot;}}" data-base_symbol="" class=" btn deposit cmn-btn w-100" onclick="toggleElements()">Nagad </button>
                        </div>
                    </div>
                    <div class="row">
                        <div class="card-4">
                            <button style="background: #2dcd89  ;color: #fff;" type="button" data-id="14" data-resource="{&quot;id&quot;:14,&quot;name&quot;:&quot;Rocket&quot;,&quot;binance_id&quot;:null,&quot;currency&quot;:&quot;BDT&quot;,&quot;symbol&quot;:&quot;&quot;,&quot;method_code&quot;:1013,&quot;gateway_alias&quot;:&quot;rocket&quot;,&quot;min_amount&quot;:&quot;500.00000000&quot;,&quot;max_amount&quot;:&quot;25000.00000000&quot;,&quot;percent_charge&quot;:&quot;0.00&quot;,&quot;fixed_charge&quot;:&quot;0.00000000&quot;,&quot;rate&quot;:&quot;1.00000000&quot;,&quot;image&quot;:&quot;664dc304ddf521716372228.jpeg&quot;,&quot;gateway_parameter&quot;:&quot;{\&quot;trnx_number\&quot;:{\&quot;field_name\&quot;:\&quot;trnx_number\&quot;,\&quot;field_level\&quot;:\&quot;Trnx number\&quot;,\&quot;type\&quot;:\&quot;text\&quot;,\&quot;validation\&quot;:\&quot;required\&quot;}}&quot;,&quot;created_at&quot;:&quot;2024-05-22T10:03:48.000000Z&quot;,&quot;updated_at&quot;:&quot;2024-05-22T10:03:48.000000Z&quot;,&quot;method&quot;:{&quot;id&quot;:50,&quot;code&quot;:&quot;1013&quot;,&quot;alias&quot;:&quot;rocket&quot;,&quot;image&quot;:&quot;664dc304ddf521716372228.jpeg&quot;,&quot;name&quot;:&quot;Rocket&quot;,&quot;status&quot;:true,&quot;parameters&quot;:&quot;[]&quot;,&quot;supported_currencies&quot;:&quot;[]&quot;,&quot;crypto&quot;:0,&quot;extra&quot;:{&quot;delay&quot;:null},&quot;description&quot;:&quot;01979121463&quot;,&quot;input_form&quot;:{&quot;trnx_number&quot;:{&quot;field_name&quot;:&quot;trnx_number&quot;,&quot;field_level&quot;:&quot;Trnx number&quot;,&quot;type&quot;:&quot;text&quot;,&quot;validation&quot;:&quot;required&quot;}},&quot;created_at&quot;:&quot;2024-05-22T10:03:48.000000Z&quot;,&quot;updated_at&quot;:&quot;2024-05-22T10:03:55.000000Z&quot;}}" data-base_symbol="" class=" btn deposit cmn-btn w-100" onclick="toggleElements()">Rocket </button>
                        </div>
                    </div>
                    <div class="row">
                        <div class="card-4">
                            <button style="background: #2dcd89  ;color: #fff;" type="button" data-id="16" data-resource="{&quot;id&quot;:16,&quot;name&quot;:&quot;Bkash&quot;,&quot;binance_id&quot;:null,&quot;currency&quot;:&quot;BDT&quot;,&quot;symbol&quot;:&quot;&quot;,&quot;method_code&quot;:1015,&quot;gateway_alias&quot;:&quot;bkash&quot;,&quot;min_amount&quot;:&quot;500.00000000&quot;,&quot;max_amount&quot;:&quot;25000.00000000&quot;,&quot;percent_charge&quot;:&quot;0.00&quot;,&quot;fixed_charge&quot;:&quot;0.00000000&quot;,&quot;rate&quot;:&quot;1.00000000&quot;,&quot;image&quot;:&quot;6661ea24db45b1717692964.png&quot;,&quot;gateway_parameter&quot;:&quot;{\&quot;trnx_number\&quot;:{\&quot;field_name\&quot;:\&quot;trnx_number\&quot;,\&quot;field_level\&quot;:\&quot;Trnx number\&quot;,\&quot;type\&quot;:\&quot;text\&quot;,\&quot;validation\&quot;:\&quot;required\&quot;}}&quot;,&quot;created_at&quot;:&quot;2024-06-06T16:56:05.000000Z&quot;,&quot;updated_at&quot;:&quot;2024-06-06T16:56:05.000000Z&quot;,&quot;method&quot;:{&quot;id&quot;:52,&quot;code&quot;:&quot;1015&quot;,&quot;alias&quot;:&quot;bkash&quot;,&quot;image&quot;:&quot;6661ea24db45b1717692964.png&quot;,&quot;name&quot;:&quot;Bkash&quot;,&quot;status&quot;:true,&quot;parameters&quot;:&quot;[]&quot;,&quot;supported_currencies&quot;:&quot;[]&quot;,&quot;crypto&quot;:0,&quot;extra&quot;:{&quot;delay&quot;:null},&quot;description&quot;:&quot;01979029179&quot;,&quot;input_form&quot;:{&quot;trnx_number&quot;:{&quot;field_name&quot;:&quot;trnx_number&quot;,&quot;field_level&quot;:&quot;Trnx number&quot;,&quot;type&quot;:&quot;text&quot;,&quot;validation&quot;:&quot;required&quot;}},&quot;created_at&quot;:&quot;2024-06-06T16:56:05.000000Z&quot;,&quot;updated_at&quot;:&quot;2024-06-06T16:56:14.000000Z&quot;}}" data-base_symbol="" class=" btn deposit cmn-btn w-100" onclick="toggleElements()">Bkash </button>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <div id="bottom-elemens" style="display:none;">
            <div class="modal-dialog" role="document">
                <div class="modal-content" style="
            margin-top: 30%;
        ">
                    <div class="modal-header">
                        <strong class="modal-title method-name" id="exampleModalLabel"></strong>
                        <button onclick="toggleElements()">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>
                    <form action="{{route('user.deposit.insert')}}" method="post">
                       @csrf
                        <div class="modal-body">
                            <div class="form-group">
                                <input type="hidden" name="currency" class="edit-currency" value="">
                                <input type="hidden" name="method_code" class="edit-method-code" value="">
                            </div>
                            <div class="form-group">
                                <label>Enter Amount:</label>
                                <div class="input-group">
                                    <input id="amount" type="text" class="form-control form-control-lg" onkeyup="this.value = this.value.replace (/^\.|[^\d\.]/g, '')" name="amount" placeholder="0.00" required="" value="">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text currency-addon addon-bg">Taka</span>
                                    </div>
                                </div>
                            </div>
                            <span>Limit                                        : 500
                                           - 25000 Taka</span>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary">Confirm</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    function nl2br(str) {
        return str.replace(/\n/g, '<br>');
    }

    document.addEventListener('DOMContentLoaded', function() {
        const notice = `<div class="explain">                            _______________________ <p>🔰 ২০০০৳ ডিপোজিট করলে ১০০০৳ বোনাস </p>_______________________                             <p>🔰 ৫০০০৳ ডিপোজিট করলে ৭০০০৳ বোনাস</p> _______________________                      <p>🔰 ১০০০০৳ ডিপোজিট করলে ২০০০০৳ বোনাস </p>   _______________________                                                   </div>`;
        const formattedNotice = nl2br(notice);

        if (notice !== 'No new notifications') {  
            Swal.fire({
                html: `<p style="margin: 0; line-height: 1.5;">${formattedNotice}</p>`, 
                icon: 'info',
                confirmButtonText: 'Close',
                customClass: {
                    popup: 'custom-popup' 
                }
            });
        }
    });
</script>
        
</div>
<script src="{{asset('assets/front/js/jquery.min.js')}}"></script>
<script src="{{asset('assets/front/js/popper.min.js')}}"></script>
     
<link rel="stylesheet" href="{{asset('assets/front/css/iziToast.min.css')}}">
<script src="{{asset('assets/front/js/iziToast.min.js')}}"></script>

<script type="text/javascript">
    (function($, document) {
        "use strict";
        function notify(status, message) {
            iziToast[status]({
                message: message,
                position: "topRight"
            });
        }
    }
    )(jQuery);
</script>
<script>
    function addAmount(amount) {
        $('#amount').val(amount);
    }
</script>
<script>
    (function($, document) {
        "use strict";
        $(document).ready(function() {

            $('.deposit').on('click', function() {

                $(".deposit").removeClass("border-green-600");
                $(".deposit").addClass("border-gray-300");
                // Add the "border-green-600" class to the clicked element
                $(this).addClass("border-green-600");

                var id = $(this).data('id');
                var result = $(this).data('resource');
                var baseSymbol = "Taka";
                // var baseSymbol = $(this).data('base_symbol');

                $('.method-name').text(`Payment By  ${result.name}`);
                // $('.currency-addon').text(`${result.currency}`);
                $('.currency-addon').text(baseSymbol);

                $('.edit-currency').val(result.currency);
                $('.edit-method-code').val(result.method_code);

            });
        });
    }
    )(jQuery, document);
</script>
<script>
    function toggleElements() {
        var bottomElements = document.getElementById("bottom-elements");
        var toggleIcon = document.getElementById("toggle-icon");
        var toggleLabel = document.getElementById("toggle-label");
        var closeButton = document.querySelector("#bottom-elements button");
        if (bottomElements.style.display === "none") {
            bottomElements.style.display = "block";
            toggleIcon.classList.remove("fa-plus");
            toggleIcon.classList.add("fa-minus");
            toggleLabel.innerHTML = "Hide Elements";
        } else if (event.target === closeButton) {
            bottomElements.style.display = "none";
            toggleIcon.classList.remove("fa-minus");
            toggleIcon.classList.add("fa-plus");
            toggleLabel.innerHTML = "Show Elements";
        } else {
            bottomElements.style.display = "none";
            toggleIcon.classList.remove("fa-minus");
            toggleIcon.classList.add("fa-plus");
            toggleLabel.innerHTML = "Show Elements";
        }
    }
</script>
</body></html>
@endsection
