<?php

namespace App\Http\Controllers\Gateway\UniquePay;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Gateway\PaymentController;
use App\Models\Deposit;
use App\Models\Gateway;
use App\Constants\Status;

class ProcessController extends Controller
{
    public static function process($deposit)
    {
        $UniquePay = json_decode($deposit->gatewayCurrency()->gateway_parameter);
        $alias = $deposit->gateway->alias;

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://pay.uniquepaybd.com/request/payment/create',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => false,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => array(
                'cus_name' => auth()->user()->fullname,
                'cus_email' => auth()->user()->email,
                'amount' => getAmount($deposit->final_amo),
                'success_url' => route('ipn.' . $alias),
                'cancel_url' => route(gatewayRedirectUrl()),
            ),
            CURLOPT_HTTPHEADER => array(
                "app-key: {$UniquePay->app_key}",
                "secret-key: {$UniquePay->secret_key}",
                "host-name: {$_SERVER['HTTP_HOST']}",
            ),
        ));

        $response = curl_exec($curl);

        if (curl_errno($curl)) {
            $send['error'] = true;
            $send['message'] = 'cURL Error: ' . curl_error($curl);
            return json_encode($send);
        }

        curl_close($curl);

        echo $response;
    }

public function ipn()
{
    if ($_GET['success'] == 1) {
        $gateway = Gateway::where('alias', 'UniquePay')->first();
        $param = json_decode($gateway->gateway_parameters);
        
        $transactionId = $_GET['transactionId'];
        $appKey = $param->app_key->value;
        $secretKey = $param->secret_key->value;

        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://pay.uniquepaybd.com/request/payment/verify',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => false,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => array('transaction_id' => $transactionId),
          CURLOPT_HTTPHEADER => array(
              "app-key: {$appKey}",
              "secret-key: {$secretKey}",
              "host-name: {$_SERVER['HTTP_HOST']}",
          ),
        ));
        
        $response = curl_exec($curl);
        curl_close($curl);
        $responseData = json_decode($response, true);

        if (isset($responseData['cus_name'], $responseData['cus_email'], $responseData['amount'], $responseData['transaction_id'], $responseData['status'], $responseData['message'])) {
            $user = \App\Models\User::where('email', $responseData['cus_email'])->first();
            $deposit = Deposit::where('status', Status::PAYMENT_INITIATE)
                ->where('amount', $responseData['amount'])
                ->where('user_id', $user->id)
                ->orderBy('id', 'DESC')
                ->first();

            if ($responseData['status'] == '1') {
                PaymentController::userDataUpdate($deposit);
                $notify[] = ['success', 'Payment captured successfully.'];
                return redirect()->route(gatewayRedirectUrl(true))->withNotify($notify);
            } else {
                $notify[] = ['error', 'Payment failed: ' . $responseData['message']];
                return redirect()->route(gatewayRedirectUrl())->withNotify($notify);
            }
        } else {
            $notify[] = ['error', 'Invalid response from UniquePay API.'];
            return redirect()->route(gatewayRedirectUrl())->withNotify($notify);
        }
    } else {
        $notify[] = ['error', 'Invalid success value in IPN request.'];
        return redirect()->route(gatewayRedirectUrl())->withNotify($notify);
    }
}
}