<?php

namespace App\Http\Controllers\Gateway\Doniapay;

use App\Deposit;
use App\Http\Controllers\Gateway\PaymentController;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class ProcessController extends Controller
{
    /*
     * Doniapay Gateway
     */
    public static function process($deposit)
    {
        $donia = json_decode($deposit->gatewayCurrency()->gateway_parameter);
        $invoice_id = $deposit->trx;

        $data = [
            "success_url" => route('ipn.' . $deposit->gateway->alias) . "?inv=" . $invoice_id,
            "cancel_url" => route('user.home'),
            "metadata" => [
                "cus_name" => $deposit->user->username,
                "cus_email" => $deposit->user->email,
                "trx" => $invoice_id
            ],
            "amount" => number_format($deposit->final_amo, 2, '.', '')
        ];

        $header = [
            "api" => $donia->api_key,
            "url" => "https://secure.doniapay.com/api/payment/create"
        ];

        $res = self::payments($data, $header);
        $res = json_decode($res, true);

        if (isset($res['status']) && ($res['status'] === 'success' || $res['status'] == 1) && !empty($res['payment_url'])) {
            $send['redirect'] = true;
            $send['redirect_url'] = $res['payment_url'];
        } else {
            $send['error'] = true;
            $send['message'] = $res['message'] ?? "Payment initialization failed. Please contact support.";
        }

        return json_encode($send);
    }

    public function ipn()
    {
        $track = $_GET['inv'];
        $deposit = Deposit::where('trx', $track)->orderBy('id', 'DESC')->first();

        $donia = json_decode($deposit->gatewayCurrency()->gateway_parameter);

        $header = [
            "api" => $donia->api_key,
            "url" => "https://secure.doniapay.com/api/payment/verify"
        ];

        $trxId = $_GET['transactionId'];
        $data = [
            "transaction_id" => $trxId
        ];

        $response = self::payments($data, $header);
        $res = json_decode($response, true);

        if (isset($res['status']) && strtolower($res['status']) === 'completed') {
            PaymentController::userDataUpdate($deposit->trx);
            $notify[] = ['success', 'Transaction was successful.'];
            return redirect()->route('user.home')->withNotify($notify);
        }

        session()->forget('deposit_id');
        session()->forget('payment_id');

        $notify[] = ['error', 'Invalid request.'];
        return redirect()->route(gatewayRedirectUrl())->withNotify($notify);
    }

    public static function payments($data = "", $header = '')
    {
        $headers = [
            'Content-Type: application/json',
            'donia-apikey: ' . $header['api']
        ];

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => $header['url'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => $headers
        ]);

        $response = curl_exec($curl);

        if (curl_errno($curl)) {
            $error = curl_error($curl);
            curl_close($curl);
            return json_encode(['status' => 'error', 'message' => $error]);
        }

        curl_close($curl);
        return $response;
    }
}
